/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table;

import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.data.DataRow;
import de.riwagis.riwadatatable.filter.DataTableQuery;
import de.riwagis.riwadatatable.table.DbTable;
import de.riwagis.riwadatatable.table.extension.DbTableExtender;
import de.riwagis.riwadatatable.table.extension.DbTableOperationExtender;
import de.riwagis.riwadatatable.table.extension.DbTableOperationInfo;
import de.riwagis.riwadatatable.table.extension.DbTableOperationType;
import de.riwagis.util.exception.SystemException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbTableOperationHandler
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DbTableOperationHandler.class);
    private final DbTable dbTable;
    private final List<DbTableOperationExtender> operations = new ArrayList<DbTableOperationExtender>();

    DbTableOperationHandler(DbTable dbTable, Collection<DbTableExtender> extenders, DbTableOperationType type, Connection conn) throws SystemException {
        this.dbTable = dbTable;
        for (DbTableExtender extender : extenders) {
            DbTableOperationExtender ope = extender.createOperationExtender(type, conn);
            if (ope == null) continue;
            this.operations.add(ope);
        }
    }

    public static DataRow cloneRowNullsafe(DataRow row) {
        return row != null ? new DataRow(row) : null;
    }

    public static DataTableQuery cloneQueryNullsafe(DataTableQuery query) {
        return query != null ? new DataTableQuery(query) : null;
    }

    public static <T> Collection<T> unmodifiableCollectionNullsafe(Collection<T> col) {
        return col != null ? Collections.unmodifiableCollection(col) : null;
    }

    public void addColumns2Row(DbTableOperationType type, Connection conn, DataRow row, DataTableQuery query) throws SystemException {
        Collection<String> columnsToAdd = this.extendColumns4Operation(type, conn, row.getColumnsCollection(), row, query);
        for (String columnName : columnsToAdd) {
            TableColumn col2add = this.dbTable.getColumn(columnName);
            row.addColumn(row.getColumnCount(), col2add, null);
        }
    }

    public void checkAllowed(DbTableOperationType type, Connection conn, Collection<TableColumn> columns, DataRow row, DataTableQuery query) throws SystemException {
        String opAllowed = this.isOperationAllowed(type, conn, columns, row, query);
        if (opAllowed != null) {
            throw new SystemException(opAllowed);
        }
    }

    public Collection<String> extendColumns4Operation(DbTableOperationType type, Connection conn, Collection<TableColumn> columns, DataRow row, DataTableQuery query) throws SystemException {
        HashSet<String> columnNames = new HashSet<String>();
        if (!this.operations.isEmpty()) {
            DbTableOperationInfo ai = new DbTableOperationInfo(type, this.dbTable, conn, 0);
            for (DbTableOperationExtender ope : this.operations) {
                Collection<String> cols2add = ope.extendColumns4Operation(ai, DbTableOperationHandler.unmodifiableCollectionNullsafe(columns));
                if (cols2add == null) continue;
                columnNames.addAll(cols2add);
            }
        }
        return columnNames;
    }

    public DataRow adjustDataRow4Operation(DbTableOperationType type, Connection conn, DataRow row, DataTableQuery query) throws SystemException {
        DataRow res = row;
        if (!this.operations.isEmpty()) {
            for (DbTableOperationExtender ope : this.operations) {
                DbTableOperationInfo ai = new DbTableOperationInfo(type, this.dbTable, conn, 0);
                res = ope.adjustDataRow4Operation(ai, res);
            }
        }
        return res;
    }

    public DataTableQuery adjustFilter4Operation(DbTableOperationType type, Connection conn, Collection<TableColumn> columns, DataRow row, DataTableQuery query) throws SystemException {
        DataTableQuery res = query;
        if (!this.operations.isEmpty()) {
            DataRow nullsaveRow = DbTableOperationHandler.cloneRowNullsafe(row);
            Collection<TableColumn> nullsaveColumns = DbTableOperationHandler.unmodifiableCollectionNullsafe(columns);
            for (DbTableOperationExtender ope : this.operations) {
                DbTableOperationInfo ai = new DbTableOperationInfo(type, this.dbTable, conn, 0);
                res = ope.adjustFilter4Operation(ai, res, nullsaveColumns, nullsaveRow);
            }
        }
        return res;
    }

    public String isOperationAllowed(DbTableOperationType type, Connection conn, Collection<TableColumn> columns, DataRow row, DataTableQuery query) throws SystemException {
        if (!this.operations.isEmpty()) {
            DbTableOperationInfo ai = new DbTableOperationInfo(type, this.dbTable, conn, 0);
            for (DbTableOperationExtender ope : this.operations) {
                String infoText = ope.isOperationAllowed(ai, DbTableOperationHandler.cloneQueryNullsafe(query), DbTableOperationHandler.unmodifiableCollectionNullsafe(columns), DbTableOperationHandler.cloneRowNullsafe(row));
                if (infoText == null) continue;
                return infoText;
            }
        }
        return null;
    }

    public void beforeOperation(DbTableOperationType type, Connection conn, Collection<TableColumn> columns, DataRow row, DataTableQuery query, int rowsAffected) throws SystemException {
        if (!this.operations.isEmpty()) {
            DbTableOperationInfo ai = new DbTableOperationInfo(type, this.dbTable, conn, rowsAffected);
            for (DbTableOperationExtender ope : this.operations) {
                ope.beforeOperation(ai, DbTableOperationHandler.cloneQueryNullsafe(query), DbTableOperationHandler.unmodifiableCollectionNullsafe(columns), DbTableOperationHandler.cloneRowNullsafe(row));
            }
        }
    }

    public void afterOperation(DbTableOperationType type, Connection conn, Collection<TableColumn> columns, DataRow row, DataTableQuery query, int rowsAffected) throws SystemException {
        if (!this.operations.isEmpty()) {
            DbTableOperationInfo ai = new DbTableOperationInfo(type, this.dbTable, conn, rowsAffected);
            for (DbTableOperationExtender ope : this.operations) {
                ope.afterOperation(ai, DbTableOperationHandler.cloneQueryNullsafe(query), DbTableOperationHandler.unmodifiableCollectionNullsafe(columns), DbTableOperationHandler.cloneRowNullsafe(row));
            }
        }
    }

    public void closeQuietly() {
        for (DbTableOperationExtender ope : this.operations) {
            try {
                ope.close();
            }
            catch (Throwable t) {
                LOG.warn(String.format("error closing extender '%s': %s", ope, t.getMessage()), t);
            }
        }
    }

    @Override
    public void close() {
        this.closeQuietly();
    }
}

