/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table;

import de.riwagis.geotools.feature.util.FilterUtil;
import de.riwagis.riwadatatable.columns.ColumnFactory;
import de.riwagis.riwadatatable.columns.ColumnTypes;
import de.riwagis.riwadatatable.columns.ColumnUtils;
import de.riwagis.riwadatatable.columns.GeoColumn;
import de.riwagis.riwadatatable.columns.NumberColumn;
import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.columns.defaultvalues.ConstantDefaultValue;
import de.riwagis.riwadatatable.columns.defaultvalues.DefaultValue;
import de.riwagis.riwadatatable.columns.defaultvalues.SQLDefaultValue;
import de.riwagis.riwadatatable.columns.provider.ColumnProvider;
import de.riwagis.riwadatatable.columns.provider.MapBasedColumnProvider;
import de.riwagis.riwadatatable.data.ConnectionManagerDataRowReaderListener;
import de.riwagis.riwadatatable.data.DataRow;
import de.riwagis.riwadatatable.data.DataRowReader;
import de.riwagis.riwadatatable.data.DataRowReaderCollection;
import de.riwagis.riwadatatable.data.DataRowReaderResultSet;
import de.riwagis.riwadatatable.data.DataRowUtils;
import de.riwagis.riwadatatable.data.PreparedStatementDataRowReaderListener;
import de.riwagis.riwadatatable.filter.DataTableQuery;
import de.riwagis.riwadatatable.filter.geotools.DataTableGeotoolsFilterVisitor;
import de.riwagis.riwadatatable.jdbc.DBType;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionInfo;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionManager;
import de.riwagis.riwadatatable.sequence.TableSequenceHandler;
import de.riwagis.riwadatatable.sequence.TableSequenceHandlerUtils;
import de.riwagis.riwadatatable.table.DbTable;
import de.riwagis.riwadatatable.table.DbTableConnectionHandler;
import de.riwagis.riwadatatable.table.DbTableExtenderHandler;
import de.riwagis.riwadatatable.table.DbTableOperationHandler;
import de.riwagis.riwadatatable.table.DbTableSqlExceptionHandler;
import de.riwagis.riwadatatable.table.DbTableSqlExceptionHandlerDefault;
import de.riwagis.riwadatatable.table.DbTableUtils;
import de.riwagis.riwadatatable.table.DefaultTableDefinition;
import de.riwagis.riwadatatable.table.SpatialQueryType;
import de.riwagis.riwadatatable.table.TableDefinition;
import de.riwagis.riwadatatable.table.extension.DbTableExtender;
import de.riwagis.riwadatatable.table.extension.DbTableOperationType;
import de.riwagis.riwadatatable.table.extension.encoding.DbTableMysqlUTF8ToLatinExtender;
import de.riwagis.riwadatatable.table.extension.geom.DbTableMysqlGeomExtender;
import de.riwagis.riwadatatable.table.extension.locking.DbTableLockExtender;
import de.riwagis.riwadatatable.table.extension.logging.DbTableLoggingInDbExtender;
import de.riwagis.riwadatatable.table.extension.logging.DbTableLoggingSlf4jExtender;
import de.riwagis.riwadatatable.table.extension.presetvalues.DbTablePresetValuesExtender;
import de.riwagis.riwadatatable.table.userinfo.DbTableUserInfo;
import de.riwagis.riwadatatable.table.userinfo.DbTableUserInfoSystem;
import de.riwagis.riwadatatable.validation.ColumnProviderDataRowValidator;
import de.riwagis.riwadatatable.validation.DataRowValidator;
import de.riwagis.riwadatatable.validation.ValidationError;
import de.riwagis.riwadatatable.validation.ValidationSystemException;
import de.riwagis.util.Config;
import de.riwagis.util.exception.NoLoggingSystemException;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.jdbc.JDBCSupport;
import de.riwagis.util.jdbc.errorhandling.ErrorCodeClass;
import de.riwagis.util.jdbc.errorhandling.SQLExceptionMapper;
import de.riwagis.util.jdbc.errorhandling.UserFormattedSQLException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang.StringUtils;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbTableImpl
implements DbTable {
    private static final Logger LOG = LoggerFactory.getLogger(DbTableImpl.class);
    public static final DbTableUserInfo DEFAULT_USER_INFO = new DbTableUserInfoSystem();
    protected final JDBCConnectionManager connMngr;
    protected final JDBCConnectionInfo connInfo;
    protected Object objIDLastInsert;
    private final ColumnProvider columnProvider;
    protected final DefaultTableDefinition tableDefinition;
    private boolean updateable = false;
    private boolean insertable = false;
    private boolean deleteable = false;
    private int commitEveryDataRowReaderOperation = -1;
    private DbTableUserInfo userInfo;
    private final DbTableExtenderHandler extenderHandler;
    private final DataRowValidator columnRowValidator;
    private final Collection<DataRowValidator> rowValidators = new ArrayList<DataRowValidator>();
    private Map<TableColumn, DefaultValue> tableDefinedDefaultValuesCache = new HashMap<TableColumn, DefaultValue>();
    private DbTableSqlExceptionHandler exceptionHandler = new DbTableSqlExceptionHandlerDefault();
    private boolean mySqlLatinDb = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbTableImpl(TableDefinition tblDef, JDBCConnectionManager connMngr, Collection<DbTableExtender> extenders, DbTableUserInfo userInfo) throws SystemException {
        this.tableDefinition = new DefaultTableDefinition(tblDef);
        this.connMngr = connMngr;
        this.connInfo = connMngr.getConnectionInfo();
        this.userInfo = Objects.requireNonNullElse(userInfo, DEFAULT_USER_INFO);
        if (this.connInfo.isReadonly()) {
            this.tableDefinition.setUpdate(0);
            this.tableDefinition.setInsert(0);
            this.tableDefinition.setDelete(0);
        }
        this.tableDefinition.setOrder(DbTableUtils.formatOrderBy(this.tableDefinition.getOrder(), this.tableDefinition.getIdColumn()));
        if (StringUtils.isBlank((String)this.tableDefinition.getSelectname())) {
            this.tableDefinition.setSelectname(this.tableDefinition.getName());
        }
        Collection<TableColumn> columns = new ArrayList<TableColumn>();
        try {
            for (TableColumn col : ColumnFactory.createColumns4Table(connMngr, this.tableDefinition.getSelectname(), this.tableDefinition.getDbTableNameConvention())) {
                if (col == null) continue;
                columns.add(col);
            }
        }
        catch (SQLException sqlex) {
            throw new SystemException((Throwable)sqlex);
        }
        if (columns.isEmpty()) {
            throw new RuntimeException(String.format("Should never reach here. Table %s with no columns", this.tableDefinition.getSelectname()));
        }
        if (!StringUtils.equalsIgnoreCase((String)this.tableDefinition.getName(), (String)this.tableDefinition.getSelectname())) {
            LinkedHashMap<String, TableColumn> mergedColumns = new LinkedHashMap<String, TableColumn>(columns.size());
            for (TableColumn colSelect : columns) {
                colSelect.setOnlySelect(true);
                mergedColumns.put(colSelect.getColumnName(), colSelect);
            }
            try {
                for (TableColumn col : ColumnFactory.createColumns4Table(connMngr, this.tableDefinition.getName(), this.tableDefinition.getDbTableNameConvention())) {
                    if (col == null || !mergedColumns.containsKey(col.getColumnName())) continue;
                    mergedColumns.put(col.getColumnName(), col);
                }
            }
            catch (SQLException sqlex) {
                throw new SystemException((Throwable)sqlex);
            }
            columns = mergedColumns.values();
        }
        this.columnProvider = new MapBasedColumnProvider(columns);
        if (StringUtils.isBlank((String)this.tableDefinition.getIdColumn())) {
            boolean resetPkColumn = false;
            for (TableColumn col : columns) {
                if (col.getPrimaryKeyIndex() == 1) {
                    if (col.getType() != ColumnTypes.CT_NUMBER_COLUMN) break;
                    this.tableDefinition.setIdColumn(col.getColumnName());
                }
                if (col.getPrimaryKeyIndex() <= 1) continue;
                resetPkColumn = true;
                break;
            }
            if (resetPkColumn) {
                for (TableColumn col : columns) {
                    col.setPrimaryKeyIndex(-1);
                }
                this.tableDefinition.setIdColumn("");
            }
        } else {
            if (!this.columnProvider.hasColumn(this.tableDefinition.getIdColumn())) {
                this.tableDefinition.setIdColumn("");
            }
            for (TableColumn col : columns) {
                if (col.getColumnName().equalsIgnoreCase(this.tableDefinition.getIdColumn())) {
                    col.setPrimaryKeyIndex(1);
                    continue;
                }
                col.setPrimaryKeyIndex(-1);
            }
        }
        if (this.columnProvider.hasIDColumn()) {
            this.columnProvider.getIDColumn().setNullable(1);
        }
        this.initDefaultValuesByTableDefinition();
        Connection conn = this.getConn();
        try {
            try {
                boolean autocommit = conn.getAutoCommit();
                conn.setAutoCommit(false);
                Savepoint sp = DbTableUtils.setSavepointQuietly(conn);
                try {
                    boolean executableInsert;
                    boolean executableDelete;
                    if (this.tableDefinition.getDelete() == 1 && !(executableDelete = DbTableUtils.tryUpdateQuery(conn, String.format("DELETE FROM %s WHERE 1=0", this.tableDefinition.getName())))) {
                        this.tableDefinition.setDelete(0);
                    }
                    if (this.tableDefinition.getUpdate() == 1) {
                        boolean executableUpdate;
                        if (this.connInfo.getDBType() == DBType.MSSQLServer) {
                            executableUpdate = DbTableUtils.hasUserMSSQLPermission(conn, this.tableDefinition.getName(), "UPDATE");
                        } else {
                            String updateColumn = StringUtils.defaultIfBlank((String)this.tableDefinition.getIdColumn(), (String)columns.iterator().next().getColumnName());
                            executableUpdate = DbTableUtils.tryUpdateQuery(conn, String.format("UPDATE %s SET %s=NULL WHERE 1=0", this.tableDefinition.getName(), updateColumn));
                        }
                        if (!executableUpdate) {
                            this.tableDefinition.setUpdate(0);
                        }
                    }
                    if (this.tableDefinition.getInsert() == 1 && !(executableInsert = this.connInfo.getDBType() == DBType.MSSQLServer ? DbTableUtils.hasUserMSSQLPermission(conn, this.tableDefinition.getName(), "INSERT") : DbTableUtils.tryUpdateQuery(conn, String.format("INSERT INTO %s (SELECT * FROM %s WHERE 1=0)", this.tableDefinition.getName(), this.tableDefinition.getName())))) {
                        this.tableDefinition.setInsert(0);
                    }
                    if (this.connInfo.getDBType() == DBType.MySQL) {
                        this.mySqlLatinDb = DbTableUtils.isMySqlLatinDatabase(this.connInfo, conn);
                    }
                }
                finally {
                    if (sp != null) {
                        conn.rollback(sp);
                    } else {
                        conn.rollback();
                    }
                    if (autocommit) {
                        conn.setAutoCommit(autocommit);
                    }
                }
            }
            catch (Exception e) {
                LOG.error(String.format("Error checking table %s.%s ", this.getTableScheme(), this.tableDefinition.getName()), (Throwable)e);
            }
            this.updateable = this.tableDefinition.getUpdate() == 1;
            this.insertable = this.tableDefinition.getInsert() == 1;
            this.deleteable = this.tableDefinition.getDelete() == 1;
        }
        finally {
            connMngr.closeConnection(conn);
        }
        this.columnRowValidator = new ColumnProviderDataRowValidator(this);
        this.extenderHandler = new DbTableExtenderHandler(this, extenders);
        this.extenderHandler.afterInitialisation();
        this.initDefaultExtenders();
    }

    protected final void initDefaultExtenders() throws SystemException {
        DbTableLoggingSlf4jExtender slf4jExtender;
        this.extenderHandler.addExtender(new DbTablePresetValuesExtender(this));
        if (StringUtils.isNotBlank((String)this.tableDefinition.getLockColumn()) && this.hasColumn(this.tableDefinition.getLockColumn())) {
            DbTableLockExtender lockExtender = new DbTableLockExtender(this, this.tableDefinition.getLockColumn());
            this.extenderHandler.addExtender(lockExtender);
        }
        if (this.tableDefinition.getChangelog() == 1 || this.tableDefinition.getChangelog() == 2) {
            DbTableLoggingInDbExtender logExtender = new DbTableLoggingInDbExtender(this, this.connInfo.isModificationLogEnabled());
            this.extenderHandler.addExtender(logExtender);
        }
        if ((slf4jExtender = new DbTableLoggingSlf4jExtender(this.getTablename())).isLoggerEnabled()) {
            this.extenderHandler.addExtender(slf4jExtender);
        }
        if (this.connInfo.isMySQL() && this.hasGeoColumn()) {
            DbTableMysqlGeomExtender myslqExtender = new DbTableMysqlGeomExtender(this);
            this.extenderHandler.addExtender(myslqExtender);
        }
        if (this.isMySqlLatinDb()) {
            DbTableMysqlUTF8ToLatinExtender encodingExtender = new DbTableMysqlUTF8ToLatinExtender(this);
            this.extenderHandler.addExtender(encodingExtender);
        }
    }

    protected DbTableConnectionHandler createDbTableConnectionHandler() throws SystemException {
        return new DbTableConnectionHandler(this.connMngr);
    }

    public String toString() {
        return this.getTablename() + "@" + this.connInfo.toString();
    }

    @Override
    public String getTablename() {
        return this.tableDefinition.getDbTableNameConvention().convertName(this.tableDefinition.getName());
    }

    @Override
    public Object getIDLastInsert() {
        return this.objIDLastInsert;
    }

    @Override
    public JDBCConnectionManager getConnectionManagerInternal() {
        return this.connMngr;
    }

    @Override
    public DbTable deriveDbTable(TableDefinition tableDefinition, Collection<DbTableExtender> extenders) throws SystemException, SQLException {
        return new DbTableImpl(tableDefinition, this.connMngr, extenders, this.userInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConn() throws SystemException {
        Connection connection;
        long time = System.currentTimeMillis();
        try {
            connection = this.connMngr.createConnection();
        }
        catch (Throwable throwable) {
            if (LOG.isTraceEnabled()) {
                long diff = System.currentTimeMillis() - time;
                LOG.trace(String.format("Connection creation time for table '%s': %s", this.getTablename(), diff));
            }
            throw throwable;
        }
        if (LOG.isTraceEnabled()) {
            long diff = System.currentTimeMillis() - time;
            LOG.trace(String.format("Connection creation time for table '%s': %s", this.getTablename(), diff));
        }
        return connection;
    }

    @Override
    public final JDBCConnectionInfo getConnectionInfo() {
        return this.connInfo;
    }

    @Override
    public final TableDefinition getTableDefinition() {
        return new DefaultTableDefinition(this.tableDefinition);
    }

    @Override
    public String orderBySQL() {
        String orderBy = null;
        if (StringUtils.isNotBlank((String)this.tableDefinition.getOrder())) {
            orderBy = String.format(" order by %s", this.tableDefinition.getOrder());
        }
        return orderBy;
    }

    private String getOrderBy4Query(DataTableQuery query) {
        if (StringUtils.isNotBlank((String)query.getOrderBy())) {
            return String.format(" order by %s", query.getOrderBy());
        }
        return this.orderBySQL();
    }

    protected String getTableScheme() {
        return this.connInfo.getScheme();
    }

    public void addDefaultFilters2Query(DataTableQuery query) throws SystemException {
        if (StringUtils.isNotBlank((String)query.getSQLWhere()) && StringUtils.isNotBlank((String)this.tableDefinition.getFilter())) {
            query.appendToQuery(" and ");
        }
        if (StringUtils.isNotBlank((String)this.tableDefinition.getFilter())) {
            query.appendToQuery("(").appendToQuery(this.tableDefinition.getFilter()).appendToQuery(")");
        }
    }

    public DbTableExtenderHandler getExtenderHandler() {
        return this.extenderHandler;
    }

    @Override
    public DataRow getSum(DataTableQuery query, Collection<String> columnNames) throws SystemException {
        Connection conn = this.getConn();
        try {
            DataRow dataRow = this.getSum(conn, query, columnNames);
            return dataRow;
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
        finally {
            this.connMngr.closeConnection(conn);
        }
    }

    @Override
    public DataRow getSum(Connection conn, DataTableQuery query, Collection<String> columnNames) throws SystemException {
        DbTableOperationHandler opHandler = this.extenderHandler.createOperationHandler(DbTableOperationType.SELECT, conn);
        try {
            DataRow sumRow;
            DataTableQuery filterAdjustedClonedQuery;
            Collection<TableColumn> columns;
            block24: {
                DataTableQuery clonedQuery = new DataTableQuery(query);
                this.addDefaultFilters2Query(clonedQuery);
                columns = this.getColumnsCollection(columnNames);
                filterAdjustedClonedQuery = opHandler.adjustFilter4Operation(DbTableOperationType.SELECT, conn, columns, null, clonedQuery);
                opHandler.checkAllowed(DbTableOperationType.SELECT, conn, columns, null, filterAdjustedClonedQuery);
                ArrayList<String> sbColumns = new ArrayList<String>();
                for (TableColumn column : columns) {
                    if (column.getType() != ColumnTypes.CT_NUMBER_COLUMN) {
                        throw new SystemException(String.format("sum column not numeric '%s'", column.getColumnName()));
                    }
                    sbColumns.add(String.format("SUM(%s) AS %s", column.getColumnName(), column.getColumnName()));
                }
                opHandler.beforeOperation(DbTableOperationType.SELECT, conn, columns, null, filterAdjustedClonedQuery, -1);
                String strSQL = String.format("SELECT %s FROM %s %s%s", StringUtils.join(sbColumns, (String)", "), this.tableDefinition.getSelectname(), "tbl", filterAdjustedClonedQuery.getSQLWhere(true));
                try (PreparedStatement pstmt = JDBCSupport.prepareSelectStatement((Connection)conn, (String)strSQL, (Object[])filterAdjustedClonedQuery.getWhereCriterias(conn));
                     ResultSet rs = pstmt.executeQuery();){
                    if (rs.next()) {
                        sumRow = DataRowUtils.fillRowByResultSet(columns, rs, this.insertable);
                        break block24;
                    }
                    throw new SystemException("Should never reach here. The SQL statement calculating sum returned no result.");
                }
            }
            opHandler.afterOperation(DbTableOperationType.SELECT, conn, columns, null, filterAdjustedClonedQuery, -1);
            DataRow dataRow = sumRow;
            if (opHandler != null) {
                opHandler.close();
            }
            return dataRow;
        }
        catch (Throwable throwable) {
            try {
                if (opHandler != null) {
                    try {
                        opHandler.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                throw new SystemException(this.getClass(), String.format("getSum. Error: %s", e.getMessage()), (Throwable)e);
            }
        }
    }

    @Override
    public int getCount(DataTableQuery query) throws SystemException {
        Connection conn = this.getConn();
        try {
            int n = this.getCount(conn, query);
            return n;
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
        finally {
            this.connMngr.closeConnection(conn);
        }
    }

    @Override
    public int getCount(Connection conn, DataTableQuery query) throws SystemException {
        DbTableOperationHandler oph = this.extenderHandler.createOperationHandler(DbTableOperationType.SELECT, conn);
        try {
            int count;
            DataTableQuery clonedQuery = new DataTableQuery(query);
            this.addDefaultFilters2Query(clonedQuery);
            DataTableQuery filterAdjustedClonedQuery = oph.adjustFilter4Operation(DbTableOperationType.SELECT, conn, null, null, clonedQuery);
            oph.checkAllowed(DbTableOperationType.SELECT, conn, null, null, filterAdjustedClonedQuery);
            String strCount = this.hasIDColumn() ? StringUtils.defaultIfEmpty((String)this.getIDColumn().getColumnName(), (String)"*") : "*";
            oph.beforeOperation(DbTableOperationType.SELECT, conn, null, null, filterAdjustedClonedQuery, -1);
            String strSQL = String.format("SELECT COUNT(%s) AS anzahl FROM %s %s%s", strCount, this.tableDefinition.getSelectname(), "tbl", filterAdjustedClonedQuery.getSQLWhere(true));
            try (PreparedStatement pstmt = JDBCSupport.prepareSelectStatement((Connection)conn, (String)strSQL, (Object[])filterAdjustedClonedQuery.getWhereCriterias(conn));
                 ResultSet rs = pstmt.executeQuery();){
                count = rs.next() ? rs.getInt("anzahl") : 0;
            }
            oph.afterOperation(DbTableOperationType.SELECT, conn, null, null, filterAdjustedClonedQuery, count);
            int n = count;
            if (oph != null) {
                oph.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (oph != null) {
                    try {
                        oph.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                throw new SystemException(this.getClass(), String.format("getCount. Error: %s", e.getMessage()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReferencedEnvelope getBounds(DataTableQuery query) throws SystemException {
        Connection conn = this.getConn();
        try {
            ReferencedEnvelope referencedEnvelope = this.getBounds(conn, query);
            return referencedEnvelope;
        }
        finally {
            this.connMngr.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReferencedEnvelope getBounds(DataTableQuery query, String geoColumnName) throws SystemException {
        Connection conn = this.getConn();
        try {
            ReferencedEnvelope referencedEnvelope = this.getBounds(conn, query, geoColumnName);
            return referencedEnvelope;
        }
        finally {
            this.connMngr.closeConnection(conn);
        }
    }

    @Override
    public ReferencedEnvelope getBounds(Connection conn, DataTableQuery query) throws SystemException {
        if (!this.hasGeoColumn()) {
            return new ReferencedEnvelope();
        }
        return this.getBounds(conn, query, this.getDefaultGeoColumn().getColumnName());
    }

    @Override
    public ReferencedEnvelope getBounds(Connection conn, DataTableQuery query, String geoColumnName) throws SystemException {
        if (!this.hasColumn(geoColumnName) || !(this.getColumn(geoColumnName) instanceof GeoColumn)) {
            throw new IllegalArgumentException(String.format("Can not find out bounds. Given geometry column '%s' not found in table '%s'.", geoColumnName, this.getTablename()));
        }
        DbTableOperationHandler oph = this.extenderHandler.createOperationHandler(DbTableOperationType.SELECT, conn);
        try {
            DataTableQuery clonedQuery = new DataTableQuery(query);
            this.addDefaultFilters2Query(clonedQuery);
            DataTableQuery filterAdjustedClonedQuery = oph.adjustFilter4Operation(DbTableOperationType.SELECT, conn, null, null, clonedQuery);
            oph.checkAllowed(DbTableOperationType.SELECT, conn, null, null, filterAdjustedClonedQuery);
            oph.beforeOperation(DbTableOperationType.SELECT, conn, null, null, filterAdjustedClonedQuery, -1);
            GeoColumn geoColumn = (GeoColumn)this.getColumn(geoColumnName);
            String strSQL = String.format("SELECT %s FROM %s %s%s", geoColumn.getEnvelopeString(), this.tableDefinition.getSelectname(), "tbl", filterAdjustedClonedQuery.getSQLWhere(true));
            CoordinateReferenceSystem crs = null;
            if (this.getConnectionInfo().getCRS() != null) {
                try {
                    crs = this.getConnectionInfo().getCRS().getCRS();
                }
                catch (Exception e) {
                    LOG.warn(String.format("Table '%s'. CoordinateReferenceSystem for CRSDefinition with key '%s' cannot be created.", this.getTableScheme() + "." + this.getTablename(), this.getConnectionInfo().getCRS().getKey()));
                }
            }
            ReferencedEnvelope env = new ReferencedEnvelope(crs);
            int count = 0;
            try (PreparedStatement pstmt = JDBCSupport.prepareSelectStatement((Connection)conn, (String)strSQL, (Object[])filterAdjustedClonedQuery.getWhereCriterias(conn));
                 ResultSet rs = pstmt.executeQuery();){
                while (rs.next()) {
                    Geometry geom = (Geometry)geoColumn.getObject(1, rs);
                    if (geom != null) {
                        env.expandToInclude(geom.getEnvelopeInternal());
                    }
                    ++count;
                }
            }
            oph.afterOperation(DbTableOperationType.SELECT, conn, null, null, filterAdjustedClonedQuery, count);
            ReferencedEnvelope referencedEnvelope = env;
            if (oph != null) {
                oph.close();
            }
            return referencedEnvelope;
        }
        catch (Throwable throwable) {
            try {
                if (oph != null) {
                    try {
                        oph.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                throw new SystemException(this.getClass(), String.format("getBounds. Error: %s", e.getMessage()), (Throwable)e);
            }
        }
    }

    private DataRowReaderResultSet createDataReader(final Connection conn, final Collection<TableColumn> uniqueColumns, DataTableQuery query, String orderBy) throws SQLException, SystemException {
        final DbTableOperationHandler oph = this.extenderHandler.createOperationHandler(DbTableOperationType.SELECT, conn);
        final DataTableQuery filterAdjustedClonedQuery = oph.adjustFilter4Operation(DbTableOperationType.SELECT, conn, uniqueColumns, null, query);
        oph.checkAllowed(DbTableOperationType.SELECT, conn, uniqueColumns, null, filterAdjustedClonedQuery);
        oph.beforeOperation(DbTableOperationType.SELECT, conn, uniqueColumns, null, filterAdjustedClonedQuery, -1);
        String sql = DbTableUtils.buildQuery(this.connInfo, this.tableDefinition, uniqueColumns, filterAdjustedClonedQuery, orderBy);
        PreparedStatement pstmt = JDBCSupport.prepareSelectStatement((Connection)conn, (String)sql, (Object[])filterAdjustedClonedQuery.getWhereCriterias(conn));
        try {
            DataRowReaderResultSet reader = new DataRowReaderResultSet(uniqueColumns, pstmt.executeQuery(), true){

                @Override
                protected DataRow adjustRow(DataRow row) {
                    try {
                        return oph.adjustDataRow4Operation(DbTableOperationType.SELECT, conn, row, filterAdjustedClonedQuery);
                    }
                    catch (SystemException se) {
                        throw new RuntimeException(String.format("Error adjusting DataRow for table '%s'", DbTableImpl.this.getTablename()), se);
                    }
                }

                @Override
                public void close() throws SystemException {
                    oph.afterOperation(DbTableOperationType.SELECT, conn, uniqueColumns, null, filterAdjustedClonedQuery, -1);
                    oph.closeQuietly();
                    super.close();
                }
            };
            reader.addReaderClosedListener(new PreparedStatementDataRowReaderListener(pstmt));
            return reader;
        }
        catch (Throwable t) {
            DbUtils.closeQuietly((Statement)pstmt);
            throw t;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DataRow getData(Connection conn, Object objID, Collection<String> columnNames) throws SystemException {
        DataTableQuery query = this.buildIDQuery(objID);
        try (DataRowReader reader = this.getData(conn, query, (Collection)columnNames);){
            if (((DataRowReaderResultSet)reader).hasNext()) {
                DataRow dataRow2 = ((DataRowReaderResultSet)reader).next();
                return dataRow2;
            }
            DataRow dataRow = null;
            return dataRow;
        }
        catch (SystemException e) {
            throw new SystemException(String.format("getData on table '%s'. Error: %s", this.getTablename(), e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public DataRow getData(Object objID, Collection<String> columnNames) throws SystemException {
        DbTableConnectionHandler connHndl = this.createDbTableConnectionHandler();
        try {
            DataRow row = this.getData(connHndl.getConnection(), objID, columnNames);
            connHndl.commitIfAutocommit();
            DataRow dataRow = row;
            return dataRow;
        }
        catch (Throwable e) {
            connHndl.closeConnectionAfterExceptionQuietly();
            if (e instanceof SystemException) {
                throw (SystemException)e;
            }
            throw new SystemException(this.getClass(), e);
        }
        finally {
            connHndl.closeConnectionQuietly();
        }
    }

    @Override
    public DataRow getData(Object objID, String ... columnNames) throws SystemException {
        return this.getData(objID, Arrays.asList(columnNames));
    }

    @Override
    public DataRow getData(Connection conn, Object objID, String ... columnNames) throws SystemException {
        return this.getData(conn, objID, Arrays.asList(columnNames));
    }

    @Override
    public DataRowReaderResultSet getData(Connection conn, DataTableQuery query, Collection<String> columnNames) throws SystemException {
        try {
            DataTableQuery clonedQuery = new DataTableQuery(query);
            this.addDefaultFilters2Query(clonedQuery);
            Collection<TableColumn> columns = ColumnUtils.makeUniqueColumns(this.getColumnsCollection(columnNames));
            if (columns.isEmpty()) {
                columns = this.getColumnsCollection();
            }
            return this.createDataReader(conn, columns, clonedQuery, this.getOrderBy4Query(query));
        }
        catch (SystemException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new SystemException(this.getClass(), String.format("Error getting data for table %s.%s", this.getTableScheme(), this.getTablename()), (Throwable)e);
        }
    }

    @Override
    public DataRowReaderResultSet getData(DataTableQuery query, Collection<String> columnNames) throws SystemException {
        DbTableConnectionHandler connHndl = this.createDbTableConnectionHandler();
        try {
            DataRowReader reader = this.getData(connHndl.getConnection(), query, (Collection)columnNames);
            ((DataRowReaderResultSet)reader).addReaderClosedListener(new ConnectionManagerDataRowReaderListener(connHndl));
            return reader;
        }
        catch (Throwable e) {
            connHndl.closeConnectionAfterExceptionQuietly();
            if (e instanceof SystemException) {
                throw (SystemException)e;
            }
            throw new SystemException(this.getClass(), e);
        }
    }

    @Override
    public DataRowReaderResultSet getData(DataTableQuery query, String ... columnNames) throws SystemException {
        return this.getData(query, Arrays.asList(columnNames));
    }

    @Override
    public DataRowReaderResultSet getData(Connection conn, DataTableQuery query, String ... columnNames) throws SystemException {
        return this.getData(conn, query, Arrays.asList(columnNames));
    }

    @Override
    public DataRowReader getDataBySpatialQuery(Geometry geometryToQuery, SpatialQueryType spatialQueryType, DataTableQuery additionalQuery, String ... columnNames) throws SystemException {
        return this.getDataBySpatialQuery(geometryToQuery, spatialQueryType, additionalQuery, Arrays.asList(columnNames));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataRowReader getDataBySpatialQuery(Geometry geometryToQuery, SpatialQueryType spatialQueryType, DataTableQuery additionalQuery, Collection<String> columnNames) throws SystemException {
        Connection conn = this.getConn();
        try {
            DataRowReader reader;
            DataRowReader dataRowReader = reader = this.getDataBySpatialQuery(conn, geometryToQuery, spatialQueryType, additionalQuery, columnNames);
            return dataRowReader;
        }
        finally {
            this.connMngr.closeConnection(conn);
        }
    }

    @Override
    public DataRowReader getDataBySpatialQuery(Connection conn, Geometry geometryToQuery, SpatialQueryType spatialQueryType, DataTableQuery additionalQuery, String ... columnNames) throws SystemException {
        return this.getDataBySpatialQuery(conn, geometryToQuery, spatialQueryType, additionalQuery, Arrays.asList(columnNames));
    }

    @Override
    public DataRowReader getDataBySpatialQuery(Connection conn, Geometry geometryToQuery, SpatialQueryType spatialQueryType, DataTableQuery additionalQuery, Collection<String> columnNames) throws SystemException {
        if (!this.hasGeoColumn()) {
            throw new SystemException(String.format("Spatial query on table '%s' called, but table has no geometry column", this.getTablename()));
        }
        DataTableQuery spatialQuery = this.createSpatialFilterQuery(geometryToQuery, additionalQuery);
        if (columnNames.stream().noneMatch(s -> s.equalsIgnoreCase(this.getDefaultGeoColumn().getColumnName()))) {
            columnNames = new ArrayList<String>(columnNames);
            columnNames.add(this.getDefaultGeoColumn().getColumnName());
        }
        ArrayList<DataRow> lstResult = new ArrayList<DataRow>();
        try (DataRowReader rowReader = this.getData(conn, spatialQuery, (Collection)columnNames);){
            while (rowReader.hasNext()) {
                DataRow dr = (DataRow)rowReader.next();
                Geometry geomCandidate = (Geometry)dr.getData(this.getDefaultGeoColumn().getColumnName());
                if (!spatialQueryType.match(geometryToQuery, geomCandidate)) continue;
                lstResult.add(dr);
            }
        }
        return new DataRowReaderCollection(this.getColumnsCollection(columnNames), lstResult);
    }

    private DataTableQuery createSpatialFilterQuery(Geometry geometryToQuery, DataTableQuery additionalQuery) throws SystemException {
        Filter filt;
        try {
            filt = FilterUtil.getEnvelopeFilter((Envelope)geometryToQuery.getEnvelopeInternal(), (String)this.getDefaultGeoColumn().getColumnName(), (int)this.getConnectionInfo().getSRID());
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        DataTableGeotoolsFilterVisitor filtVisit = new DataTableGeotoolsFilterVisitor("", this);
        DataTableQuery spatialQuery = new DataTableQuery(this.getConnectionInfo());
        filt.accept((FilterVisitor)filtVisit, (Object)spatialQuery);
        if (additionalQuery != null) {
            spatialQuery.appendQueryWithAnd(additionalQuery);
        }
        return spatialQuery;
    }

    protected DataRow retrieveTableSpecificDataRow(DataRow dataRow) {
        Collection<String> columnNames = ColumnUtils.listColumnNames(dataRow.getColumnsCollection());
        return new DataRow(this.getColumnsCollection(columnNames), Arrays.asList(dataRow.getDataAsArray()));
    }

    protected void insertDataAdjustID(Connection conn, TableSequenceHandler tsl, DataRow data2Insert) throws SQLException {
        if (this.hasIDColumn()) {
            if (tsl.isAutoIncrement()) {
                this.removeIdColumnFromRow(data2Insert);
            } else {
                Object nextID = tsl.generateNextID(conn);
                if (nextID != null) {
                    if (data2Insert.hasColumn(this.tableDefinition.getIdColumn())) {
                        data2Insert.removeColumn(this.tableDefinition.getIdColumn());
                    }
                    data2Insert.addColumn(0, this.getIDColumn(), nextID);
                }
            }
        }
    }

    private void removeIdColumnFromRow(DataRow row) {
        if (this.hasIDColumn() && row.hasColumn(this.getIDColumn().getColumnName())) {
            row.removeColumn(this.getIDColumn().getColumnName());
        }
    }

    protected int updateDataSingleQuery(DbTableOperationHandler oph, PreparedStatement pstmt, DataRow data2Update, DataTableQuery query) throws SystemException, SQLException {
        DataRow adjustedDataRow = oph.adjustDataRow4Operation(DbTableOperationType.UPDATE, pstmt.getConnection(), data2Update, query);
        this.validateDataRowThrowingException(adjustedDataRow, DbTableOperationType.UPDATE);
        oph.beforeOperation(DbTableOperationType.UPDATE, pstmt.getConnection(), adjustedDataRow.getColumnsCollection(), adjustedDataRow, query, -1);
        int index = 1;
        for (TableColumn col : adjustedDataRow.getColumnsCollection()) {
            Object obj = adjustedDataRow.getData(index - 1);
            col.setObject(index, obj, pstmt);
            ++index;
        }
        for (Object objQuery : query.getWhereCriterias(pstmt.getConnection())) {
            pstmt.setObject(index, objQuery);
            ++index;
        }
        int counterUpdated = pstmt.executeUpdate();
        oph.afterOperation(DbTableOperationType.UPDATE, pstmt.getConnection(), adjustedDataRow.getColumnsCollection(), adjustedDataRow, query, counterUpdated);
        return counterUpdated;
    }

    protected String deleteSql4Query(DbTableOperationHandler oph, Connection conn, DataTableQuery query, DataRow rowDataDelete) throws SystemException {
        String sql;
        if (StringUtils.isNotBlank((String)this.tableDefinition.getDeleteCondition())) {
            oph.addColumns2Row(DbTableOperationType.DELETE, conn, rowDataDelete, query);
            sql = DbTableUtils.buildUpdateSQL4ColumnsAndQuery(this.getTablename(), this.tableDefinition.getDeleteCondition(), rowDataDelete.getColumnsCollection(), query);
        } else {
            sql = DbTableUtils.buildDeleteSQL4Query(this.getTablename(), query);
        }
        return sql;
    }

    protected int deleteDataSingleQuery(DbTableOperationHandler oph, PreparedStatement pstmt, DataTableQuery query, DataRow rowDataDelete) throws SystemException, SQLException {
        oph.beforeOperation(DbTableOperationType.DELETE, pstmt.getConnection(), null, null, query, -1);
        int index = 1;
        if (StringUtils.isNotBlank((String)this.tableDefinition.getDeleteCondition())) {
            for (int i = 0; i < rowDataDelete.getColumnCount(); ++i) {
                rowDataDelete.setData(i, null);
            }
            DataRow adjustedDataRow = oph.adjustDataRow4Operation(DbTableOperationType.DELETE, pstmt.getConnection(), rowDataDelete, query);
            for (TableColumn col : adjustedDataRow.getColumnsCollection()) {
                Object obj = adjustedDataRow.getData(index - 1);
                col.setObject(index, obj, pstmt);
                ++index;
            }
        }
        for (Object objQuery : query.getWhereCriterias(pstmt.getConnection())) {
            pstmt.setObject(index, objQuery);
            ++index;
        }
        int rowsDeleted = pstmt.executeUpdate();
        oph.afterOperation(DbTableOperationType.DELETE, pstmt.getConnection(), null, null, query, rowsDeleted);
        return rowsDeleted;
    }

    protected int insertDataSingleEntry(Connection conn, DbTableOperationHandler oph, PreparedStatement pstmt, DataRow data2Insert, TableSequenceHandler tsl, boolean prepareForInsert) throws SystemException, SQLException {
        if (prepareForInsert) {
            this.prepareDataRowForInsert(conn, oph, tsl, data2Insert);
        }
        DataRow adjustedDataRow = oph.adjustDataRow4Operation(DbTableOperationType.INSERT, pstmt.getConnection(), data2Insert, null);
        oph.checkAllowed(DbTableOperationType.INSERT, pstmt.getConnection(), adjustedDataRow.getColumnsCollection(), adjustedDataRow, null);
        this.validateDataRowThrowingException(adjustedDataRow, DbTableOperationType.INSERT);
        oph.beforeOperation(DbTableOperationType.INSERT, pstmt.getConnection(), adjustedDataRow.getColumnsCollection(), adjustedDataRow, null, -1);
        DataRowUtils.fillPreparedStatementWithDataRow(pstmt, adjustedDataRow);
        int rowsInserted = pstmt.executeUpdate();
        if (rowsInserted == 0) {
            throw new SystemException("No data could be inserted in table.");
        }
        this.objIDLastInsert = tsl.retrieveLastID(pstmt);
        if (this.hasIDColumn() && this.getIDColumn().getType() == ColumnTypes.CT_NUMBER_COLUMN && this.objIDLastInsert != null) {
            this.objIDLastInsert = ((NumberColumn)this.getIDColumn()).getNumberType().numberOfType((Number)this.objIDLastInsert, this.getIDColumn().isUnsigned());
        }
        oph.afterOperation(DbTableOperationType.INSERT, pstmt.getConnection(), adjustedDataRow.getColumnsCollection(), adjustedDataRow, null, rowsInserted);
        return rowsInserted;
    }

    @Override
    public void addDefaultTableValuesToDataRow(Connection conn, DataRow row, boolean overwriteNullValues) throws SystemException, SQLException {
        for (TableColumn col : this.getColumnsCollection()) {
            if (row.hasColumn(col.getColumnName()) && !overwriteNullValues) continue;
            DefaultValue dv = col.getDefaultValueInternal();
            Object obj = dv != null ? (dv instanceof SQLDefaultValue ? ((SQLDefaultValue)dv).getDefaultValue(conn, col) : col.getDefaultValue()) : null;
            if (obj == null) continue;
            if (!row.hasColumn(col.getColumnName())) {
                row.addColumn(row.getColumnCount(), col, obj);
                continue;
            }
            row.setData(col.getColumnName(), obj);
        }
    }

    @Override
    public int insertData(Connection conn, DataRow data2Insert) throws SystemException {
        this.assertInsertable();
        int intAnzahl = 0;
        try (DbTableOperationHandler oph = this.extenderHandler.createOperationHandler(DbTableOperationType.INSERT, conn);){
            TableSequenceHandler tsl = this.createTableSequenceHandler();
            DataRow tableSpecificData2Insert = this.retrieveTableSpecificDataRow(data2Insert);
            this.prepareDataRowForInsert(conn, oph, tsl, tableSpecificData2Insert);
            String sqlInsert = DbTableUtils.buildInsertSQL4Columns(this.getTablename(), tableSpecificData2Insert.getColumnsCollection(), this.getConnectionInfo().getDBType());
            try (PreparedStatement pstmt = TableSequenceHandlerUtils.buildPreparedInsertStatement4Insert(conn, sqlInsert, tsl);){
                intAnzahl += this.insertDataSingleEntry(conn, oph, pstmt, tableSpecificData2Insert, tsl, false);
            }
        }
        catch (Throwable t) {
            SystemException sysex = this.convertThrowable2SystemException(t, conn, String.format("Error inserting data in table %s.%s", this.getTableScheme(), this.getTablename()));
            this.exceptionHandler.handleException(DbTableOperationType.INSERT, conn, sysex);
        }
        return intAnzahl;
    }

    @Override
    public int insertData(Connection conn, DataRowReader rows2Insert) throws SystemException {
        this.assertInsertable();
        int intAnzahl = 0;
        try (DbTableOperationHandler oph = this.extenderHandler.createOperationHandler(DbTableOperationType.INSERT, conn);){
            TableSequenceHandler tsl = this.createTableSequenceHandler();
            DataRow readerRow = this.retrieveTableSpecificDataRow(new DataRow(rows2Insert.getColumnsCollection(), Arrays.asList(new Object[rows2Insert.getColumnCount()])));
            this.prepareDataRowForInsert(conn, oph, tsl, readerRow);
            String sqlInsert = DbTableUtils.buildInsertSQL4Columns(this.getTablename(), readerRow.getColumnsCollection(), this.getConnectionInfo().getDBType());
            try (PreparedStatement pstmt = TableSequenceHandlerUtils.buildPreparedInsertStatement4Insert(conn, sqlInsert, tsl);){
                int operationsCount = 0;
                while (rows2Insert.hasNext()) {
                    try {
                        intAnzahl += this.insertDataSingleEntry(conn, oph, pstmt, this.retrieveTableSpecificDataRow((DataRow)rows2Insert.next()), tsl, true);
                        ++operationsCount;
                        operationsCount = this.handleCommitEveryDataRowReaderOperation(conn, operationsCount);
                    }
                    catch (Throwable t) {
                        SystemException sysex = this.convertThrowable2SystemException(t, conn, String.format("Error inserting data in table %s.%s", this.getTableScheme(), this.getTablename()));
                        this.exceptionHandler.handleException(DbTableOperationType.INSERT, conn, sysex);
                    }
                }
            }
        }
        catch (Throwable t) {
            throw this.convertThrowable2SystemException(t, conn, String.format("Error inserting data in table %s.%s", this.getTableScheme(), this.getTablename()));
        }
        return intAnzahl;
    }

    @Override
    public int insertData(DataRow data2Insert) throws SystemException {
        DbTableConnectionHandler connHndl = this.createDbTableConnectionHandler();
        try {
            int intAnzahl = this.insertData(connHndl.getConnection(), data2Insert);
            connHndl.commitIfAutocommit();
            int n = intAnzahl;
            return n;
        }
        catch (Throwable t) {
            connHndl.closeConnectionAfterExceptionQuietly();
            if (t instanceof SystemException) {
                throw (SystemException)t;
            }
            throw new SystemException(this.getClass(), t);
        }
        finally {
            connHndl.closeConnectionQuietly();
        }
    }

    @Override
    public int insertData(DataRowReader rows2Insert) throws SystemException {
        DbTableConnectionHandler connHndl = this.createDbTableConnectionHandler();
        try {
            int intAnzahl = this.insertData(connHndl.getConnection(), rows2Insert);
            connHndl.commitIfAutocommit();
            int n = intAnzahl;
            return n;
        }
        catch (Throwable e) {
            connHndl.closeConnectionAfterExceptionQuietly();
            if (e instanceof SystemException) {
                throw (SystemException)e;
            }
            throw new SystemException(this.getClass(), e);
        }
        finally {
            connHndl.closeConnectionQuietly();
        }
    }

    protected void assertInsertable() throws SystemException {
        if (!this.insertable) {
            throw new SystemException(this.getClass(), "No permission to insert data in table.");
        }
    }

    protected TableSequenceHandler createTableSequenceHandler() {
        boolean isIdColumnAutoInc = this.hasIDColumn() && this.getIDColumn() instanceof NumberColumn ? ((NumberColumn)this.getIDColumn()).isAutoIncrement() : false;
        return TableSequenceHandlerUtils.buildTableSequenceHandler(this.getConnectionInfo().getDBType(), this.tableDefinition.getSeq(), this.hasIDColumn() ? this.getIDColumn().getColumnName() : "", this.getTablename(), isIdColumnAutoInc);
    }

    protected void prepareDataRowForInsert(Connection conn, DbTableOperationHandler oph, TableSequenceHandler tsl, DataRow datarow) throws SystemException, SQLException {
        this.addDefaultTableValuesToDataRow(conn, datarow, false);
        this.insertDataAdjustID(conn, tsl, datarow);
        oph.addColumns2Row(DbTableOperationType.INSERT, conn, datarow, null);
    }

    @Override
    public int deleteData(Connection conn, DataTableQuery query) throws SystemException {
        if (!this.deleteable) {
            throw new SystemException("No permission to delete data from table.");
        }
        int countDelete = 0;
        try (DbTableOperationHandler oph = this.extenderHandler.createOperationHandler(DbTableOperationType.DELETE, conn);){
            DataTableQuery clonedQuery = new DataTableQuery(query);
            this.addDefaultFilters2Query(clonedQuery);
            DataTableQuery filterAdjustedClonedQuery = oph.adjustFilter4Operation(DbTableOperationType.DELETE, conn, null, null, clonedQuery);
            oph.checkAllowed(DbTableOperationType.DELETE, conn, null, null, filterAdjustedClonedQuery);
            DataRow rowDataDelete = new DataRow(new TableColumn[0], new Object[0]);
            String sqlDelete = this.deleteSql4Query(oph, conn, filterAdjustedClonedQuery, rowDataDelete);
            try (PreparedStatement pstmt = conn.prepareStatement(sqlDelete);){
                countDelete = this.deleteDataSingleQuery(oph, pstmt, filterAdjustedClonedQuery, rowDataDelete);
            }
        }
        catch (Throwable t) {
            SystemException sysex = this.convertThrowable2SystemException(t, conn, String.format("Error deleting data in table %s.%s", this.getTableScheme(), this.getTablename()));
            this.exceptionHandler.handleException(DbTableOperationType.DELETE, conn, sysex);
        }
        return countDelete;
    }

    @Override
    public int deleteData(Connection conn, DataRow row2Delete) throws SystemException {
        if (!this.hasIDColumn()) {
            throw new SystemException(String.format("No id column in table '%s' found.", this.tableDefinition.getName()));
        }
        TableColumn colID = this.getIDColumn();
        if (!row2Delete.hasColumn(colID.getColumnName())) {
            throw new SystemException(String.format("No id column '%s' found in given data row to delete. (table : '%s')", colID.getColumnName(), this.tableDefinition.getName()));
        }
        Object idValue = row2Delete.getData(colID.getColumnName());
        return this.deleteDataByID(conn, idValue);
    }

    @Override
    public int deleteDataByID(Connection conn, Object idValue) throws SystemException {
        DataTableQuery query = this.buildIDQuery(idValue);
        return this.deleteData(conn, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteData(Connection conn, DataRowReader rows2Delete) throws SystemException {
        if (!this.deleteable) {
            throw new SystemException(this.getClass(), "No permission to delete data in table.");
        }
        if (!this.hasIDColumn()) {
            throw new SystemException(String.format("No id column in table '%s' found.", this.tableDefinition.getName()));
        }
        TableColumn colID = this.getIDColumn();
        if (!rows2Delete.hasColumn(colID.getColumnName())) {
            throw new SystemException(String.format("No id column '%s' found in given DataRowReader to delete. (table : '%s')", colID.getColumnName(), this.tableDefinition.getName()));
        }
        int countDelete = 0;
        try (DbTableOperationHandler oph = this.extenderHandler.createOperationHandler(DbTableOperationType.DELETE, conn);){
            DataTableQuery query = new DataTableQuery(this.connInfo);
            query.appendToQuery(String.format("%s=?", colID.getColumnName()));
            this.addDefaultFilters2Query(query);
            DataRow rowDataDelete = new DataRow(new TableColumn[0], new Object[0]);
            String lastSQL = "";
            try (Statement pstmtUpdate = null;){
                int operationsCount = 0;
                while (rows2Delete.hasNext()) {
                    try {
                        DataRow data2Delete = (DataRow)rows2Delete.next();
                        DataTableQuery clonedQuery = new DataTableQuery(query);
                        clonedQuery.addFilterCriterias(data2Delete.getData(colID.getColumnName()));
                        DataTableQuery filterAdjustedClonedQuery = oph.adjustFilter4Operation(DbTableOperationType.DELETE, conn, null, null, clonedQuery);
                        String currSQL = this.deleteSql4Query(oph, conn, filterAdjustedClonedQuery, rowDataDelete);
                        if (!StringUtils.equals((String)lastSQL, (String)currSQL)) {
                            lastSQL = currSQL;
                            if (pstmtUpdate != null) {
                                pstmtUpdate.close();
                            }
                            pstmtUpdate = conn.prepareStatement(currSQL);
                        }
                        oph.checkAllowed(DbTableOperationType.DELETE, conn, null, null, filterAdjustedClonedQuery);
                        int countDeleteSingle = this.deleteDataSingleQuery(oph, (PreparedStatement)pstmtUpdate, filterAdjustedClonedQuery, rowDataDelete);
                        countDelete += countDeleteSingle;
                        ++operationsCount;
                        operationsCount = this.handleCommitEveryDataRowReaderOperation(conn, operationsCount);
                    }
                    catch (Throwable t) {
                        SystemException sysex = this.convertThrowable2SystemException(t, conn, String.format("Error deleting data in table %s.%s", this.getTableScheme(), this.getTablename()));
                        this.exceptionHandler.handleException(DbTableOperationType.DELETE, conn, sysex);
                    }
                }
            }
        }
        catch (Throwable t) {
            throw this.convertThrowable2SystemException(t, conn, String.format("Error deleting data in table %s.%s", this.getTableScheme(), this.getTablename()));
        }
        return countDelete;
    }

    @Override
    public int deleteData(DataTableQuery query) throws SystemException {
        DbTableConnectionHandler connHndl = this.createDbTableConnectionHandler();
        try {
            int intAnzahl = this.deleteData(connHndl.getConnection(), query);
            connHndl.commitIfAutocommit();
            int n = intAnzahl;
            return n;
        }
        catch (Throwable e) {
            connHndl.closeConnectionAfterExceptionQuietly();
            if (e instanceof SystemException) {
                throw (SystemException)e;
            }
            throw new SystemException(this.getClass(), e);
        }
        finally {
            connHndl.closeConnectionQuietly();
        }
    }

    @Override
    public int deleteData(DataRow row2Delete) throws SystemException {
        if (!this.hasIDColumn()) {
            throw new SystemException(String.format("No id column in table '%s' found.", this.tableDefinition.getName()));
        }
        DbTableConnectionHandler connHndl = this.createDbTableConnectionHandler();
        try {
            int intAnzahl = this.deleteData(connHndl.getConnection(), row2Delete);
            connHndl.commitIfAutocommit();
            int n = intAnzahl;
            return n;
        }
        catch (Throwable e) {
            connHndl.closeConnectionAfterExceptionQuietly();
            if (e instanceof SystemException) {
                throw (SystemException)e;
            }
            throw new SystemException(this.getClass(), e);
        }
        finally {
            connHndl.closeConnectionQuietly();
        }
    }

    @Override
    public int deleteData(DataRowReader rows2Delete) throws SystemException {
        if (!this.hasIDColumn()) {
            throw new SystemException(String.format("No id column in table '%s' found.", this.tableDefinition.getName()));
        }
        DbTableConnectionHandler connHndl = this.createDbTableConnectionHandler();
        try {
            int intAnzahl = this.deleteData(connHndl.getConnection(), rows2Delete);
            connHndl.commitIfAutocommit();
            int n = intAnzahl;
            return n;
        }
        catch (Throwable e) {
            connHndl.closeConnectionAfterExceptionQuietly();
            if (e instanceof SystemException) {
                throw (SystemException)e;
            }
            throw new SystemException(this.getClass(), e);
        }
        finally {
            connHndl.closeConnectionQuietly();
        }
    }

    @Override
    public int deleteDataByID(Object idValueToDelete) throws SystemException {
        return this.deleteData(this.buildIDQuery(idValueToDelete));
    }

    @Override
    public int updateData(Connection conn, DataRow data2Update, DataTableQuery query) throws SystemException {
        int counterUpdated;
        block16: {
            if (!this.updateable) {
                throw new SystemException(String.format("No permission to update data in table '%s.%s'.", this.getTableScheme(), this.getTablename()));
            }
            counterUpdated = 0;
            try (DbTableOperationHandler oph = this.extenderHandler.createOperationHandler(DbTableOperationType.UPDATE, conn);){
                DataTableQuery clonedQuery = new DataTableQuery(query);
                this.addDefaultFilters2Query(clonedQuery);
                DataRow tableSpecificData2Update = this.retrieveTableSpecificDataRow(data2Update);
                this.removeIdColumnFromRow(tableSpecificData2Update);
                oph.addColumns2Row(DbTableOperationType.UPDATE, conn, tableSpecificData2Update, clonedQuery);
                if (tableSpecificData2Update.getColumnCount() > 0) {
                    DataTableQuery filterAdjustedClonedQuery = oph.adjustFilter4Operation(DbTableOperationType.UPDATE, conn, tableSpecificData2Update.getColumnsCollection(), tableSpecificData2Update, clonedQuery);
                    oph.checkAllowed(DbTableOperationType.UPDATE, conn, tableSpecificData2Update.getColumnsCollection(), tableSpecificData2Update, filterAdjustedClonedQuery);
                    String sql = DbTableUtils.buildUpdateSQL4ColumnsAndQuery(this.getTablename(), null, tableSpecificData2Update.getColumnsCollection(), filterAdjustedClonedQuery);
                    try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                        counterUpdated = this.updateDataSingleQuery(oph, pstmt, tableSpecificData2Update, filterAdjustedClonedQuery);
                        break block16;
                    }
                }
                counterUpdated = 0;
            }
            catch (Throwable t) {
                SystemException sysex = this.convertThrowable2SystemException(t, conn, String.format("Error updating data in table %s.%s", this.getTableScheme(), this.getTablename()));
                this.exceptionHandler.handleException(DbTableOperationType.UPDATE, conn, sysex);
            }
        }
        return counterUpdated;
    }

    @Override
    public int updateData(Connection conn, DataRow row2Update) throws SystemException {
        if (!this.hasIDColumn()) {
            throw new SystemException(String.format("No id column in table '%s' found.", this.tableDefinition.getName()));
        }
        TableColumn colID = this.getIDColumn();
        if (!row2Update.hasColumn(colID.getColumnName())) {
            throw new SystemException(String.format("No id column '%s' found in given data row. (table : '%s')", colID.getColumnName(), this.tableDefinition.getName()));
        }
        DataTableQuery query = new DataTableQuery(this.connInfo);
        query.appendToQuery(String.format("%s=?", colID.getColumnName()), row2Update.getData(colID.getColumnName()));
        return this.updateData(conn, row2Update, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int updateData(Connection conn, DataRowReader rows2Update) throws SystemException {
        if (!this.updateable) {
            throw new SystemException(String.format("No permission to update data in table '%s.%s'.", this.getTableScheme(), this.getTablename()));
        }
        if (!this.hasIDColumn()) {
            throw new SystemException(String.format("No id column in table '%s' found.", this.tableDefinition.getName()));
        }
        TableColumn colID = this.getIDColumn();
        if (!rows2Update.hasColumn(colID.getColumnName())) {
            throw new SystemException(String.format("No id column '%s' found in given DataRowReader. (table : '%s')", colID.getColumnName(), this.tableDefinition.getName()));
        }
        int countUpdate = 0;
        try (DbTableOperationHandler oph = this.extenderHandler.createOperationHandler(DbTableOperationType.UPDATE, conn);){
            DataRow readerRow = this.retrieveTableSpecificDataRow(new DataRow(rows2Update.getColumnsCollection(), Arrays.asList(new Object[rows2Update.getColumnCount()])));
            this.removeIdColumnFromRow(readerRow);
            oph.addColumns2Row(DbTableOperationType.UPDATE, conn, readerRow, null);
            if (readerRow.getColumnCount() == 0) {
                int n = 0;
                return n;
            }
            DataTableQuery queryDraft = new DataTableQuery(this.connInfo);
            queryDraft.appendToQuery(String.format("%s=?", colID.getColumnName()));
            this.addDefaultFilters2Query(queryDraft);
            int operationsCount = 0;
            String lastSQL = "";
            try (Statement pstmtUpdate = null;){
                while (rows2Update.hasNext()) {
                    try {
                        DataRow data2Update = this.retrieveTableSpecificDataRow((DataRow)rows2Update.next());
                        DataTableQuery query4Row = new DataTableQuery(queryDraft);
                        query4Row.addFilterCriterias(data2Update.getData(colID.getColumnName()));
                        this.removeIdColumnFromRow(data2Update);
                        DataTableQuery filterAdjustedClonedQuery = oph.adjustFilter4Operation(DbTableOperationType.UPDATE, conn, data2Update.getColumnsCollection(), data2Update, query4Row);
                        String currSQL = DbTableUtils.buildUpdateSQL4ColumnsAndQuery(this.getTablename(), null, readerRow.getColumnsCollection(), filterAdjustedClonedQuery);
                        if (!StringUtils.equals((String)lastSQL, (String)currSQL)) {
                            lastSQL = currSQL;
                            if (pstmtUpdate != null) {
                                pstmtUpdate.close();
                            }
                            pstmtUpdate = conn.prepareStatement(currSQL);
                        }
                        oph.checkAllowed(DbTableOperationType.UPDATE, conn, data2Update.getColumnsCollection(), data2Update, filterAdjustedClonedQuery);
                        oph.addColumns2Row(DbTableOperationType.UPDATE, conn, data2Update, filterAdjustedClonedQuery);
                        int singleUpdateCount = this.updateDataSingleQuery(oph, (PreparedStatement)pstmtUpdate, data2Update, filterAdjustedClonedQuery);
                        ++operationsCount;
                        operationsCount = this.handleCommitEveryDataRowReaderOperation(conn, operationsCount);
                        countUpdate += singleUpdateCount;
                    }
                    catch (Throwable t) {
                        SystemException sysex = this.convertThrowable2SystemException(t, conn, String.format("Error updating data in table %s.%s: %s", this.getTableScheme(), this.getTablename(), t.getMessage()));
                        this.exceptionHandler.handleException(DbTableOperationType.UPDATE, conn, sysex);
                    }
                }
            }
            int n = countUpdate;
            return n;
        }
        catch (Throwable t) {
            throw this.convertThrowable2SystemException(t, conn, String.format("Error updating data in table %s.%s: %s", this.getTableScheme(), this.getTablename(), t.getMessage()));
        }
    }

    @Override
    public int updateData(DataRow data2Update, DataTableQuery query) throws SystemException {
        DbTableConnectionHandler connHndl = this.createDbTableConnectionHandler();
        try {
            int intAnzahl = this.updateData(connHndl.getConnection(), data2Update, query);
            connHndl.commitIfAutocommit();
            int n = intAnzahl;
            return n;
        }
        catch (Throwable e) {
            connHndl.closeConnectionAfterExceptionQuietly();
            if (e instanceof SystemException) {
                throw (SystemException)e;
            }
            throw new SystemException(this.getClass(), e);
        }
        finally {
            connHndl.closeConnectionQuietly();
        }
    }

    @Override
    public int updateData(DataRow row2Update) throws SystemException {
        if (!this.hasIDColumn()) {
            throw new SystemException(String.format("No id column in table '%s' found.", this.tableDefinition.getName()));
        }
        DbTableConnectionHandler connHndl = this.createDbTableConnectionHandler();
        try {
            int intAnzahl = this.updateData(connHndl.getConnection(), row2Update);
            connHndl.commitIfAutocommit();
            int n = intAnzahl;
            return n;
        }
        catch (Throwable e) {
            connHndl.closeConnectionAfterExceptionQuietly();
            if (e instanceof SystemException) {
                throw (SystemException)e;
            }
            throw new SystemException(this.getClass(), e);
        }
        finally {
            connHndl.closeConnectionQuietly();
        }
    }

    @Override
    public int updateData(DataRowReader rows2Update) throws SystemException {
        if (!this.hasIDColumn()) {
            throw new SystemException(String.format("No id column in table '%s' found.", this.tableDefinition.getName()));
        }
        DbTableConnectionHandler connHndl = this.createDbTableConnectionHandler();
        try {
            int intAnzahl = this.updateData(connHndl.getConnection(), rows2Update);
            connHndl.commitIfAutocommit();
            int n = intAnzahl;
            return n;
        }
        catch (Throwable e) {
            connHndl.closeConnectionAfterExceptionQuietly();
            if (e instanceof SystemException) {
                throw (SystemException)e;
            }
            throw new SystemException(this.getClass(), e);
        }
        finally {
            connHndl.closeConnectionQuietly();
        }
    }

    private synchronized void initDefaultValuesByTableDefinition() throws SystemException {
        try {
            for (TableColumn column : this.tableDefinedDefaultValuesCache.keySet()) {
                column.setDefaultValue(this.tableDefinedDefaultValuesCache.get(column));
            }
            this.tableDefinedDefaultValuesCache.clear();
            if (StringUtils.isNotBlank((String)this.tableDefinition.getStrDefault())) {
                String[] arrtemp;
                for (String arrtemp1 : arrtemp = this.tableDefinition.getStrDefault().split("\\|")) {
                    int intSplit = arrtemp1.indexOf(61);
                    if (intSplit == -1) {
                        throw new SystemException(String.format("Invalid default dataset in table %s - value %s", this.getTablename(), arrtemp1));
                    }
                    String[] arrtemp3 = new String[]{arrtemp1.substring(0, intSplit).toLowerCase(), arrtemp1.substring(intSplit + 1)};
                    TableColumn col = this.getColumn(arrtemp3[0]);
                    if (col == null) continue;
                    this.tableDefinedDefaultValuesCache.put(col, col.getDefaultValueInternal());
                    if (arrtemp3[1].toLowerCase().startsWith("#select")) {
                        col.setDefaultValue(new SQLDefaultValue(arrtemp3[1].substring(1), this.connMngr));
                        continue;
                    }
                    col.setDefaultValue(new ConstantDefaultValue(arrtemp3[1]));
                }
            }
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), String.format("Error initializing default values in table '%s.%s': %s", this.getTableScheme(), this.getTablename(), e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public void setFilterdef(String _filterdef) {
        this.tableDefinition.setFilter(_filterdef);
    }

    @Override
    public String getFilterdef() {
        return this.tableDefinition.getFilter();
    }

    @Override
    public void setSequence(String idSeq) {
        this.tableDefinition.setSeq(idSeq);
    }

    @Override
    public boolean getInsertable() {
        return this.insertable;
    }

    @Override
    public boolean getUpdateable() {
        return this.updateable;
    }

    @Override
    public boolean getDeleteable() {
        return this.deleteable;
    }

    @Override
    public boolean setInsertable(boolean _insertable) {
        if (!_insertable) {
            this.insertable = false;
            return false;
        }
        if (this.tableDefinition.getInsert() == 0) {
            return false;
        }
        this.insertable = _insertable;
        return this.insertable;
    }

    @Override
    public boolean setUpdateable(boolean _updateable) {
        if (!_updateable) {
            this.updateable = false;
            return false;
        }
        if (this.tableDefinition.getUpdate() == 0) {
            return false;
        }
        this.updateable = _updateable;
        return this.updateable;
    }

    @Override
    public boolean setDeleteable(boolean _deleteable) {
        if (!_deleteable) {
            this.deleteable = false;
            return false;
        }
        if (this.tableDefinition.getDelete() == 0) {
            return false;
        }
        this.deleteable = _deleteable;
        return this.deleteable;
    }

    @Override
    public boolean hasColumn(String columnName, int[] types) {
        return this.columnProvider.hasColumn(columnName, types);
    }

    @Override
    public void setDelCondition(String delCondition) {
        this.tableDefinition.setDeleteCondition(StringUtils.defaultString((String)delCondition, (String)""));
    }

    @Override
    public void setOrderBy(String orderBy) {
        this.tableDefinition.setOrder(DbTableUtils.formatOrderBy(orderBy, this.tableDefinition.getIdColumn()));
    }

    @Override
    public boolean hasColumn(String columnName) {
        return this.columnProvider.hasColumn(columnName);
    }

    @Override
    public TableColumn getColumn(String columnName) throws IllegalArgumentException {
        return this.columnProvider.getColumn(columnName);
    }

    @Override
    public Collection<TableColumn> getColumnsCollection() {
        return this.columnProvider.getColumnsCollection();
    }

    @Override
    public Collection<TableColumn> getColumnsCollection(Collection<String> columnNames) {
        return this.columnProvider.getColumnsCollection(columnNames);
    }

    @Override
    public Collection<TableColumn> getColumnsCollection(String ... columnNames) {
        return this.columnProvider.getColumnsCollection(columnNames);
    }

    @Override
    public Collection<String> getColumnNames() {
        return this.columnProvider.getColumnNames();
    }

    @Override
    public Collection<String> getColumnNames(Collection<TableColumn> columns) {
        return this.columnProvider.getColumnNames(columns);
    }

    @Override
    public Collection<String> getColumnNames(TableColumn ... columns) {
        return this.columnProvider.getColumnNames(columns);
    }

    public void setIdColumn(String idColumnName) {
        if (StringUtils.isBlank((String)idColumnName)) {
            this.tableDefinition.setIdColumn("");
        } else if (this.hasColumn(idColumnName)) {
            this.tableDefinition.setIdColumn(idColumnName);
        } else {
            throw new IllegalArgumentException(String.format("Error setting Id-column with name '%s'. Column not found in table.", idColumnName));
        }
        for (TableColumn col : this.getColumnsCollection()) {
            if (col.getColumnName().equalsIgnoreCase(this.tableDefinition.getIdColumn())) {
                col.setPrimaryKeyIndex(1);
                continue;
            }
            col.setPrimaryKeyIndex(-1);
        }
    }

    @Override
    public boolean hasIDColumn() {
        return this.columnProvider.hasIDColumn();
    }

    @Override
    public TableColumn getIDColumn() throws IndexOutOfBoundsException {
        return this.hasIDColumn() ? this.columnProvider.getIDColumn() : null;
    }

    @Override
    public GeoColumn getDefaultGeoColumn() throws IndexOutOfBoundsException {
        return this.columnProvider.getDefaultGeoColumn();
    }

    @Override
    public boolean hasGeoColumn() {
        return this.columnProvider.hasGeoColumn();
    }

    @Override
    public int getColumnCount() {
        return this.columnProvider.getColumnCount();
    }

    @Override
    public int getSqlType(String columnName) {
        return this.columnProvider.getSqlType(columnName);
    }

    @Override
    public void addExtender(DbTableExtender extender) throws SystemException {
        this.extenderHandler.addExtender(extender);
    }

    @Override
    public void removeExtender(DbTableExtender extender) {
        this.extenderHandler.removeExtender(extender);
    }

    @Override
    public void addRowValidator(DataRowValidator rowValidator) {
        this.rowValidators.add(rowValidator);
    }

    @Override
    public void removeRowValidator(DataRowValidator rowValidator) {
        this.rowValidators.remove(rowValidator);
    }

    @Override
    public <T extends DataRowValidator> Collection<T> retrieveRowValidator(Class<T> clazz) {
        ArrayList<DataRowValidator> result = new ArrayList<DataRowValidator>();
        for (DataRowValidator rowValidator : this.rowValidators) {
            if (clazz != null && !clazz.isInstance(rowValidator)) continue;
            DataRowValidator classedRV = rowValidator;
            result.add(classedRV);
        }
        return result;
    }

    @Override
    public Collection<ValidationError> validateDataRow(DataRow dataRow, DbTableOperationType operationType) {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        validationErrors.addAll(this.columnRowValidator.validateDataRow(dataRow, operationType));
        for (DataRowValidator customValidator : this.rowValidators) {
            validationErrors.addAll(customValidator.validateDataRow(dataRow, operationType));
        }
        return validationErrors;
    }

    protected void validateDataRowThrowingException(DataRow dataRow, DbTableOperationType operationType) throws ValidationSystemException {
        Collection<ValidationError> validationErrors = this.validateDataRow(dataRow, operationType);
        if (validationErrors.size() > 0) {
            throw new ValidationSystemException(validationErrors);
        }
    }

    @Override
    public <T extends DbTableExtender> Collection<T> retrieveExtenderCollection(Class<T> clazz) {
        return this.extenderHandler.retrieveExtender(clazz);
    }

    @Override
    public <T extends DbTableExtender> T retrieveExtender(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Should never reach here. NULL class is not allowed when retieving extenders from table.");
        }
        Collection<T> colExtenders = this.retrieveExtenderCollection(clazz);
        if (colExtenders.isEmpty()) {
            return null;
        }
        if (colExtenders.size() == 1) {
            return (T)((DbTableExtender)colExtenders.iterator().next());
        }
        throw new IllegalStateException(String.format("More than one extender found in table '%s' for given class '%s'.", this.getTablename(), clazz.getName()));
    }

    @Override
    public DbTableUserInfo getUserInfo() {
        return this.userInfo;
    }

    @Override
    public void setUserInfo(DbTableUserInfo userInfo) {
        this.userInfo = userInfo;
        Collection<DbTablePresetValuesExtender> extenders = this.retrieveExtenderCollection(DbTablePresetValuesExtender.class);
        for (DbTablePresetValuesExtender extender : extenders) {
            extender.initUserInfoPresetValues(this);
        }
    }

    @Override
    public void setCommitEveryDataRowReaderOperation(int commitEvery) {
        this.commitEveryDataRowReaderOperation = commitEvery > 0 ? commitEvery : -1;
    }

    @Override
    public int getCommitEveryDataRowReaderOperation() {
        return this.commitEveryDataRowReaderOperation;
    }

    protected int handleCommitEveryDataRowReaderOperation(Connection conn, int operationsCount) throws SQLException {
        if (this.commitEveryDataRowReaderOperation > 0 && !conn.getAutoCommit()) {
            if (operationsCount >= this.commitEveryDataRowReaderOperation) {
                conn.commit();
                return 0;
            }
            return operationsCount;
        }
        return 0;
    }

    @Override
    public List<Object> getDataListId(Connection conn, DataTableQuery query) throws SystemException {
        ArrayList<Object> arrayList;
        block11: {
            if (!this.hasIDColumn()) {
                throw new SystemException(String.format("No id column in table definition of '%s' found.", this.getTablename()));
            }
            DataRowReaderResultSet rowReader = this.getData(conn, query, this.getIDColumn().getColumnName());
            try {
                ArrayList<Object> lstID = new ArrayList<Object>();
                while (rowReader.hasNext()) {
                    lstID.add(((DataRow)rowReader.next()).getData(0));
                }
                arrayList = lstID;
                if (rowReader == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (rowReader != null) {
                        try {
                            rowReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SystemException se) {
                    throw se;
                }
                catch (Exception e) {
                    throw new SystemException((Throwable)e);
                }
            }
            rowReader.close();
        }
        return arrayList;
    }

    @Override
    public List<Object> getDataListId(DataTableQuery query) throws SystemException {
        DbTableConnectionHandler connHndl = this.createDbTableConnectionHandler();
        try {
            List<Object> dataListId = this.getDataListId(connHndl.getConnection(), query);
            connHndl.commitIfAutocommit();
            List<Object> list = dataListId;
            return list;
        }
        catch (Throwable e) {
            connHndl.closeConnectionAfterExceptionQuietly();
            if (e instanceof SystemException) {
                throw (SystemException)e;
            }
            throw new SystemException(this.getClass(), e);
        }
        finally {
            connHndl.closeConnectionQuietly();
        }
    }

    @Override
    public String getDefaultValues() {
        return this.tableDefinition.getStrDefault();
    }

    @Override
    public void setDefaultValues(String defaultValues) throws SystemException {
        this.tableDefinition.setStrDefault(defaultValues);
        this.initDefaultValuesByTableDefinition();
    }

    @Override
    public int getLogSelects() {
        return this.tableDefinition.getSelectlog();
    }

    @Override
    public int getLogChanges() {
        return this.tableDefinition.getChangelog();
    }

    @Override
    public void setLogSelects(int loggingConfig) {
        if (loggingConfig < 0 || loggingConfig > 2) {
            throw new IllegalArgumentException("Should never reach here: loggingConfig must be 0,1 or 2.");
        }
        this.tableDefinition.setSelectlog(loggingConfig);
    }

    @Override
    public void setLogChanges(int loggingConfig) {
        if (loggingConfig < 0 || loggingConfig > 2) {
            throw new IllegalArgumentException("Should never reach here: loggingConfig must be 0,1 or 2.");
        }
        this.tableDefinition.setChangelog(loggingConfig);
    }

    @Override
    public void setExceptionHandler(DbTableSqlExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public DbTableSqlExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public boolean isMySqlLatinDb() {
        return this.mySqlLatinDb;
    }

    protected SystemException convertThrowable2SystemException(Throwable t, Connection conn, String defaultErrorText) {
        SQLException mappedThrowable;
        Object sysEx = t instanceof SystemException ? (SystemException)t : (t instanceof SQLException ? ((mappedThrowable = SQLExceptionMapper.mapException((Locale)Config.LOCALE, (Connection)conn, (SQLException)((SQLException)t))) instanceof UserFormattedSQLException && (((UserFormattedSQLException)mappedThrowable).getErrorCodeClass() == ErrorCodeClass.UNIQUE_FAILED || ((UserFormattedSQLException)mappedThrowable).getErrorCodeClass() == ErrorCodeClass.DEPENDENCY_EXISTS) ? new NoLoggingSystemException(this.getClass(), (Throwable)mappedThrowable) : new SystemException(this.getClass(), (Throwable)mappedThrowable)) : new SystemException(this.getClass(), defaultErrorText, t));
        return sysEx;
    }
}

