/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table;

import de.riwagis.riwadatatable.table.DbTable;
import de.riwagis.riwadatatable.table.DbTableOperationHandler;
import de.riwagis.riwadatatable.table.extension.DbTableExtender;
import de.riwagis.riwadatatable.table.extension.DbTableExtenderPriority;
import de.riwagis.riwadatatable.table.extension.DbTableOperationType;
import de.riwagis.util.exception.SystemException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DbTableExtenderHandler {
    public static final Comparator<DbTableExtender> COMPARE_BY_PRIORITY = new Comparator<DbTableExtender>(){

        @Override
        public int compare(DbTableExtender o1, DbTableExtender o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return DbTableExtenderPriority.COMPARE_BY_PRIO.compare(o1.getPriority(), o2.getPriority());
        }
    };
    private final DbTable dbTable;
    private final List<DbTableExtender> extenders = new ArrayList<DbTableExtender>();

    DbTableExtenderHandler(DbTable dbTable, Collection<DbTableExtender> extenders) {
        this.dbTable = dbTable;
        if (extenders != null) {
            this.extenders.addAll(extenders);
            Collections.sort(this.extenders, COMPARE_BY_PRIORITY);
        }
    }

    void addExtender(DbTableExtender extender) throws SystemException {
        this.extenders.add(extender);
        Collections.sort(this.extenders, COMPARE_BY_PRIORITY);
        extender.afterInitialisation(this.dbTable);
    }

    void removeExtender(DbTableExtender extender) {
        boolean removed = this.extenders.remove(extender);
        if (removed) {
            Collections.sort(this.extenders, COMPARE_BY_PRIORITY);
        }
    }

    <T extends DbTableExtender> Collection<T> retrieveExtender(Class<T> clazz) {
        ArrayList<DbTableExtender> result = new ArrayList<DbTableExtender>();
        for (DbTableExtender extender : this.extenders) {
            if (clazz != null && !clazz.isInstance(extender)) continue;
            result.add(extender);
        }
        return result;
    }

    public DbTableOperationHandler createOperationHandler(DbTableOperationType type, Connection conn) throws SystemException {
        return new DbTableOperationHandler(this.dbTable, this.extenders, type, conn);
    }

    void afterInitialisation() throws SystemException {
        if (this.extenders.isEmpty()) {
            return;
        }
        for (DbTableExtender extender : this.extenders) {
            extender.afterInitialisation(this.dbTable);
        }
    }
}

