/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table;

import de.riwagis.riwadatatable.jdbc.JDBCConnectionManager;
import de.riwagis.riwadatatable.table.DbTableUtils;
import de.riwagis.util.exception.SystemException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbutils.DbUtils;

public class DbTableConnectionHandler {
    private Connection conn = null;
    private final boolean autocommit;
    private final JDBCConnectionManager connMngr;

    DbTableConnectionHandler(JDBCConnectionManager connMngr) throws SystemException {
        this.connMngr = connMngr;
        try {
            this.conn = connMngr.createConnection();
            this.autocommit = this.conn.getAutoCommit();
            this.conn.setAutoCommit(false);
        }
        catch (Throwable t) {
            DbUtils.closeQuietly((Connection)this.conn);
            if (t instanceof SystemException) {
                throw (SystemException)t;
            }
            throw new SystemException("Error opening connection with DbTableConnectionHandler", t);
        }
    }

    public Connection getConnection() {
        return this.conn;
    }

    public void commitIfAutocommit() throws SQLException {
        if (this.autocommit) {
            this.conn.commit();
        }
    }

    public void closeConnectionAfterExceptionQuietly() {
        if (this.autocommit) {
            DbTableUtils.rollbackQuietly(this.conn, null);
        }
        if (this.autocommit) {
            DbTableUtils.setAutoCommitQuietly(this.conn, this.autocommit);
        }
        try {
            this.connMngr.closeConnection(this.conn);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void closeConnectionQuietly() {
        if (this.autocommit) {
            DbTableUtils.setAutoCommitQuietly(this.conn, this.autocommit);
        }
        try {
            this.connMngr.closeConnection(this.conn);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

