/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.table;

import de.riwagis.riwadatatable.columns.NumberColumn;
import de.riwagis.riwadatatable.columns.provider.ColumnProvider;
import de.riwagis.riwadatatable.data.DataRow;
import de.riwagis.riwadatatable.data.DataRowReader;
import de.riwagis.riwadatatable.filter.DataTableQuery;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionInfo;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionManager;
import de.riwagis.riwadatatable.table.DbTableSqlExceptionHandler;
import de.riwagis.riwadatatable.table.SpatialQueryType;
import de.riwagis.riwadatatable.table.TableDefinition;
import de.riwagis.riwadatatable.table.extension.DbTableExtender;
import de.riwagis.riwadatatable.table.userinfo.DbTableUserInfo;
import de.riwagis.riwadatatable.validation.DataRowValidator;
import de.riwagis.util.exception.SystemException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Geometry;

public interface DbTable
extends ColumnProvider,
DataRowValidator {
    public static final String TABLE_ALIAS = "tbl";
    public static final String TABLE_ALIAS_DOTTED = "tbl.";

    public void addDefaultTableValuesToDataRow(Connection var1, DataRow var2, boolean var3) throws SystemException, SQLException;

    public int deleteData(DataTableQuery var1) throws SystemException;

    public int deleteData(DataRow var1) throws SystemException;

    public int deleteData(DataRowReader var1) throws SystemException;

    public int deleteDataByID(Object var1) throws SystemException;

    public int deleteData(Connection var1, DataTableQuery var2) throws SystemException;

    public int deleteData(Connection var1, DataRow var2) throws SystemException;

    public int deleteData(Connection var1, DataRowReader var2) throws SystemException;

    public int deleteDataByID(Connection var1, Object var2) throws SystemException;

    public JDBCConnectionInfo getConnectionInfo();

    public JDBCConnectionManager getConnectionManagerInternal();

    public int getCount(DataTableQuery var1) throws SystemException;

    public int getCount(Connection var1, DataTableQuery var2) throws SystemException;

    public List<Object> getDataListId(Connection var1, DataTableQuery var2) throws SystemException;

    public List<Object> getDataListId(DataTableQuery var1) throws SystemException;

    public ReferencedEnvelope getBounds(DataTableQuery var1) throws SystemException;

    public ReferencedEnvelope getBounds(Connection var1, DataTableQuery var2) throws SystemException;

    public ReferencedEnvelope getBounds(DataTableQuery var1, String var2) throws SystemException;

    public ReferencedEnvelope getBounds(Connection var1, DataTableQuery var2, String var3) throws SystemException;

    public DataRow getData(Object var1, Collection<String> var2) throws SystemException;

    public DataRow getData(Object var1, String ... var2) throws SystemException;

    public DataRowReader getData(DataTableQuery var1, Collection<String> var2) throws SystemException;

    public DataRowReader getData(DataTableQuery var1, String ... var2) throws SystemException;

    public DataRow getData(Connection var1, Object var2, Collection<String> var3) throws SystemException;

    public DataRow getData(Connection var1, Object var2, String ... var3) throws SystemException;

    public DataRowReader getData(Connection var1, DataTableQuery var2, Collection<String> var3) throws SystemException;

    public DataRowReader getData(Connection var1, DataTableQuery var2, String ... var3) throws SystemException;

    public DataRowReader getDataBySpatialQuery(Geometry var1, SpatialQueryType var2, DataTableQuery var3, String ... var4) throws SystemException;

    public DataRowReader getDataBySpatialQuery(Geometry var1, SpatialQueryType var2, DataTableQuery var3, Collection<String> var4) throws SystemException;

    public DataRowReader getDataBySpatialQuery(Connection var1, Geometry var2, SpatialQueryType var3, DataTableQuery var4, String ... var5) throws SystemException;

    public DataRowReader getDataBySpatialQuery(Connection var1, Geometry var2, SpatialQueryType var3, DataTableQuery var4, Collection<String> var5) throws SystemException;

    public DbTable deriveDbTable(TableDefinition var1, Collection<DbTableExtender> var2) throws SystemException, SQLException;

    public boolean getDeleteable();

    public String getFilterdef();

    public String getDefaultValues();

    public int getLogSelects();

    public int getLogChanges();

    public Object getIDLastInsert();

    public boolean getInsertable();

    public DataRow getSum(DataTableQuery var1, Collection<String> var2) throws SystemException;

    public DataRow getSum(Connection var1, DataTableQuery var2, Collection<String> var3) throws SystemException;

    public TableDefinition getTableDefinition();

    public String getTablename();

    public boolean getUpdateable();

    public int insertData(DataRow var1) throws SystemException;

    public int insertData(DataRowReader var1) throws SystemException;

    public int insertData(Connection var1, DataRow var2) throws SystemException;

    public int insertData(Connection var1, DataRowReader var2) throws SystemException;

    public String orderBySQL();

    public boolean setDeleteable(boolean var1);

    public void setDelCondition(String var1);

    public void setFilterdef(String var1);

    public void setDefaultValues(String var1) throws SystemException;

    public void setLogSelects(int var1);

    public void setLogChanges(int var1);

    public boolean setInsertable(boolean var1);

    public void setOrderBy(String var1);

    public void setSequence(String var1);

    public boolean setUpdateable(boolean var1);

    public int updateData(DataRow var1, DataTableQuery var2) throws SystemException;

    public int updateData(DataRow var1) throws SystemException;

    public int updateData(DataRowReader var1) throws SystemException;

    public int updateData(Connection var1, DataRow var2, DataTableQuery var3) throws SystemException;

    public int updateData(Connection var1, DataRow var2) throws SystemException;

    public int updateData(Connection var1, DataRowReader var2) throws SystemException;

    public DbTableUserInfo getUserInfo();

    public void setUserInfo(DbTableUserInfo var1);

    public void setCommitEveryDataRowReaderOperation(int var1);

    public int getCommitEveryDataRowReaderOperation();

    public void addExtender(DbTableExtender var1) throws SystemException;

    public void removeExtender(DbTableExtender var1);

    public <T extends DbTableExtender> Collection<T> retrieveExtenderCollection(Class<T> var1);

    public <T extends DbTableExtender> T retrieveExtender(Class<T> var1);

    public void addRowValidator(DataRowValidator var1);

    public void removeRowValidator(DataRowValidator var1);

    public <T extends DataRowValidator> Collection<T> retrieveRowValidator(Class<T> var1);

    public void setExceptionHandler(DbTableSqlExceptionHandler var1);

    public DbTableSqlExceptionHandler getExceptionHandler();

    default public DataTableQuery buildIDQuery(Object idValue) throws SystemException {
        if (!this.hasIDColumn() || StringUtils.isBlank((CharSequence)this.getTableDefinition().getIdColumn())) {
            throw new SystemException(String.format("no id column in table '%s' found.", this.getTableDefinition().getName()));
        }
        DataTableQuery query = new DataTableQuery(this.getConnectionInfo());
        Object idValueWorkaround = this.applyIDValueWorkaround(idValue);
        query.appendToQuery(String.format("%s=?", this.getIDColumn().getColumnName()), idValueWorkaround);
        return query;
    }

    default public Object applyIDValueWorkaround(Object idValue) throws SystemException {
        if (this.getConnectionInfo().isPostgres() && this.getIDColumn() instanceof NumberColumn && idValue instanceof String) {
            return (Number)this.getIDColumn().parseObject(idValue.toString());
        }
        return idValue;
    }

    default public boolean isMySqlLatinDb() {
        return false;
    }
}

