/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.sequence;

import de.riwagis.riwadatatable.jdbc.DBType;
import de.riwagis.riwadatatable.sequence.TableSequenceHandler;
import de.riwagis.riwadatatable.sequence.TableSequenceHandlerMSSQLServer;
import de.riwagis.riwadatatable.sequence.TableSequenceHandlerMSSQLServerAutoincrement;
import de.riwagis.riwadatatable.sequence.TableSequenceHandlerMySQLAutoincrement;
import de.riwagis.riwadatatable.sequence.TableSequenceHandlerOracle;
import de.riwagis.riwadatatable.sequence.TableSequenceHandlerPostgres;
import de.riwagis.riwadatatable.sequence.TableSequenceHandlerPostgresAutoincrement;
import de.riwagis.riwadatatable.sequence.TableSequenceHandlerSimple;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TableSequenceHandlerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TableSequenceHandlerUtils.class);
    public static final TableSequenceHandler NONE = new TableSequenceHandler(){

        @Override
        public boolean isAutoIncrement() {
            return true;
        }

        @Override
        public Object generateNextID(Connection conn) throws SQLException {
            return null;
        }

        @Override
        public Object retrieveLastID(Statement pstmt) throws SQLException {
            LOG.warn("no sequence handler used, which returns valid IDs. Maybe the database is not yet supported.");
            return null;
        }
    };

    public static TableSequenceHandler buildTableSequenceHandler(DBType dbType, String seq, String idColumnName, String tablename, boolean isAutoincrement) {
        TableSequenceHandler res = NONE;
        if (StringUtils.isNotBlank((String)idColumnName)) {
            if (StringUtils.isNotBlank((String)seq) && seq.startsWith("$$")) {
                try {
                    String seqHandlerClassName = seq.substring(2);
                    Class<?> seqHandlerClass = Class.forName(seqHandlerClassName);
                    Constructor<?> seqHandlerConstr = seqHandlerClass.getConstructor(String.class, String.class);
                    res = (TableSequenceHandler)seqHandlerConstr.newInstance(tablename, idColumnName);
                }
                catch (Throwable t) {
                    throw new IllegalArgumentException(String.format("Error creating custom sequence handler '%s' for table '%s'.", seq, tablename), t);
                }
            } else {
                switch (dbType) {
                    case Oracle: {
                        if (StringUtils.isNotBlank((String)seq)) {
                            res = new TableSequenceHandlerOracle(seq, tablename, idColumnName);
                            break;
                        }
                        res = new TableSequenceHandlerSimple(tablename, idColumnName);
                        break;
                    }
                    case MariaDB: 
                    case MySQL: {
                        if (isAutoincrement) {
                            res = new TableSequenceHandlerMySQLAutoincrement();
                            break;
                        }
                        res = new TableSequenceHandlerSimple(tablename, idColumnName);
                        break;
                    }
                    case MSSQLServer: {
                        if (isAutoincrement) {
                            res = new TableSequenceHandlerMSSQLServerAutoincrement();
                            break;
                        }
                        if (StringUtils.isNotBlank((String)seq)) {
                            res = new TableSequenceHandlerMSSQLServer(seq);
                            break;
                        }
                        res = new TableSequenceHandlerSimple(tablename, idColumnName);
                        break;
                    }
                    case Postgres: {
                        if (isAutoincrement) {
                            res = new TableSequenceHandlerPostgresAutoincrement(String.format("%s_%s_seq", tablename, idColumnName), idColumnName);
                            break;
                        }
                        if (StringUtils.isNotBlank((String)seq) && !"TB_UFID_S".equalsIgnoreCase(seq)) {
                            res = new TableSequenceHandlerPostgres(seq, idColumnName);
                            break;
                        }
                        res = new TableSequenceHandlerSimple(tablename, idColumnName);
                        break;
                    }
                    default: {
                        res = new TableSequenceHandlerSimple(tablename, idColumnName);
                    }
                }
            }
        }
        return res;
    }

    public static PreparedStatement buildPreparedInsertStatement4Insert(Connection conn, String sqlInsert, TableSequenceHandler tsl) throws SQLException {
        PreparedStatement pstmt = tsl.isAutoIncrement() ? conn.prepareStatement(sqlInsert, 1) : conn.prepareStatement(sqlInsert);
        return pstmt;
    }

    private TableSequenceHandlerUtils() {
    }
}

