/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.sequence;

import de.riwagis.riwadatatable.sequence.TableSequenceHandler;
import de.riwagis.riwadatatable.sequence.TableSequenceHandlerDefaultAutoincrement;
import de.riwagis.util.jdbc.JDBCSupport;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang.StringUtils;

public class TableSequenceHandlerOracle
implements TableSequenceHandler {
    public static final String FID_INCREMENT_SEQUENCE_MAP3D = "TB_UFID_S";
    private final String sequenceName;
    private final String tableName;
    private final String idColumnName;
    private Object lastID = null;
    private final boolean autoincrement;

    public TableSequenceHandlerOracle(String _sequenceName, String tableName, String idColumnName) {
        this.sequenceName = _sequenceName;
        this.idColumnName = idColumnName;
        this.tableName = tableName;
        this.autoincrement = StringUtils.defaultIfBlank((String)_sequenceName, (String)"").equalsIgnoreCase("##AUTOINCREMENT##");
    }

    @Override
    public boolean isAutoIncrement() {
        return this.autoincrement;
    }

    @Override
    public Object generateNextID(Connection conn) throws SQLException {
        if (!this.autoincrement) {
            this.lastID = JDBCSupport.nextIDOracleSequence((Connection)conn, (String)this.sequenceName);
            return this.lastID;
        }
        this.lastID = null;
        return null;
    }

    @Override
    public Object retrieveLastID(Statement pstmt) throws SQLException {
        if ((this.lastID == null || this.autoincrement) && StringUtils.isNotBlank((String)this.tableName) && StringUtils.isNotBlank((String)this.idColumnName)) {
            Object oracleRowId = TableSequenceHandlerDefaultAutoincrement.readAutoincrementedKey(pstmt);
            try (PreparedStatement stmtRowId = pstmt.getConnection().prepareStatement(String.format("select %s from %s where rowid=?", this.idColumnName, this.tableName));){
                stmtRowId.setRowId(1, (RowId)oracleRowId);
                try (ResultSet rs = stmtRowId.executeQuery();){
                    if (rs.next()) {
                        this.lastID = rs.getObject(1);
                    }
                }
            }
        }
        return this.lastID;
    }
}

