/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.sequence;

import de.riwagis.riwadatatable.sequence.TableSequenceHandler;
import de.riwagis.riwadatatable.sequence.TableSequenceHandlerDefaultAutoincrement;
import de.riwagis.util.jdbc.JDBCSupport;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang.StringUtils;

public class TableSequenceHandlerMSSQLServer
implements TableSequenceHandler {
    private final String sequenceName;
    private Object lastID = null;
    private final boolean autoincrement;

    public TableSequenceHandlerMSSQLServer(String _sequenceName) {
        this.sequenceName = _sequenceName;
        this.autoincrement = StringUtils.defaultIfBlank((String)_sequenceName, (String)"").equalsIgnoreCase("##AUTOINCREMENT##");
    }

    @Override
    public boolean isAutoIncrement() {
        return this.autoincrement;
    }

    @Override
    public Object generateNextID(Connection conn) throws SQLException {
        if (!this.autoincrement) {
            this.lastID = JDBCSupport.nextID((Connection)conn, (String)String.format("SELECT NEXT VALUE FOR %s", this.sequenceName), (String)this.sequenceName);
            return this.lastID;
        }
        this.lastID = null;
        return null;
    }

    @Override
    public Object retrieveLastID(Statement pstmt) throws SQLException {
        if (this.lastID == null) {
            return TableSequenceHandlerDefaultAutoincrement.readAutoincrementedKey(pstmt);
        }
        return this.lastID;
    }
}

