/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.sequence;

import de.riwagis.riwadatatable.sequence.TableSequenceHandler;
import de.riwagis.util.jdbc.JDBCSupport;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicLong;

public class TableSequenceHandlerInternalCounting
implements TableSequenceHandler {
    private final AtomicLong currentID = new AtomicLong();

    public static TableSequenceHandler buildTableSequenceHandlerInternalCounting(Connection conn, String idColumn, String tableName) throws SQLException {
        Long nextId = (Long)JDBCSupport.nextIDMaxValue((Connection)conn, (String)idColumn, (String)tableName);
        return new TableSequenceHandlerInternalCounting(nextId == null ? 1L : nextId);
    }

    public TableSequenceHandlerInternalCounting(long startID) {
        this.currentID.set(startID);
    }

    @Override
    public boolean isAutoIncrement() {
        return false;
    }

    @Override
    public Object generateNextID(Connection conn) throws SQLException {
        return this.currentID.incrementAndGet();
    }

    @Override
    public Object retrieveLastID(Statement pstmt) throws SQLException {
        return this.currentID.get();
    }
}

