/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.oracle.sdo;

import de.riwagis.riwadatatable.oracle.sdo.SDO;
import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import oracle.jdbc.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeometryConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GeometryConverter.class);
    private final OracleConnection connection;
    private final GeometryFactory geometryFactory;
    public static final String DATATYPE = "MDSYS.SDO_GEOMETRY";

    public GeometryConverter(Connection conn) {
        this(conn, new GeometryFactory());
    }

    public GeometryConverter(Connection conn, GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
        if (conn instanceof OracleConnection) {
            this.connection = (OracleConnection)conn;
        } else {
            try {
                this.connection = (OracleConnection)((DelegatingConnection)conn).getInnermostDelegate();
            }
            catch (Exception e) {
                throw new RuntimeException("org.geotools.data.oracle.sdo.GeometryConverter - error in casting oracle connection");
            }
        }
    }

    public String getDataTypeName() {
        return DATATYPE;
    }

    public boolean isCapable(Geometry geom) {
        if (geom == null) {
            return true;
        }
        if (geom instanceof Point || geom instanceof MultiPoint || geom instanceof LineString || geom instanceof MultiLineString || geom instanceof Polygon || geom instanceof MultiPolygon || geom instanceof GeometryCollection) {
            int d = SDO.D(geom);
            int l = SDO.L(geom);
            return l == 0 && (d == 2 || d == 3);
        }
        return false;
    }

    public Geometry asGeometry(STRUCT sdoGeometry, double dblTolerance) throws SQLException {
        if (sdoGeometry == null) {
            return null;
        }
        ResultSetMetaData meta = sdoGeometry.getDescriptor().getMetaData();
        LOG.debug("meta: " + meta);
        Datum[] data = sdoGeometry.getOracleAttributes();
        int GTYPE = GeometryConverter.asInteger(data[0], 0);
        int SRID = GeometryConverter.asInteger(data[1], -1);
        double[] POINT = GeometryConverter.asDoubleArray((STRUCT)data[2], Double.NaN);
        int[] ELEMINFO = GeometryConverter.asIntArray((ARRAY)data[3], 0);
        double[] ORDINATES = GeometryConverter.asDoubleArray((ARRAY)data[4], Double.NaN);
        return SDO.create(this.geometryFactory, GTYPE, SRID, POINT, ELEMINFO, ORDINATES, dblTolerance);
    }

    public static Geometry asGeometry(STRUCT sdoGeometry, GeometryFactory gfac, double dblTolerance) throws SQLException {
        if (sdoGeometry == null) {
            return null;
        }
        ResultSetMetaData meta = sdoGeometry.getDescriptor().getMetaData();
        LOG.debug("meta: " + meta);
        Datum[] data = sdoGeometry.getOracleAttributes();
        int GTYPE = GeometryConverter.asInteger(data[0], 0);
        int SRID = GeometryConverter.asInteger(data[1], -1);
        double[] POINT = GeometryConverter.asDoubleArray((STRUCT)data[2], Double.NaN);
        int[] ELEMINFO = GeometryConverter.asIntArray((ARRAY)data[3], 0);
        double[] ORDINATES = GeometryConverter.asDoubleArray((ARRAY)data[4], Double.NaN);
        return SDO.create(gfac, GTYPE, SRID, POINT, ELEMINFO, ORDINATES, dblTolerance);
    }

    public STRUCT toSDO(Geometry geom, int srid) throws SQLException {
        ARRAY SDO_ORDINATES;
        ARRAY SDO_ELEM_INFO;
        STRUCT SDO_POINT;
        if (geom == null) {
            return this.asEmptyDataType();
        }
        int gtype = SDO.gType(geom);
        NUMBER SDO_GTYPE = new NUMBER(gtype);
        NUMBER SDO_SRID = srid == -1 || srid == 0 ? null : new NUMBER(srid);
        double[] point = SDO.point(geom);
        if (point == null) {
            int[] elemInfo = SDO.elemInfo(geom);
            double[] ordinates = SDO.ordinates(geom);
            SDO_POINT = null;
            SDO_ELEM_INFO = this.toARRAY(elemInfo, "MDSYS.SDO_ELEM_INFO_ARRAY");
            SDO_ORDINATES = this.toARRAY(ordinates, "MDSYS.SDO_ORDINATE_ARRAY");
        } else {
            Datum[] data = new Datum[]{GeometryConverter.toNUMBER(point[0]), GeometryConverter.toNUMBER(point[1]), GeometryConverter.toNUMBER(point[2])};
            SDO_POINT = this.toSTRUCT(data, "MDSYS.SDO_POINT_TYPE");
            SDO_ELEM_INFO = null;
            SDO_ORDINATES = null;
        }
        Datum[] attributes = new Datum[]{SDO_GTYPE, SDO_SRID, SDO_POINT, SDO_ELEM_INFO, SDO_ORDINATES};
        return this.toSTRUCT(attributes, DATATYPE);
    }

    public STRUCT asEmptyDataType() throws SQLException {
        return this.toSTRUCT(null, DATATYPE);
    }

    public final STRUCT toSTRUCT(Datum[] attributes, String dataType) throws SQLException {
        if (((String)dataType).startsWith("*.")) {
            dataType = "DRA." + ((String)dataType).substring(2);
        }
        StructDescriptor descriptor = StructDescriptor.createDescriptor((String)dataType, (Connection)this.connection);
        return new STRUCT(descriptor, (Connection)this.connection, (Object[])attributes);
    }

    public final ARRAY toARRAY(double[] doubles, String dataType) throws SQLException {
        ArrayDescriptor descriptor = ArrayDescriptor.createDescriptor((String)dataType, (Connection)this.connection);
        return new ARRAY(descriptor, (Connection)this.connection, (Object)doubles);
    }

    public final ARRAY toORDINATE(CoordinateList list, double[][] measures, int D) throws SQLException {
        ArrayDescriptor descriptor = ArrayDescriptor.createDescriptor((String)"MDSYS.SDO_ORDINATE_ARRAY", (Connection)this.connection);
        int LENGTH = measures != null ? measures.length : 0;
        int LEN = D + LENGTH;
        Datum[] data = new Datum[list.size() * LEN];
        int offset = 0;
        int index = 0;
        for (Coordinate coord : list) {
            data[offset++] = GeometryConverter.toNUMBER(coord.x);
            data[offset++] = GeometryConverter.toNUMBER(coord.y);
            if (D == 3) {
                data[offset++] = GeometryConverter.toNUMBER(coord.z);
            }
            for (int j = 0; j < LENGTH; ++j) {
                data[offset++] = GeometryConverter.toNUMBER(measures[j][index]);
            }
            ++index;
        }
        return new ARRAY(descriptor, (Connection)this.connection, (Object)data);
    }

    public final ARRAY toORDINATE(double[] ords) throws SQLException {
        ArrayDescriptor descriptor = ArrayDescriptor.createDescriptor((String)"MDSYS.SDO_ORDINATE_ARRAY", (Connection)this.connection);
        int LENGTH = ords.length;
        Datum[] data = new Datum[LENGTH];
        for (int i = 0; i < LENGTH; ++i) {
            data[i] = GeometryConverter.toNUMBER(ords[i]);
        }
        return new ARRAY(descriptor, (Connection)this.connection, (Object)data);
    }

    public final ARRAY toATTRIBUTE(double[] ords, String desc) throws SQLException {
        ArrayDescriptor descriptor = ArrayDescriptor.createDescriptor((String)desc, (Connection)this.connection);
        int LENGTH = ords.length;
        Datum[] data = new Datum[LENGTH];
        for (int i = 0; i < LENGTH; ++i) {
            data[i] = GeometryConverter.toNUMBER(ords[i]);
        }
        return new ARRAY(descriptor, (Connection)this.connection, (Object)data);
    }

    public static final NUMBER toNUMBER(double number) throws SQLException {
        if (Double.isNaN(number)) {
            return null;
        }
        return new NUMBER(number);
    }

    public final ARRAY toARRAY(int[] ints, String dataType) throws SQLException {
        ArrayDescriptor descriptor = ArrayDescriptor.createDescriptor((String)dataType, (Connection)this.connection);
        return new ARRAY(descriptor, (Connection)this.connection, (Object)ints);
    }

    public static final NUMBER toNUMBER(int number) {
        return new NUMBER(number);
    }

    public static final CHAR toCHAR(String s) {
        if (s.length() > 1) {
            s = Character.toString(s.charAt(0));
        }
        try {
            return new CHAR(s, CharacterSet.make((int)31));
        }
        catch (SQLException e) {
            LOG.error(String.format("error converting %s to char: %s", s, e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public static int asInteger(Datum datum, int DEFAULT) throws SQLException {
        if (datum == null) {
            return DEFAULT;
        }
        return datum.intValue();
    }

    public static double asDouble(Datum datum, double DEFAULT) throws SQLException {
        if (datum == null) {
            return DEFAULT;
        }
        return datum.doubleValue();
    }

    public static double[] asDoubleArray(STRUCT struct, double DEFAULT) throws SQLException {
        if (struct == null) {
            return null;
        }
        return GeometryConverter.asDoubleArray(struct.getOracleAttributes(), DEFAULT);
    }

    public static double[] asDoubleArray(ARRAY array, double DEFAULT) throws SQLException {
        if (array == null) {
            return null;
        }
        if (DEFAULT == 0.0) {
            return array.getDoubleArray();
        }
        return GeometryConverter.asDoubleArray(array.getOracleArray(), DEFAULT);
    }

    public static double[] asDoubleArray(Datum[] data, double DEFAULT) throws SQLException {
        if (data == null) {
            return null;
        }
        double[] array = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            array[i] = GeometryConverter.asDouble(data[i], DEFAULT);
        }
        return array;
    }

    public static int[] asIntArray(ARRAY array, int DEFAULT) throws SQLException {
        if (array == null) {
            return null;
        }
        if (DEFAULT == 0) {
            return array.getIntArray();
        }
        return GeometryConverter.asIntArray(array.getOracleArray(), DEFAULT);
    }

    public static int[] asIntArray(Datum[] data, int DEFAULT) throws SQLException {
        if (data == null) {
            return null;
        }
        int[] array = new int[data.length];
        for (int i = 0; i < data.length; ++i) {
            array[i] = GeometryConverter.asInteger(data[i], DEFAULT);
        }
        return array;
    }
}

