/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.jdbc.connman;

import de.riwagis.riwadatatable.jdbc.JDBCConnectionInfo;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionManager;
import de.riwagis.util.exception.SystemException;
import java.sql.Connection;
import org.apache.commons.dbutils.DbUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleConnMDJDBCConnectionManager
implements JDBCConnectionManager {
    private static final Logger LOG = LoggerFactory.getLogger(SingleConnMDJDBCConnectionManager.class);
    private volatile Connection conn;
    private final JDBCConnectionInfo connInfo;

    public SingleConnMDJDBCConnectionManager(JDBCConnectionInfo connInfo) {
        this.connInfo = connInfo;
    }

    @Override
    public JDBCConnectionInfo getConnectionInfo() {
        return this.connInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection createConnection() throws SystemException {
        SingleConnMDJDBCConnectionManager singleConnMDJDBCConnectionManager = this;
        synchronized (singleConnMDJDBCConnectionManager) {
            if (this.conn == null) {
                this.conn = this.connInfo.createConnection();
            }
        }
        return this.conn;
    }

    @Override
    public void closeConnection(Connection conn) throws SystemException {
        if (this.conn != conn) {
            LOG.warn("wrong connection returned");
        }
    }

    @Override
    public void close() {
        DbUtils.closeQuietly((Connection)this.conn);
    }
}

