/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.jdbc;

import de.riwagis.riwadatatable.jdbc.JDBCConnectionInfo;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionManager;
import de.riwagis.util.exception.SystemException;
import java.sql.Connection;
import org.apache.commons.dbutils.DbUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleConnJDBCConnectionManager
implements JDBCConnectionManager {
    private static final Logger LOG = LoggerFactory.getLogger(SingleConnJDBCConnectionManager.class);
    private volatile Connection conn;
    private final JDBCConnectionInfo connInfo;
    private final boolean isConnectionOwner;

    @Deprecated
    public SingleConnJDBCConnectionManager(JDBCConnectionInfo connInfo) {
        this(null, connInfo);
    }

    public SingleConnJDBCConnectionManager(Connection conn, JDBCConnectionInfo connInfo) {
        this.conn = conn;
        this.connInfo = connInfo;
        this.isConnectionOwner = conn == null;
    }

    @Override
    public JDBCConnectionInfo getConnectionInfo() {
        return this.connInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection createConnection() throws SystemException {
        SingleConnJDBCConnectionManager singleConnJDBCConnectionManager = this;
        synchronized (singleConnJDBCConnectionManager) {
            if (this.conn == null) {
                this.conn = this.connInfo.createConnection();
            }
        }
        return this.conn;
    }

    @Override
    public void closeConnection(Connection conn) throws SystemException {
        if (this.conn != conn) {
            LOG.warn("wrong connection returned");
        }
    }

    @Override
    public void close() {
        if (this.isConnectionOwner) {
            DbUtils.closeQuietly((Connection)this.conn);
        }
    }
}

