/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;

public interface SchemaChangeStrategy {
    public static final SchemaChangeStrategy SCHEMACHANGESTRATEGY_NONE = new SchemaChangeStrategy(){

        @Override
        public void changeSchema(Connection conn, String schemaName) throws SQLException {
        }
    };
    public static final SchemaChangeStrategy SCHEMACHANGESTRATEGY_ORACLE = new SchemaChangeStrategy(){

        @Override
        public void changeSchema(Connection conn, String schemaName) throws SQLException {
            String connUserName = conn.getMetaData().getUserName();
            if (!StringUtils.equalsIgnoreCase((String)connUserName, (String)schemaName)) {
                LoggerFactory.getLogger(SchemaChangeStrategy.class).warn(String.format("Different user and tableschema name ('%s' != '%s' ) are not supported when using an oracle database", connUserName, schemaName));
            }
        }
    };
    public static final SchemaChangeStrategy SCHEMACHANGESTRATEGY_POSTGRESQL = new SchemaChangeStrategy(){

        @Override
        public void changeSchema(Connection conn, String schemaName) throws SQLException {
            try (PreparedStatement stmt = conn.prepareStatement(String.format("SET search_path TO %s,\"$user\",public", schemaName));){
                stmt.executeUpdate();
            }
        }
    };
    public static final SchemaChangeStrategy SCHEMACHANGESTRATEGY_MYSQL = new SchemaChangeStrategy(){

        @Override
        public void changeSchema(Connection conn, String schemaName) throws SQLException {
            conn.setCatalog(schemaName);
        }
    };
    public static final SchemaChangeStrategy SCHEMACHANGESTRATEGY_MSSQLSERVER = new SchemaChangeStrategy(){

        @Override
        public void changeSchema(Connection conn, String schemaName) throws SQLException {
            conn.setCatalog(schemaName);
        }
    };

    public void changeSchema(Connection var1, String var2) throws SQLException;
}

