/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.jdbc;

import de.riwagis.crs.CRSDefFactory;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.riwadatatable.jdbc.AbstractConnectionInfo;
import de.riwagis.riwadatatable.jdbc.DBType;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class PropertyFileConnectionInfo
extends AbstractConnectionInfo {
    private final Properties props;

    public PropertyFileConnectionInfo(Properties props) throws IOException {
        this.props = props;
    }

    @Override
    public String getUrl() {
        return this.props.getProperty("dbUrl");
    }

    @Override
    public String getDriver() {
        return this.props.getProperty("dbDriver");
    }

    @Override
    public String getUsername() {
        return this.props.getProperty("dbUser");
    }

    @Override
    public String getPassword() {
        return this.props.getProperty("dbPassword");
    }

    @Override
    public String getScheme() {
        if (StringUtils.isNotBlank((String)this.props.getProperty("dbSchema")) && !StringUtils.endsWithIgnoreCase((String)"null", (String)this.props.getProperty("dbSchema"))) {
            return this.props.getProperty("dbSchema");
        }
        if (StringUtils.isNotBlank((String)this.props.getProperty("dbCatalog")) && !StringUtils.endsWithIgnoreCase((String)"null", (String)this.props.getProperty("dbCatalog"))) {
            return this.props.getProperty("dbCatalog");
        }
        if (StringUtils.equalsIgnoreCase((String)this.props.getProperty("dbDriver"), (String)"oracle.jdbc.driver.OracleDriver")) {
            return this.props.getProperty("dbUser");
        }
        return "";
    }

    @Override
    public String getCatalog() {
        return this.props.getProperty("dbCatalog");
    }

    @Override
    public DBType getDBType() {
        return DBType.findByDriverClassName(this.props.getProperty("dbDriver"));
    }

    @Override
    public boolean isReadonly() {
        return false;
    }

    public CRSDefinition getCRS() {
        if (StringUtils.isBlank((String)this.props.getProperty("dbSRID"))) {
            return null;
        }
        return CRSDefFactory.getCRSDefinition((String)this.props.getProperty("dbSRID"));
    }

    public int getSRID() {
        if (StringUtils.isBlank((String)this.props.getProperty("dbSRID"))) {
            return -1;
        }
        return Integer.parseInt(this.props.getProperty("dbSRID"));
    }

    @Override
    public String getConnAdjustSchemeOrCatalog() {
        if (this.isMSSQLServer()) {
            return this.props.getProperty("dbCatalog");
        }
        return this.getScheme();
    }
}

