/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.jdbc;

import de.riwagis.riwadatatable.jdbc.JDBCConnectionInfo;
import de.riwagis.riwadatatable.jdbc.work.ConnectionWork;
import de.riwagis.riwadatatable.jdbc.work.ReturnConnectionWork;
import de.riwagis.util.exception.SystemException;
import java.sql.Connection;
import java.sql.SQLException;

public interface JDBCConnectionManager
extends AutoCloseable {
    public JDBCConnectionInfo getConnectionInfo();

    public Connection createConnection() throws SystemException;

    public void closeConnection(Connection var1) throws SystemException;

    @Deprecated
    default public void destroy() {
        this.close();
    }

    @Override
    public void close();

    default public void executeWork(ConnectionWork f) throws SystemException {
        Connection conn = this.createConnection();
        try {
            f.execute(conn);
        }
        catch (SQLException ex) {
            throw new SystemException(String.format("error executing work on '%s': %s", this.getConnectionInfo(), ex.getMessage()), (Throwable)ex);
        }
        finally {
            this.closeConnection(conn);
        }
    }

    default public <V> V executeWork(ReturnConnectionWork<V> f) throws SystemException {
        Connection conn = this.createConnection();
        try {
            V v = f.execute(conn);
            return v;
        }
        catch (SQLException ex) {
            throw new SystemException(String.format("error executing work on '%s': %s", this.getConnectionInfo(), ex.getMessage()), (Throwable)ex);
        }
        finally {
            this.closeConnection(conn);
        }
    }
}

