/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.jdbc;

import de.riwagis.crs.CRSDefinitionProvider;
import de.riwagis.riwadatatable.jdbc.DBType;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.jdbc.pool.DBDriver;
import java.sql.Connection;
import java.util.Collection;
import java.util.Properties;

public interface JDBCConnectionInfo
extends CRSDefinitionProvider {
    public String getUrl();

    public String getDriver();

    public String getUsername();

    public String getPassword();

    public String getScheme();

    public String getCatalog();

    public DBType getDBType();

    public boolean isOracle();

    public boolean isMySQL();

    public boolean isMariaDB();

    public boolean isPostgres();

    public boolean isMSSQLServer();

    default public boolean isLoggingEnabled() {
        return false;
    }

    default public boolean isModificationLogEnabled() {
        return false;
    }

    public Connection createConnection() throws SystemException;

    public boolean isReadonly();

    default public String getConnAdjustSchemeOrCatalog() {
        return this.getScheme();
    }

    default public Properties createConnectionProperties() {
        DBDriver driver;
        Properties props = new Properties();
        if (this.getUsername() != null) {
            props.put("user", this.getUsername());
        }
        if (this.getPassword() != null) {
            props.put("password", this.getPassword());
        }
        if ((driver = DBDriver.findByClassName((String)this.getDriver())) != DBDriver.Unknown) {
            Collection driverParameters = driver.getDriverParameters();
            driverParameters.forEach(param -> props.put(param.getName(), param.getValue()));
        }
        return props;
    }
}

