/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.jdbc;

import de.riwagis.riwadatatable.jdbc.JDBCConnectionInfo;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionManager;
import de.riwagis.util.exception.SystemException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJDBCConnectionManager
implements JDBCConnectionManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJDBCConnectionManager.class);
    private final Collection<Integer> remainingConnections = new ArrayList<Integer>();
    private final JDBCConnectionInfo connInfo;

    public DefaultJDBCConnectionManager(JDBCConnectionInfo connInfo) {
        this.connInfo = connInfo;
    }

    @Override
    public JDBCConnectionInfo getConnectionInfo() {
        return this.connInfo;
    }

    @Override
    public Connection createConnection() throws SystemException {
        Connection conn = this.connInfo.createConnection();
        this.remainingConnections.add(conn.hashCode());
        return conn;
    }

    @Override
    public void closeConnection(Connection conn) throws SystemException {
        try {
            this.remainingConnections.remove(conn.hashCode());
            if (!conn.isClosed()) {
                conn.close();
            }
        }
        catch (SQLException ex) {
            throw new SystemException((Throwable)ex);
        }
    }

    @Override
    public void close() {
        if (!this.remainingConnections.isEmpty()) {
            LOG.warn(String.format("unclosed connections for '%s': %s", this.getConnectionInfo(), this.remainingConnections.size()));
        }
    }
}

