/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.jdbc;

import de.riwagis.crs.CRSDefFactory;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.riwadatatable.jdbc.AbstractConnectionInfo;
import de.riwagis.riwadatatable.jdbc.DBType;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionInfo;

public class DefaultConnectionInfo
extends AbstractConnectionInfo {
    private final String url;
    private final String driver;
    private final String username;
    private final String password;
    private final String scheme;
    private final DBType dbtype;
    private final int srid;
    private final String catalog;

    public DefaultConnectionInfo(JDBCConnectionInfo draftConnectionInfo) {
        this(draftConnectionInfo.getDriver(), draftConnectionInfo.getUrl(), draftConnectionInfo.getUsername(), draftConnectionInfo.getPassword(), draftConnectionInfo.getScheme(), draftConnectionInfo.getSRID(), draftConnectionInfo.getCatalog());
    }

    public DefaultConnectionInfo(String driver, String url, String username, String password, String scheme) {
        this(driver, url, username, password, scheme, -1);
    }

    public DefaultConnectionInfo(String driver, String url, String username, String password, String scheme, int srid) {
        this(driver, url, username, password, scheme, srid, null);
    }

    public DefaultConnectionInfo(String driver, String url, String username, String password, String scheme, int srid, String catalog) {
        this.url = url;
        this.driver = driver;
        this.username = username;
        this.password = password;
        this.scheme = scheme;
        this.dbtype = DBType.determineByURL(url);
        this.srid = srid;
        this.catalog = catalog;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getDriver() {
        return this.driver;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public DBType getDBType() {
        return this.dbtype;
    }

    @Override
    public boolean isReadonly() {
        return false;
    }

    public CRSDefinition getCRS() {
        return CRSDefFactory.getCRSDefinition((String)("" + this.srid));
    }

    public int getSRID() {
        return this.srid;
    }

    @Override
    public String getConnAdjustSchemeOrCatalog() {
        if (this.isMSSQLServer()) {
            return this.catalog;
        }
        return this.scheme;
    }
}

