/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.jdbc;

import de.riwagis.riwadatatable.jdbc.JDBCConnectionInfo;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionManager;
import de.riwagis.util.exception.SystemException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbutils.DbUtils;

public class DataSourceConnectionManager
implements JDBCConnectionManager {
    private DataSource dataSource;
    private JDBCConnectionInfo connInfo;

    public DataSourceConnectionManager(DataSource dataSource, JDBCConnectionInfo connInfo) {
        this.dataSource = dataSource;
        this.connInfo = connInfo;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public JDBCConnectionInfo getConnectionInfo() {
        return this.connInfo;
    }

    @Override
    public Connection createConnection() throws SystemException {
        try {
            Connection conn = this.dataSource.getConnection();
            this.connInfo.getDBType().changeSchema(conn, this.connInfo.getConnAdjustSchemeOrCatalog());
            return conn;
        }
        catch (SQLException ex) {
            throw new SystemException((Throwable)ex);
        }
    }

    @Override
    public void closeConnection(Connection conn) throws SystemException {
        DbUtils.closeQuietly((Connection)conn);
    }

    @Override
    public void close() {
        this.dataSource = null;
        this.connInfo = null;
    }
}

