/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.jdbc;

import de.riwagis.riwadatatable.jdbc.SchemaChangeStrategy;
import de.riwagis.util.jdbc.DBProduct;
import de.riwagis.util.jdbc.pool.DBDriver;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public enum DBType {
    Unknown("unknown", null, DBDriver.Unknown, null, SchemaChangeStrategy.SCHEMACHANGESTRATEGY_NONE, new DBProduct[0]),
    Oracle("DB_Oracle", "jdbc:oracle:thin:", DBDriver.Oracle, ".*\\$|BIN\\$.*|XDB\\$.*|DR\\$.*|DEF\\$.*|SDO\\_.*|WM\\$.*|WK\\$.*|AW\\$.*|AQ\\$.*|APPLY\\$.*|REPCAT\\$.*|CWM\\$.*|CWM2\\$.*|EXF\\$.*|DM\\$.*", SchemaChangeStrategy.SCHEMACHANGESTRATEGY_ORACLE, new DBProduct[]{DBProduct.DBP_ORACLE}),
    MySQL("DB_MySql", "jdbc:mysql:", DBDriver.MySQL, null, SchemaChangeStrategy.SCHEMACHANGESTRATEGY_MYSQL, new DBProduct[]{DBProduct.DBP_MYSQL}),
    MariaDB("DB_MariaDB", "jdbc:mariadb:", DBDriver.MariaDB, null, SchemaChangeStrategy.SCHEMACHANGESTRATEGY_MYSQL, new DBProduct[]{DBProduct.DBP_MARIADB}),
    Postgres("DB_Postgres", "jdbc:postgresql:", DBDriver.Postgres, null, SchemaChangeStrategy.SCHEMACHANGESTRATEGY_POSTGRESQL, new DBProduct[]{DBProduct.DBP_POSTGRES}),
    MSSQLServer("DB_MSSQLServer", "jdbc:sqlserver:", DBDriver.MSSQLServer, null, SchemaChangeStrategy.SCHEMACHANGESTRATEGY_MSSQLSERVER, new DBProduct[]{DBProduct.DBP_MSSQLSERVER}),
    Shapefile("SHAPE Directory", null, DBDriver.Unknown, null, SchemaChangeStrategy.SCHEMACHANGESTRATEGY_NONE, new DBProduct[0]);

    private final String typeIdentifier;
    private final String urlPrefix;
    private final DBDriver dBDriver;
    private final String systemTablePattern;
    private final SchemaChangeStrategy schemaChangeStrategy;
    private final DBProduct[] supportedProducts;

    private DBType(String typeIdentifier, String urlPrefix, DBDriver dBDriver, String systemTablePattern, SchemaChangeStrategy schemaChangeStrategy, DBProduct[] supportedProducts) {
        if (typeIdentifier == null) {
            throw new NullPointerException("typeIdentifier must not be null");
        }
        this.urlPrefix = urlPrefix;
        this.typeIdentifier = Objects.requireNonNull(typeIdentifier);
        this.dBDriver = Objects.requireNonNull(dBDriver);
        this.systemTablePattern = systemTablePattern;
        this.schemaChangeStrategy = Objects.requireNonNull(schemaChangeStrategy);
        this.supportedProducts = Objects.requireNonNull(supportedProducts);
    }

    public String getTypeIdentifier() {
        return this.typeIdentifier;
    }

    public String getDriverClassName() {
        return this.dBDriver.getDriverClassName();
    }

    public String getUrlPrefix() {
        return this.urlPrefix;
    }

    public DBDriver getDBDriver() {
        return this.dBDriver;
    }

    public boolean hasTypeIdentifier(String typeIdentifier) {
        return StringUtils.equalsIgnoreCase((String)typeIdentifier, (String)this.getTypeIdentifier());
    }

    public void changeSchema(Connection conn, String schemaName) throws SQLException {
        if (this.schemaChangeStrategy != null) {
            this.schemaChangeStrategy.changeSchema(conn, schemaName);
        }
    }

    public boolean matchesURLPrefix(String url) {
        return StringUtils.isNotBlank((String)this.urlPrefix) && StringUtils.startsWith((String)url, (String)this.urlPrefix);
    }

    public static DBType findByIdentifier(String typeIdentifier) {
        if (StringUtils.isNotBlank((String)typeIdentifier)) {
            for (DBType currType : DBType.values()) {
                if (!currType.hasTypeIdentifier(typeIdentifier)) continue;
                return currType;
            }
        }
        return Unknown;
    }

    public static DBType findByDriverClassName(String driverClassName) {
        if (StringUtils.isNotBlank((String)driverClassName)) {
            for (DBType currType : DBType.values()) {
                if (!StringUtils.equalsIgnoreCase((String)driverClassName, (String)currType.getDriverClassName())) continue;
                return currType;
            }
        }
        return Unknown;
    }

    public static DBType determineByURL(String url) {
        if (StringUtils.isNotBlank((String)url)) {
            for (DBType currDBType : DBType.values()) {
                if (!currDBType.matchesURLPrefix(url)) continue;
                return currDBType;
            }
        }
        return Unknown;
    }

    public static DBType determineByDBProduct(DBProduct dbProduct) {
        for (DBType currType : DBType.values()) {
            for (DBProduct supportedProduct : currType.supportedProducts) {
                if (!Objects.equals(supportedProduct, dbProduct)) continue;
                return currType;
            }
        }
        return Unknown;
    }

    public String getSystemTablePattern() {
        return this.systemTablePattern;
    }
}

