/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.jdbc;

import de.riwagis.riwadatatable.jdbc.DBType;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionInfo;
import de.riwagis.util.exception.SystemException;
import java.sql.Connection;
import java.sql.DriverManager;
import org.apache.commons.dbutils.DbUtils;

public abstract class AbstractConnectionInfo
implements JDBCConnectionInfo {
    public static final Connection createDefaultConnection(JDBCConnectionInfo connectionInfo) throws SystemException {
        try {
            DbUtils.loadDriver((String)connectionInfo.getDriver());
            return DriverManager.getConnection(connectionInfo.getUrl(), connectionInfo.createConnectionProperties());
        }
        catch (Exception ex) {
            throw new SystemException(String.format("Error loading jdbc driver: %s", connectionInfo.getDriver()), (Throwable)ex);
        }
    }

    @Override
    public Connection createConnection() throws SystemException {
        return AbstractConnectionInfo.createDefaultConnection(this);
    }

    @Override
    public boolean isOracle() {
        return DBType.Oracle.equals((Object)this.getDBType());
    }

    @Override
    public boolean isMySQL() {
        return DBType.MySQL.equals((Object)this.getDBType());
    }

    @Override
    public boolean isMariaDB() {
        return DBType.MariaDB.equals((Object)this.getDBType());
    }

    @Override
    public boolean isPostgres() {
        return DBType.Postgres.equals((Object)this.getDBType());
    }

    @Override
    public boolean isMSSQLServer() {
        return DBType.MSSQLServer.equals((Object)this.getDBType());
    }
}

