/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.filter.geotools;

import de.riwagis.riwadatatable.filter.geotools.DataTableGeotoolsFilterVisitor;
import java.util.ArrayList;
import java.util.List;
import org.geotools.filter.FilterAbstract;
import org.geotools.util.Converters;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;

public class InFilter
extends FilterAbstract {
    private boolean matchCase = false;
    private final FilterFactory factory;
    private final Expression leftExpression;
    private final List<Literal> inLiterals = new ArrayList<Literal>();

    public InFilter(FilterFactory factory, Expression leftExpression, List<Literal> inLiterals, boolean matchCase) {
        this.factory = factory;
        this.matchCase = matchCase;
        this.leftExpression = leftExpression;
        this.inLiterals.addAll(inLiterals);
    }

    public boolean evaluate(Object feature) {
        Object objFeature = this.eval(this.leftExpression, feature);
        for (Literal l : this.inLiterals) {
            Object objLiteral = l.getValue();
            if (!this.compare(objFeature, objLiteral)) continue;
            return true;
        }
        return false;
    }

    private boolean compare(Object objFeature, Object objLiteral) {
        if (objFeature == objLiteral) {
            return true;
        }
        if (objFeature == null || objLiteral == null) {
            return false;
        }
        if (objFeature.equals(objLiteral)) {
            return true;
        }
        Object objLiteralConv = Converters.convert((Object)objLiteral, objFeature.getClass());
        if (objLiteralConv != null && objFeature.equals(objLiteralConv)) {
            return true;
        }
        boolean isNumericFeat = objFeature instanceof Number;
        boolean isNumericLit = objLiteral instanceof Number;
        if (isNumericFeat && isNumericLit || isNumericFeat && objLiteral instanceof CharSequence || isNumericLit && objFeature instanceof CharSequence) {
            long lg2;
            Number n2;
            Number n1;
            try {
                n1 = isNumericFeat ? (Number)((Number)objFeature) : (Number)InFilter.parseToNumber(objFeature.toString());
                n2 = isNumericLit ? (Number)((Number)objLiteral) : (Number)InFilter.parseToNumber(objLiteral.toString());
            }
            catch (NumberFormatException e) {
                return false;
            }
            double fp1 = n1.doubleValue();
            double fp2 = n2.doubleValue();
            long lg1 = n1.longValue();
            if (fp1 == (double)lg1 && fp2 == (double)(lg2 = n2.longValue())) {
                return lg1 == lg2;
            }
            return fp1 == fp2 || Double.isNaN(fp1) && Double.isNaN(fp2);
        }
        if (!this.isMatchingCase()) {
            String s1 = (String)Converters.convert((Object)objFeature, String.class);
            String s2 = (String)Converters.convert((Object)objLiteral, String.class);
            return s1.equalsIgnoreCase(s2);
        }
        return false;
    }

    private static Number parseToNumber(String value) throws NumberFormatException {
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            return Double.valueOf(value);
        }
    }

    public Object accept(FilterVisitor fv, Object o) {
        if (fv instanceof DataTableGeotoolsFilterVisitor) {
            DataTableGeotoolsFilterVisitor dtfv = (DataTableGeotoolsFilterVisitor)fv;
            return dtfv.visit(this, o);
        }
        throw new UnsupportedOperationException("InFilters are only supported in DataTableFilterVisitor.");
    }

    public boolean isMatchingCase() {
        return this.matchCase;
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }

    public List<Literal> getInLiterals() {
        return new ArrayList<Literal>(this.inLiterals);
    }

    public Filter and(Filter filter) {
        return this.factory.and((Filter)this, filter);
    }

    public Filter or(Filter filter) {
        return this.factory.or((Filter)this, filter);
    }

    public Filter not() {
        return this.factory.not((Filter)this);
    }
}

