/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.filter.geotools;

import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.riwadatatable.columns.DateColumn;
import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.columns.provider.ColumnProvider;
import de.riwagis.riwadatatable.filter.BBoxDataTableQueryFilterCriteriaCreator;
import de.riwagis.riwadatatable.filter.DataTableFilterUtil;
import de.riwagis.riwadatatable.filter.DataTableQuery;
import de.riwagis.riwadatatable.filter.geotools.InFilter;
import de.riwagis.riwadatatable.jdbc.DBType;
import de.riwagis.util.exception.SystemException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.geotools.filter.FilterFactoryImpl;
import org.opengis.filter.And;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNil;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.AnyInteracts;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.Meets;
import org.opengis.filter.temporal.MetBy;
import org.opengis.filter.temporal.OverlappedBy;
import org.opengis.filter.temporal.TContains;
import org.opengis.filter.temporal.TEquals;
import org.opengis.filter.temporal.TOverlaps;
import org.opengis.temporal.Period;

public class DataTableGeotoolsFilterVisitor
implements FilterVisitor,
ExpressionVisitor {
    public static final String TABLE_ALIAS = "tbl";
    private final String primaryKeyColumn;
    private final String tableName;
    private final ColumnProvider columnProvider;
    private boolean insideNot = false;

    public DataTableGeotoolsFilterVisitor(String tableName, String primaryKeyColumn) {
        this.primaryKeyColumn = primaryKeyColumn;
        this.tableName = tableName;
        this.columnProvider = null;
    }

    public DataTableGeotoolsFilterVisitor(String tableName, ColumnProvider columnProvider) {
        this.columnProvider = columnProvider;
        this.primaryKeyColumn = columnProvider != null && columnProvider.hasIDColumn() ? columnProvider.getIDColumn().getColumnName() : null;
        this.tableName = tableName;
    }

    private String notOperator() {
        if (!this.insideNot) {
            return "";
        }
        return " not";
    }

    private String notOperatorShort() {
        if (!this.insideNot) {
            return "";
        }
        return "!";
    }

    private String getAndOperator() {
        if (!this.insideNot) {
            return " and";
        }
        return " or";
    }

    private String getOrOperator() {
        if (!this.insideNot) {
            return " or";
        }
        return " and";
    }

    private String getColumnNameWithTablePrefix(String columnName) {
        if (this.tableName == null || this.tableName.length() == 0) {
            return columnName;
        }
        return this.tableName + "." + columnName;
    }

    public Object visitNullFilter(Object o) {
        throw new UnsupportedOperationException("NullFilters are not supported in DataTableFilterVisitor.");
    }

    public Object visit(ExcludeFilter ef, Object o) {
        DataTableQuery query = (DataTableQuery)o;
        query.appendToQuery(" 1" + this.notOperatorShort() + "=0");
        return query;
    }

    public Object visit(IncludeFilter i, Object o) {
        DataTableQuery query = (DataTableQuery)o;
        query.appendToQuery(" 1" + this.notOperatorShort() + "=1");
        return query;
    }

    public Object visit(And and, Object o) {
        DataTableQuery query = (DataTableQuery)o;
        List lstAndFilters = and.getChildren();
        if (lstAndFilters.size() > 0) {
            query.appendToQuery(" (");
            int counter = 0;
            for (Filter filt : lstAndFilters) {
                if (counter > 0) {
                    query.appendToQuery(this.getAndOperator());
                }
                filt.accept((FilterVisitor)this, o);
                ++counter;
            }
            query.appendToQuery(")");
        }
        return query;
    }

    public Object visit(Id id, Object o) {
        if (this.primaryKeyColumn == null) {
            throw new RuntimeException(String.format("Error creating filter for table '%s'. No PrimaryKey column found for creating Id filter.", this.tableName));
        }
        DataTableQuery query = (DataTableQuery)o;
        Set setIDs = id.getIDs();
        int size = setIDs.size();
        if (size > 0) {
            query.appendToQuery(" (" + this.getColumnNameWithTablePrefix(this.primaryKeyColumn) + this.notOperator() + " in (");
            int counter = 0;
            int inCounter = 0;
            for (Object objID : setIDs) {
                if (inCounter > 0) {
                    query.appendToQuery(",");
                }
                String featureId = FeatureUtil.getFeatureIDWithoutTable((String)objID.toString());
                try {
                    if (this.columnProvider != null && this.columnProvider.hasIDColumn()) {
                        Object featureIdParsed = this.columnProvider.getIDColumn().parseObject(featureId);
                        query.appendToQuery("?", featureIdParsed);
                    } else {
                        query.appendToQuery("?", featureId);
                    }
                }
                catch (Exception e) {
                    query.appendToQuery("?", featureId);
                }
                if (++inCounter <= 900 || ++counter >= size) continue;
                query.appendToQuery(")" + this.getOrOperator() + " " + this.getColumnNameWithTablePrefix(this.primaryKeyColumn) + this.notOperator() + " in (");
                inCounter = 0;
            }
        } else {
            query.appendToQuery(" 1" + this.notOperatorShort() + "=0");
            return query;
        }
        query.appendToQuery("))");
        return query;
    }

    public Object visit(Not not, Object o) {
        DataTableQuery query = (DataTableQuery)o;
        this.insideNot = true;
        Filter notFilter = not.getFilter();
        if (notFilter != null) {
            query.appendToQuery(" (");
            notFilter.accept((FilterVisitor)this, o);
            query.appendToQuery(" )");
        }
        this.insideNot = false;
        return query;
    }

    public Object visit(Or or, Object o) {
        DataTableQuery query = (DataTableQuery)o;
        List lstAndFilters = or.getChildren();
        if (lstAndFilters.size() > 0) {
            query.appendToQuery(" (");
            int counter = 0;
            for (Filter filt : lstAndFilters) {
                if (counter > 0) {
                    query.appendToQuery(this.getOrOperator());
                }
                filt.accept((FilterVisitor)this, o);
                ++counter;
            }
            query.appendToQuery(")");
        }
        return query;
    }

    public Object visit(PropertyIsBetween pib, Object o) {
        DataTableQuery query = (DataTableQuery)o;
        pib.getExpression().accept((ExpressionVisitor)this, o);
        query.appendToQuery(this.notOperator() + " between ");
        pib.getLowerBoundary().accept((ExpressionVisitor)this, o);
        query.appendToQuery(" and ");
        pib.getUpperBoundary().accept((ExpressionVisitor)this, o);
        return query;
    }

    public Object visit(PropertyIsEqualTo piet, Object o) {
        Expression left = piet.getExpression1();
        Expression right = piet.getExpression2();
        DataTableQuery query = (DataTableQuery)o;
        return this.visitPropertyIs(left, right, " " + this.notOperatorShort() + "= ", o);
    }

    public Object visit(InFilter inf, Object o) {
        DataTableQuery query = (DataTableQuery)o;
        List<Literal> lstLiterals = inf.getInLiterals();
        int size = lstLiterals.size();
        if (size > 0) {
            query.appendToQuery(" (");
            inf.getLeftExpression().accept((ExpressionVisitor)this, o);
            query.appendToQuery(this.notOperator() + " in (");
            int counter = 0;
            int inCounter = 0;
            for (Literal lit : lstLiterals) {
                if (inCounter > 0) {
                    query.appendToQuery(",");
                }
                this.visit(inf.getLeftExpression(), lit, o);
                if (++inCounter <= 900 || ++counter >= size) continue;
                query.appendToQuery(")" + this.getOrOperator());
                inf.getLeftExpression().accept((ExpressionVisitor)this, o);
                query.appendToQuery(this.notOperator() + " in (");
                inCounter = 0;
            }
            query.appendToQuery("))");
        }
        return query;
    }

    public Object visit(PropertyIsNotEqualTo pinet, Object o) {
        Expression left = pinet.getExpression1();
        Expression right = pinet.getExpression2();
        String linkString = " != ";
        if (this.insideNot) {
            linkString = " = ";
        }
        return this.visitPropertyIs(left, right, linkString, o);
    }

    private Object visitPropertyIs(Expression left, Expression right, String linkString, Object o) {
        DataTableQuery query = (DataTableQuery)o;
        if (left instanceof Literal && right instanceof PropertyName) {
            this.visit(right, (Literal)left, o);
            query.appendToQuery(linkString);
            right.accept((ExpressionVisitor)this, o);
        } else if (right instanceof Literal && left instanceof PropertyName) {
            left.accept((ExpressionVisitor)this, o);
            query.appendToQuery(linkString);
            this.visit(left, (Literal)right, o);
        } else {
            left.accept((ExpressionVisitor)this, o);
            query.appendToQuery(linkString);
            right.accept((ExpressionVisitor)this, o);
        }
        return query;
    }

    public Object visit(PropertyIsGreaterThan pigt, Object o) {
        Expression left = pigt.getExpression1();
        Expression right = pigt.getExpression2();
        String linkString = " > ";
        if (this.insideNot) {
            linkString = " <= ";
        }
        return this.visitPropertyIs(left, right, linkString, o);
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo pgt, Object o) {
        Expression left = pgt.getExpression1();
        Expression right = pgt.getExpression2();
        String linkString = " >= ";
        if (this.insideNot) {
            linkString = " < ";
        }
        return this.visitPropertyIs(left, right, linkString, o);
    }

    public Object visit(PropertyIsLessThan pilt, Object o) {
        Expression left = pilt.getExpression1();
        Expression right = pilt.getExpression2();
        String linkString = " < ";
        if (this.insideNot) {
            linkString = " >= ";
        }
        return this.visitPropertyIs(left, right, linkString, o);
    }

    public Object visit(PropertyIsLessThanOrEqualTo plt, Object o) {
        Expression left = plt.getExpression1();
        Expression right = plt.getExpression2();
        String linkString = " <= ";
        if (this.insideNot) {
            linkString = " > ";
        }
        return this.visitPropertyIs(left, right, linkString, o);
    }

    public Object visit(PropertyIsLike pil, Object o) {
        DataTableQuery query = (DataTableQuery)o;
        String literal = pil.getLiteral();
        String wildCard = pil.getWildCard();
        String oneChar = pil.getSingleChar();
        literal = literal.replace(wildCard, "%");
        literal = literal.replace(oneChar, "_");
        if (pil.isMatchingCase()) {
            pil.getExpression().accept((ExpressionVisitor)this, o);
        } else {
            query.appendToQuery(" lower(");
            pil.getExpression().accept((ExpressionVisitor)this, o);
            query.appendToQuery(")");
            literal = literal.toLowerCase();
        }
        if (query.getConnectionInfo().getDBType() == DBType.Postgres) {
            query.appendToQuery("::text");
        }
        query.appendToQuery(this.notOperator() + " like ?");
        query.addFilterCriterias(literal);
        return query;
    }

    public Object visit(PropertyIsNull pin, Object o) {
        DataTableQuery query = (DataTableQuery)o;
        pin.getExpression().accept((ExpressionVisitor)this, o);
        query.appendToQuery(" is" + this.notOperator() + " null");
        return query;
    }

    public Object visit(BBOX bbox, Object o) {
        try {
            DataTableQuery query = (DataTableQuery)o;
            if (query.getConnectionInfo() == null) {
                throw new IllegalStateException("BBOX filters need JDBCConnectionInfo in the DataTableQuery object.");
            }
            Expression attExpr = bbox.getExpression1();
            switch (query.getConnectionInfo().getDBType()) {
                case MySQL: 
                case MariaDB: {
                    query.appendToQuery(" MBRIntersects(");
                    attExpr.accept((ExpressionVisitor)this, o);
                    int srid = 0;
                    if (query.getConnectionInfo().getSRID() != -1) {
                        srid = query.getConnectionInfo().getSRID();
                    }
                    query.appendToQuery(",ST_GeomFromWKB(?,?))", new BBoxDataTableQueryFilterCriteriaCreator(bbox), srid);
                    return query;
                }
                case Oracle: {
                    query.appendToQuery(" SDO_FILTER(");
                    attExpr.accept((ExpressionVisitor)this, o);
                    query.appendToQuery(",?,'querytype=WINDOW') = 'TRUE'", new BBoxDataTableQueryFilterCriteriaCreator(bbox));
                    return query;
                }
                case Postgres: {
                    attExpr.accept((ExpressionVisitor)this, o);
                    int srid = 0;
                    if (query.getConnectionInfo().getSRID() != -1) {
                        srid = query.getConnectionInfo().getSRID();
                    }
                    query.appendToQuery(" && ST_envelope(ST_GeomFromWKB(?,?))", new BBoxDataTableQueryFilterCriteriaCreator(bbox), srid);
                    return query;
                }
                case MSSQLServer: {
                    attExpr.accept((ExpressionVisitor)this, o);
                    int srid = 0;
                    if (query.getConnectionInfo().getSRID() != -1) {
                        srid = query.getConnectionInfo().getSRID();
                    }
                    query.appendToQuery(".STIntersects(geometry::STGeomFromWKB(?,?)) = 1", new BBoxDataTableQueryFilterCriteriaCreator(bbox), srid);
                    return query;
                }
            }
            throw new UnsupportedOperationException("Spatial queries are not supported in DataTableFilterVisitor.");
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(String.format("Error visiting BBOX-Filter for table %s.", this.tableName), e);
        }
    }

    public Object visit(Beyond beyond, Object o) {
        throw new UnsupportedOperationException("Spatial queries are not supported in DataTableFilterVisitor.");
    }

    public Object visit(Contains cntns, Object o) {
        throw new UnsupportedOperationException("Spatial queries are not supported in DataTableFilterVisitor.");
    }

    public Object visit(Crosses crs, Object o) {
        throw new UnsupportedOperationException("Spatial queries are not supported in DataTableFilterVisitor.");
    }

    public Object visit(Disjoint dsjnt, Object o) {
        throw new UnsupportedOperationException("Spatial queries are not supported in DataTableFilterVisitor.");
    }

    public Object visit(DWithin dw, Object o) {
        throw new UnsupportedOperationException("Spatial queries are not supported in DataTableFilterVisitor.");
    }

    public Object visit(Equals equals, Object o) {
        throw new UnsupportedOperationException("Spatial queries are not supported in DataTableFilterVisitor.");
    }

    public Object visit(Intersects i, Object o) {
        throw new UnsupportedOperationException("Spatial queries are not supported in DataTableFilterVisitor.");
    }

    public Object visit(Overlaps ovrlps, Object o) {
        throw new UnsupportedOperationException("Spatial queries are not supported in DataTableFilterVisitor.");
    }

    public Object visit(Touches tchs, Object o) {
        throw new UnsupportedOperationException("Spatial queries are not supported in DataTableFilterVisitor.");
    }

    public Object visit(Within within, Object o) {
        throw new UnsupportedOperationException("Spatial queries are not supported in DataTableFilterVisitor.");
    }

    public Object visit(NilExpression ne, Object o) {
        throw new UnsupportedOperationException("NilExpressions are not supported in DataTableFilterVisitor.");
    }

    public Object visit(Add add, Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object visit(Divide divide, Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object visit(Function fnctn, Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public final Object visit(Literal ltrl, Object o) {
        DataTableQuery query = (DataTableQuery)o;
        query.appendToQuery("?", ltrl.getValue());
        return query;
    }

    private Object visit(Expression expr, Literal ltrl, Object o) {
        DataTableQuery query = (DataTableQuery)o;
        Object literalValue = ltrl.getValue();
        if (expr instanceof PropertyName && literalValue != null && (literalValue instanceof String || literalValue instanceof Date)) {
            String propertyName = ((PropertyName)expr).getPropertyName();
            if (this.columnProvider != null && this.columnProvider.hasColumn(propertyName)) {
                try {
                    TableColumn col;
                    if (literalValue instanceof String) {
                        literalValue = this.columnProvider.getColumn(propertyName).parseObject((String)literalValue);
                    }
                    if ((col = this.columnProvider.getColumn(propertyName)) instanceof DateColumn && ((DateColumn)col).isDateTime()) {
                        literalValue = DataTableFilterUtil.asSQLTimestamp((Date)literalValue);
                    }
                    query.appendToQuery("?", literalValue);
                    return query;
                }
                catch (SystemException se) {
                    throw new RuntimeException(String.format("Should never reach here. Error parsing literal value %s.", literalValue.toString()), se);
                }
            }
            return this.visit(ltrl, o);
        }
        return this.visit(ltrl, o);
    }

    public Object visit(Multiply mltpl, Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object visit(PropertyName pn, Object o) {
        DataTableQuery query = (DataTableQuery)o;
        query.appendToQuery(" " + this.getColumnNameWithTablePrefix(pn.getPropertyName()) + " ");
        return query;
    }

    public Object visit(Subtract sbtrct, Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object visit(PropertyIsNil pin, Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object visit(After after, Object o) {
        return this.visitPropertyIs(after.getExpression1(), after.getExpression2(), this.insideNot ? " <= " : " > ", o);
    }

    public Object visit(AnyInteracts ai, Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object visit(Before before, Object o) {
        return this.visitPropertyIs(before.getExpression1(), before.getExpression2(), this.insideNot ? " >= " : " < ", o);
    }

    public Object visit(Begins begins, Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object visit(BegunBy bb, Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object visit(During during, Object o) {
        FilterFactoryImpl ff = new FilterFactoryImpl();
        DataTableQuery query = (DataTableQuery)o;
        Period val = (Period)((Literal)during.getExpression2()).getValue();
        Literal begin = ff.literal((Object)val.getBeginning().getPosition().getDate());
        Literal end = ff.literal((Object)val.getEnding().getPosition().getDate());
        query.appendToQuery(" (");
        this.visitPropertyIs(during.getExpression1(), (Expression)begin, this.insideNot ? " < " : " >= ", o);
        query.appendToQuery(this.getAndOperator());
        this.visitPropertyIs(during.getExpression1(), (Expression)end, this.insideNot ? " > " : " <= ", o);
        query.appendToQuery(" )");
        return o;
    }

    public Object visit(EndedBy eb, Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object visit(Ends ends, Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object visit(Meets meets, Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object visit(MetBy metby, Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object visit(OverlappedBy ob, Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object visit(TContains tc, Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object visit(TEquals te, Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object visit(TOverlaps to, Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

