/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.filter.dbparser;

import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.filter.DataTableQuery;
import de.riwagis.riwadatatable.filter.dbparser.AbstractFilterTermHandler;
import de.riwagis.util.exception.SystemException;

public class TextNullFilterTermHandler
extends AbstractFilterTermHandler {
    public TextNullFilterTermHandler(TableColumn filterColumn, String tableName) {
        super(filterColumn, tableName);
    }

    @Override
    public boolean handleFilterTerm(String term, DataTableQuery query) throws SystemException {
        if (term.equalsIgnoreCase("|null|") || term.equalsIgnoreCase("|ohne Inhalt|")) {
            query.appendToQuery("(");
            this.addColumnName(query);
            query.appendToQuery(" is null or ");
            this.addColumnName(query);
            query.appendToQuery(" = ''");
            query.appendToQuery(")");
            return true;
        }
        if (term.equalsIgnoreCase("|notnull|") || term.equalsIgnoreCase("|not null|") || term.equalsIgnoreCase("|mit Inhalt|")) {
            query.appendToQuery("(");
            this.addColumnName(query);
            query.appendToQuery(" is not null or ");
            if (this.filterColumn.getConnectionInfo().isOracle()) {
                query.appendToQuery(" length(");
                this.addColumnName(query);
                query.appendToQuery(") > 0) ");
            } else {
                this.addColumnName(query);
                query.appendToQuery(" != ''");
                query.appendToQuery(")");
            }
            return true;
        }
        return false;
    }
}

