/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.filter.dbparser;

import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.filter.DataTableQuery;
import de.riwagis.riwadatatable.filter.dbparser.EqualsFilterTermHandler;
import de.riwagis.util.exception.SystemException;

public class TextIsLikeFilterTermHandler
extends EqualsFilterTermHandler {
    private static final char CHAR_STAR = '*';
    private static final char CHAR_PERCENT = '%';

    public TextIsLikeFilterTermHandler(TableColumn filterColumn, String tableName) {
        super(filterColumn, tableName);
    }

    @Override
    protected void addColumnName(DataTableQuery query) {
        if (query.getTableAliasHint().isEmpty()) {
            if (!query.isUseCaseSensitiveTextSearchHint()) {
                query.appendToQuery("lower(");
            }
            query.appendToQuery(this.filterColumn.getColumnName());
            if (!query.isUseCaseSensitiveTextSearchHint()) {
                query.appendToQuery(")");
            }
        } else {
            if (!query.isUseCaseSensitiveTextSearchHint()) {
                query.appendToQuery("lower(");
            }
            query.appendToQuery(query.getTableAliasHint() + "." + this.filterColumn.getColumnName());
            if (!query.isUseCaseSensitiveTextSearchHint()) {
                query.appendToQuery(")");
            }
        }
    }

    @Override
    protected Object parseTerm(String term) throws SystemException {
        term = term.replace('*', '%');
        return super.parseTerm(term);
    }

    @Override
    public boolean handleFilterTerm(String term, DataTableQuery query) throws SystemException {
        if (!query.isUseCaseSensitiveTextSearchHint()) {
            term = term.toLowerCase();
        }
        Object objFilter = this.parseTerm(term);
        this.addColumnName(query);
        query.appendToQuery(" like ?", objFilter);
        return true;
    }
}

