/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.filter.dbparser;

import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.filter.DataTableQuery;
import de.riwagis.riwadatatable.filter.dbparser.InFilterTermHandler;
import de.riwagis.util.exception.SystemException;

public class TextInFilterTermHandler
extends InFilterTermHandler {
    public TextInFilterTermHandler(TableColumn filterColumn, String tableName) {
        super(filterColumn, tableName);
    }

    @Override
    protected void addColumnName(DataTableQuery query) {
        if (query.getTableAliasHint().isEmpty()) {
            if (!query.isUseCaseSensitiveTextSearchHint()) {
                query.appendToQuery("lower(");
            }
            query.appendToQuery(this.filterColumn.getColumnName());
            if (!query.isUseCaseSensitiveTextSearchHint()) {
                query.appendToQuery(")");
            }
        } else {
            if (!query.isUseCaseSensitiveTextSearchHint()) {
                query.appendToQuery("lower(");
            }
            query.appendToQuery(query.getTableAliasHint() + "." + this.filterColumn.getColumnName());
            if (!query.isUseCaseSensitiveTextSearchHint()) {
                query.appendToQuery(")");
            }
        }
    }

    @Override
    protected Object parseTerm(String term, DataTableQuery query) throws SystemException {
        if (!query.isUseCaseSensitiveTextSearchHint()) {
            term = term.toLowerCase();
        }
        return super.parseTerm(term, query);
    }
}

