/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.filter.dbparser;

import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.filter.DataTableQuery;
import de.riwagis.riwadatatable.filter.dbparser.AbstractFilterTermHandler;
import de.riwagis.util.exception.SystemException;
import java.io.IOException;

public class SubselectFilterTermHandler
extends AbstractFilterTermHandler {
    public SubselectFilterTermHandler(TableColumn filterColumn, String tableName) {
        super(filterColumn, tableName);
    }

    @Override
    public boolean handleFilterTerm(String term, DataTableQuery query) throws SystemException {
        try {
            if (term.startsWith("|") && term.endsWith("|")) {
                term = term.substring(1, term.length() - 1);
                String[] arrTerm = term.split("\\|");
                int count = 0;
                query.appendToQuery("(");
                for (int i = 0; i < arrTerm.length; ++i) {
                    DataTableQuery subQuery;
                    if (arrTerm[i] == null || arrTerm[i].isEmpty()) continue;
                    if (arrTerm[i].trim().toLowerCase().startsWith("select ")) {
                        subQuery = new DataTableQuery();
                        subQuery.appendToQuery(arrTerm[i]);
                    } else {
                        subQuery = DataTableQuery.deserializeQueryFromString(arrTerm[i]);
                    }
                    if (count == 0) {
                        this.addColumnName(query);
                        query.appendToQuery(" in (" + subQuery.getSQLWhere() + ")", subQuery.getWhereCriterias());
                    } else {
                        query.appendToQuery(" and ");
                        this.addColumnName(query);
                        query.appendToQuery(" in (" + subQuery.getSQLWhere() + ")", subQuery.getWhereCriterias());
                    }
                    ++count;
                }
                query.appendToQuery(")");
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new SystemException("Error at SubselectFilterTermHandler.", (Throwable)e);
        }
    }
}

