/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.filter.dbparser;

import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.filter.DataTableQuery;
import de.riwagis.riwadatatable.filter.dbparser.AbstractFilterTermHandler;
import de.riwagis.util.exception.SystemException;

public class NumberRegionFilterTermHandler
extends AbstractFilterTermHandler {
    public NumberRegionFilterTermHandler(TableColumn filterColumn, String tableName) {
        super(filterColumn, tableName);
    }

    protected Object parseTerm(String term) throws SystemException {
        return this.filterColumn.parseObject(term);
    }

    @Override
    public boolean handleFilterTerm(String term, DataTableQuery query) throws SystemException {
        String firstPart;
        if (term.length() >= 2 && ((firstPart = term.substring(0, 2)).equals("<=") || firstPart.equals("=<") || firstPart.equals(">=") || firstPart.equals("=>"))) {
            if ((term = term.substring(2)).trim().isEmpty()) {
                term = "0";
            }
            Object objFilter = this.parseTerm(term);
            this.addColumnName(query);
            if (firstPart.equals("=<")) {
                firstPart = "<=";
            }
            if (firstPart.equals("=>")) {
                firstPart = ">=";
            }
            query.appendToQuery(" " + firstPart + " ?", objFilter);
            return true;
        }
        if (term.length() >= 1 && ((firstPart = term.substring(0, 1)).equals("<") || firstPart.equals(">"))) {
            if ((term = term.substring(1)).trim().isEmpty()) {
                term = "0";
            }
            Object objFilter = this.parseTerm(term);
            this.addColumnName(query);
            query.appendToQuery(" " + firstPart + " ?", objFilter);
            return true;
        }
        if (!term.startsWith("~") && term.indexOf(45) > 0) {
            String[] arrTerm = term.split("-");
            if (arrTerm.length != 2) {
                throw new SystemException(String.format("Tabellenspalte: '%s'. Mehrmalige Angabe des Verkn\u00fcpfungsoperators ('-' in '%s') - nicht erlaubt", this.filterColumn.getColumnName(), term));
            }
            Object[] arrFilterObject = new Object[2];
            for (int i = 0; i < arrTerm.length; ++i) {
                arrFilterObject[i] = this.parseTerm(arrTerm[i]);
            }
            this.addColumnName(query);
            query.appendToQuery(" between ? and ?", arrFilterObject);
            return true;
        }
        return false;
    }
}

