/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.filter.dbparser;

import de.riwagis.riwadatatable.columns.NumberColType;
import de.riwagis.riwadatatable.columns.NumberColumn;
import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.filter.DataTableQuery;
import de.riwagis.riwadatatable.filter.dbparser.AbstractFilterTermHandler;
import de.riwagis.util.exception.SystemException;
import org.apache.commons.lang.StringUtils;

public class NumberEqualsFilterTermHandler
extends AbstractFilterTermHandler {
    public NumberEqualsFilterTermHandler(TableColumn filterColumn, String tableName) {
        super(filterColumn, tableName);
    }

    protected Object parseTerm(String term) throws SystemException {
        return this.filterColumn.parseObject(term);
    }

    @Override
    public boolean handleFilterTerm(String term, DataTableQuery query) throws SystemException {
        String afterCommaPart;
        int fractionLength;
        double d;
        if (StringUtils.startsWith((String)term, (String)"~")) {
            term = StringUtils.defaultIfBlank((String)term.substring(1), (String)"0");
        }
        if (term.contains("*")) {
            term = term.replace("*", "%");
            this.addColumnName(query);
            if (this.filterColumn.getConnectionInfo().isPostgres()) {
                query.appendToQuery("::text");
            }
            query.appendToQuery(" like ?", term);
            return true;
        }
        Object objFilter = this.parseTerm(term);
        if (NumberColType.DECIMAL_COLUMNS.contains((Object)((NumberColumn)this.filterColumn).getNumberType()) && objFilter != null && (d = ((Number)objFilter).doubleValue()) != 0.0 && (fractionLength = StringUtils.length((String)(afterCommaPart = term.lastIndexOf(",") > term.lastIndexOf(".") ? StringUtils.substringAfterLast((String)term, (String)",") : StringUtils.substringAfterLast((String)term, (String)".")))) <= 7) {
            double delta = 0.5 * Math.pow(0.1, fractionLength);
            this.addColumnName(query);
            query.appendToQuery(" between ? and ?", d - delta, d + delta);
            return true;
        }
        this.addColumnName(query);
        query.appendToQuery(" = ?", objFilter);
        return true;
    }
}

