/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.filter.dbparser;

import de.riwagis.riwadatatable.columns.ColumnTypes;
import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.filter.dbparser.DateEqualsFilterTermHandler;
import de.riwagis.riwadatatable.filter.dbparser.DateInFilterTermHandler;
import de.riwagis.riwadatatable.filter.dbparser.DateRegionFilterTermHandler;
import de.riwagis.riwadatatable.filter.dbparser.EmptyFilterTermHandler;
import de.riwagis.riwadatatable.filter.dbparser.FilterTermHandler;
import de.riwagis.riwadatatable.filter.dbparser.InFilterTermHandler;
import de.riwagis.riwadatatable.filter.dbparser.NullFilterTermHandler;
import de.riwagis.riwadatatable.filter.dbparser.NumberEqualsFilterTermHandler;
import de.riwagis.riwadatatable.filter.dbparser.NumberRegionFilterTermHandler;
import de.riwagis.riwadatatable.filter.dbparser.SubselectFilterTermHandler;
import de.riwagis.riwadatatable.filter.dbparser.TextInFilterTermHandler;
import de.riwagis.riwadatatable.filter.dbparser.TextIsLikeFilterTermHandler;
import de.riwagis.riwadatatable.filter.dbparser.TextNullFilterTermHandler;
import java.util.ArrayList;
import java.util.List;

public class FilterTermFactory {
    public static final List<FilterTermHandler> createFilterTermHandlers4Column(TableColumn filterColumn) {
        ArrayList<FilterTermHandler> lstHandler = new ArrayList<FilterTermHandler>();
        ColumnTypes colType = filterColumn.getType();
        switch (colType) {
            case CT_NUMBER_COLUMN: {
                lstHandler.add(new NullFilterTermHandler(filterColumn, filterColumn.getTableName()));
                lstHandler.add(new SubselectFilterTermHandler(filterColumn, filterColumn.getTableName()));
                lstHandler.add(new NumberRegionFilterTermHandler(filterColumn, filterColumn.getTableName()));
                lstHandler.add(new InFilterTermHandler(filterColumn, filterColumn.getTableName()));
                lstHandler.add(new NumberEqualsFilterTermHandler(filterColumn, filterColumn.getTableName()));
                break;
            }
            case CT_DATE_COLUMN: {
                lstHandler.add(new NullFilterTermHandler(filterColumn, filterColumn.getTableName()));
                lstHandler.add(new SubselectFilterTermHandler(filterColumn, filterColumn.getTableName()));
                lstHandler.add(new DateRegionFilterTermHandler(filterColumn, filterColumn.getTableName()));
                lstHandler.add(new DateInFilterTermHandler(filterColumn, filterColumn.getTableName()));
                lstHandler.add(new DateEqualsFilterTermHandler(filterColumn, filterColumn.getTableName()));
                break;
            }
            case CT_TEXT_COLUMN: {
                lstHandler.add(new TextNullFilterTermHandler(filterColumn, filterColumn.getTableName()));
                lstHandler.add(new SubselectFilterTermHandler(filterColumn, filterColumn.getTableName()));
                lstHandler.add(new TextInFilterTermHandler(filterColumn, filterColumn.getTableName()));
                lstHandler.add(new TextIsLikeFilterTermHandler(filterColumn, filterColumn.getTableName()));
                break;
            }
            default: {
                lstHandler.add(new EmptyFilterTermHandler(filterColumn, filterColumn.getTableName()));
                lstHandler.add(new NullFilterTermHandler(filterColumn, filterColumn.getTableName()));
            }
        }
        return lstHandler;
    }

    private FilterTermFactory() {
    }
}

