/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.filter.dbparser;

import de.riwagis.riwadatatable.columns.AbstractDateColumn;
import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.filter.DataTableQuery;
import de.riwagis.riwadatatable.filter.dbparser.AbstractFilterTermHandler;
import de.riwagis.util.StringSupport;
import de.riwagis.util.exception.SystemException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;

public class DateRegionFilterTermHandler
extends AbstractFilterTermHandler {
    public DateRegionFilterTermHandler(TableColumn filterColumn, String tableName) {
        super(filterColumn, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object parseTerm(String term, boolean useStartOfRange) throws SystemException {
        DateFormat fmtColumnFormatter;
        DateFormat dateFormat = fmtColumnFormatter = ((AbstractDateColumn)this.filterColumn).getDateFormatInternal();
        synchronized (dateFormat) {
            term = StringSupport.shortDate2Date((String)term, (boolean)false, (boolean)useStartOfRange, (DateFormat)fmtColumnFormatter);
        }
        Object obj = this.filterColumn.parseObject(term);
        if (obj != null && obj instanceof Date) {
            obj = ((AbstractDateColumn)this.filterColumn).isDateTime() ? new Timestamp(((Date)obj).getTime()) : new java.sql.Date(((Date)obj).getTime());
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleFilterTerm(String term, DataTableQuery query) throws SystemException {
        DateFormat fmtColumnFormatter;
        String firstPart;
        if (term.length() > 2) {
            firstPart = term.substring(0, 2);
            if (firstPart.equals("<=") || firstPart.equals("=<") || term.startsWith("-")) {
                term = term.replaceFirst("^(<=|=<|-)", "");
                Object objFilter = this.parseTerm(term, false);
                this.addColumnName(query);
                query.appendToQuery(" <= ?", objFilter);
                return true;
            }
            if (firstPart.equals(">=") || firstPart.equals("=>") || term.endsWith("-")) {
                term = term.replaceFirst("^(>=|=>)", "");
                term = term.replaceFirst("-$", "");
                Object objFilter = this.parseTerm(term, true);
                this.addColumnName(query);
                query.appendToQuery(" >= ?", objFilter);
                return true;
            }
        }
        if (term.length() > 1) {
            firstPart = term.substring(0, 1);
            if (firstPart.equals("<")) {
                term = term.substring(1);
                Object objFilter = this.parseTerm(term, true);
                this.addColumnName(query);
                query.appendToQuery(" < ?", objFilter);
                return true;
            }
            if (firstPart.equals(">")) {
                term = term.substring(1);
                Object objFilter = this.parseTerm(term, false);
                this.addColumnName(query);
                query.appendToQuery(" > ?", objFilter);
                return true;
            }
        }
        DateFormat objFilter = fmtColumnFormatter = ((AbstractDateColumn)this.filterColumn).getDateFormatInternal();
        synchronized (objFilter) {
            term = StringSupport.shortDate2Date((String)term, (boolean)true, (DateFormat)fmtColumnFormatter);
        }
        if (term.indexOf(45) > 0) {
            String[] arrTerm = term.split("-");
            if (arrTerm.length != 2) {
                throw new SystemException(String.format("Tabellenspalte '%s': Mehrmalige Angabe des Verkn\u00fcpfungsoperators ('-' in '%s') nicht erlaubt", this.filterColumn.getColumnName(), term));
            }
            Object[] arrFilterObject = new Object[2];
            for (int i = 0; i < arrTerm.length; ++i) {
                arrFilterObject[i] = this.parseTerm(arrTerm[i], true);
            }
            this.addColumnName(query);
            query.appendToQuery(" between ? and ?", arrFilterObject);
            return true;
        }
        return false;
    }
}

