/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.filter.dbparser;

import de.riwagis.riwadatatable.columns.AbstractDateColumn;
import de.riwagis.riwadatatable.columns.ColumnTypes;
import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.filter.DataTableQuery;
import de.riwagis.riwadatatable.filter.dbparser.FilterTermHandler;
import de.riwagis.riwadatatable.filter.dbparser.NumberEqualsFilterTermHandler;
import de.riwagis.util.exception.SystemException;
import java.util.Date;

public abstract class AbstractFilterTermHandler
implements FilterTermHandler {
    protected final TableColumn filterColumn;
    protected final String tableName;

    protected AbstractFilterTermHandler(TableColumn filterColumn, String tableName) {
        this.filterColumn = filterColumn;
        this.tableName = tableName;
    }

    public TableColumn getFilterColumn() {
        return this.filterColumn;
    }

    public String getTableName() {
        return this.tableName;
    }

    protected void addColumnName(DataTableQuery query) {
        Object columnName = query.getTableAliasHint().isEmpty() ? this.filterColumn.getColumnName() : query.getTableAliasHint() + "." + this.filterColumn.getColumnName();
        if (this.filterColumn.getType() == ColumnTypes.CT_DATE_COLUMN) {
            query.appendToQuery(((AbstractDateColumn)this.filterColumn).getWhereColumnString((String)columnName));
        } else {
            query.appendToQuery((String)columnName);
        }
    }

    private String filterObject2String(Object obj) {
        if (this.filterColumn.getType() == ColumnTypes.CT_DATE_COLUMN) {
            return ((AbstractDateColumn)this.filterColumn).toDbDate((Date)obj);
        }
        if (this.filterColumn.getType() == ColumnTypes.CT_NUMBER_COLUMN) {
            return obj.toString();
        }
        return this.filterColumn.format(obj);
    }

    @Override
    @Deprecated
    public boolean handleFilterTermWithoutPreparedStatement(String term, DataTableQuery query) throws SystemException {
        DataTableQuery prepQuery = new DataTableQuery();
        prepQuery.setAvoidPrepStatementHint(true);
        boolean handled = this.handleFilterTerm(term, prepQuery);
        if (handled) {
            Object[] arrObj;
            if (this instanceof NumberEqualsFilterTermHandler && term.contains("*")) {
                String newterm = term.replace("*", "%");
                this.addColumnName(query);
                query.appendToQuery(String.format(" like '%s'", newterm));
                return true;
            }
            String prepQueryString = prepQuery.getSQLWhere();
            char quote = this.filterColumn.getColumnQuote();
            for (Object obj : arrObj = prepQuery.getWhereCriterias()) {
                prepQueryString = prepQueryString.replaceFirst("\\?", quote + this.filterObject2String(obj) + quote);
            }
            query.appendToQuery(prepQueryString);
            return true;
        }
        return false;
    }
}

