/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.filter;

import de.riwagis.riwadatatable.filter.DataTableFilterUtil;
import de.riwagis.riwadatatable.filter.DataTableQueryFilterCriteriaCreator;
import de.riwagis.riwadatatable.filter.QueryLinkType;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionInfo;
import de.riwagis.util.jdbc.JDBCSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class DataTableQuery
implements Serializable,
Cloneable {
    private final StringBuilder whereQuery = new StringBuilder();
    private final List<Object> filterCriteria = new ArrayList<Object>();
    private String tableAliasHint = "";
    private boolean avoidPrepStatementHint = false;
    private boolean useCaseSensitiveTextSearchHint = false;
    private int limit = 0;
    private int offset = 0;
    private String orderBy = "";
    private JDBCConnectionInfo connectionInfo = null;

    public DataTableQuery() {
        this(null, "", null);
    }

    public DataTableQuery(JDBCConnectionInfo connectionInfo) {
        this(connectionInfo, "", null);
    }

    public DataTableQuery(String whereQuery, List<? extends Object> filterCriteria) {
        this(null, whereQuery, filterCriteria);
    }

    public DataTableQuery(JDBCConnectionInfo connectionInfo, String whereQuery, List<? extends Object> filterCriteria) {
        this.whereQuery.append(whereQuery);
        if (filterCriteria != null) {
            this.addFilterCriterias(filterCriteria.toArray());
        }
        this.connectionInfo = connectionInfo;
    }

    public DataTableQuery(StringBuilder whereQuery, List<? extends Object> filterCriteria) {
        this(null, whereQuery.toString(), filterCriteria);
    }

    public DataTableQuery(JDBCConnectionInfo connectionInfo, String whereQuery, Object ... filterCriteria) {
        this.whereQuery.append(whereQuery);
        if (filterCriteria != null) {
            this.addFilterCriterias(filterCriteria);
        }
        this.connectionInfo = connectionInfo;
    }

    public DataTableQuery(DataTableQuery copyFrom) {
        this(copyFrom.getSQLWhere(), Arrays.asList(copyFrom.getWhereCriteriasInternal()));
        this.setTableAliasHint(copyFrom.getTableAliasHint());
        this.setAvoidPrepStatementHint(copyFrom.isAvoidPrepStatementHint());
        this.setUseCaseSensitiveTextSearchHint(copyFrom.isUseCaseSensitiveTextSearchHint());
        this.setConnectionInfo(copyFrom.getConnectionInfo());
        this.setLimit(copyFrom.getLimit());
        this.setOffset(copyFrom.getOffset());
        this.setOrderBy(copyFrom.getOrderBy());
    }

    public String serializeQuery2String() throws IOException {
        return DataTableQuery.serializeQuery2String(this);
    }

    public static String serializeQuery2String(DataTableQuery query) throws IOException {
        try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
            String string;
            try (ObjectOutputStream queryout = new ObjectOutputStream(bout);){
                queryout.writeObject(query);
                queryout.close();
                string = Base64.encodeBase64String((byte[])bout.toByteArray());
            }
            return string;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static DataTableQuery deserializeQueryFromString(String queryString) throws IOException {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(Base64.decodeBase64((String)queryString));){
            DataTableQuery dataTableQuery;
            try (ObjectInputStream queryin = new ObjectInputStream(bis);){
                Object objQuery = queryin.readObject();
                dataTableQuery = (DataTableQuery)objQuery;
            }
            return dataTableQuery;
        }
        catch (ClassNotFoundException ex) {
            throw new IOException(String.format("error deserializing query: %s", ex.getMessage()), ex);
        }
    }

    public boolean isEmpty() {
        return this.whereQuery.length() == 0;
    }

    public DataTableQuery appendToQuery(QueryLinkType linkMethod, String query2Append, Object ... criterias) {
        if (StringUtils.isBlank((String)query2Append)) {
            throw new IllegalArgumentException("empty query not allowed");
        }
        if (StringUtils.isNotBlank((String)this.whereQuery.toString())) {
            this.appendToQuery(String.format(" %s (%s)", linkMethod.getConcatenate(), query2Append), criterias);
        } else {
            this.appendToQuery(query2Append, criterias);
        }
        return this;
    }

    public DataTableQuery appendToQuery(String query2Append, Object ... criterias) {
        this.appendToQuery(query2Append);
        this.addFilterCriterias(criterias);
        return this;
    }

    public DataTableQuery appendToQuery(String query2Append) {
        this.whereQuery.append(query2Append);
        return this;
    }

    public DataTableQuery insertInQuery(int offset, String query2Insert) {
        this.whereQuery.insert(offset, query2Insert);
        return this;
    }

    public final DataTableQuery addFilterCriterias(Object ... criterias) {
        for (Object currFilterCritera : criterias) {
            if (currFilterCritera instanceof Date && !(currFilterCritera instanceof Timestamp)) {
                this.filterCriteria.add(DataTableFilterUtil.asSQLDate((Date)currFilterCritera));
                continue;
            }
            this.filterCriteria.add(currFilterCritera);
        }
        return this;
    }

    public String getSQLWhere() {
        return this.whereQuery.toString();
    }

    public String getSQLWhere(boolean insertWhereBeforeQuery) {
        Object queryString = this.getSQLWhere();
        if (insertWhereBeforeQuery) {
            String trimmedQueryString = ((String)queryString).trim();
            if (trimmedQueryString.isEmpty()) {
                return queryString;
            }
            if (trimmedQueryString.startsWith("where ")) {
                if (!((String)queryString).startsWith(" ")) {
                    queryString = " " + (String)queryString;
                }
            } else {
                queryString = ((String)queryString).startsWith(" ") ? " where" + (String)queryString : " where " + (String)queryString;
            }
        }
        return queryString;
    }

    private Object[] getWhereCriteriasInternal() {
        return this.filterCriteria.toArray();
    }

    public Object[] getWhereCriterias() {
        for (Object currCriteria : this.filterCriteria) {
            if (!(currCriteria instanceof DataTableQueryFilterCriteriaCreator)) continue;
            throw new RuntimeException("DataTableQueryFilterCriteriaCreator found in filter criterias. Use getWhereCriterias(Connection conn) method to retrieve proper filter criterias.");
        }
        return this.filterCriteria.toArray();
    }

    public Object[] getWhereCriterias(Connection conn) throws SQLException {
        ArrayList<Object> resCriteria = new ArrayList<Object>();
        for (Object currCriteria : this.filterCriteria) {
            if (currCriteria instanceof DataTableQueryFilterCriteriaCreator) {
                resCriteria.add(((DataTableQueryFilterCriteriaCreator)currCriteria).createFilterCriteria(this, conn));
                continue;
            }
            resCriteria.add(currCriteria);
        }
        return resCriteria.toArray(Object[]::new);
    }

    public DataTableQuery appendQueryWithAnd(DataTableQuery query) {
        this.appendQuery(query, QueryLinkType.LINK_AND);
        return this;
    }

    public DataTableQuery appendQueryWithOr(DataTableQuery query) {
        this.appendQuery(query, QueryLinkType.LINK_OR);
        return this;
    }

    public DataTableQuery appendQuery(DataTableQuery query, QueryLinkType linkMethod) {
        String whereToAppend = ObjectUtils.toString((Object)query.getSQLWhere());
        Object[] filterObjectsToAppend = query.getWhereCriteriasInternal();
        if (whereToAppend.isEmpty()) {
            if (filterObjectsToAppend.length > 0) {
                throw new IllegalArgumentException("Empty query with filter objects is not allowed query.");
            }
        } else {
            if (this.whereQuery.length() > 0) {
                this.whereQuery.insert(0, "(");
                this.whereQuery.append(") ").append(linkMethod.getConcatenate()).append(" ");
            }
            this.whereQuery.append("(").append(whereToAppend).append(")");
            this.addFilterCriterias(filterObjectsToAppend);
        }
        return this;
    }

    public PreparedStatement prepareStatement(Connection conn) throws SQLException {
        return JDBCSupport.prepareSelectStatement((Connection)conn, (String)this.getSQLWhere(), (Object[])this.getWhereCriterias(conn));
    }

    @Deprecated
    public DataTableQuery clone() throws CloneNotSupportedException {
        return new DataTableQuery(this);
    }

    public String toString() {
        if (StringUtils.isNotBlank((String)this.getOrderBy())) {
            return String.format("DataTableQuery: '%s order by %s. [%s], %s", this.getSQLWhere(), this.getOrderBy(), StringUtils.join((Object[])this.getWhereCriterias(), (String)";"), this.getTableAliasHint());
        }
        return String.format("DataTableQuery: '%s'. [%s], %s", this.getSQLWhere(), StringUtils.join((Object[])this.getWhereCriterias(), (String)";"), this.getTableAliasHint());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataTableQuery)) {
            return false;
        }
        DataTableQuery other = (DataTableQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAvoidPrepStatementHint() != other.isAvoidPrepStatementHint()) {
            return false;
        }
        if (this.isUseCaseSensitiveTextSearchHint() != other.isUseCaseSensitiveTextSearchHint()) {
            return false;
        }
        if (this.getLimit() != other.getLimit()) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        List<Object> this$filterCriteria = this.filterCriteria;
        List<Object> other$filterCriteria = other.filterCriteria;
        if (this$filterCriteria == null ? other$filterCriteria != null : !((Object)this$filterCriteria).equals(other$filterCriteria)) {
            return false;
        }
        String this$tableAliasHint = this.getTableAliasHint();
        String other$tableAliasHint = other.getTableAliasHint();
        if (this$tableAliasHint == null ? other$tableAliasHint != null : !this$tableAliasHint.equals(other$tableAliasHint)) {
            return false;
        }
        String this$orderBy = this.getOrderBy();
        String other$orderBy = other.getOrderBy();
        if (this$orderBy == null ? other$orderBy != null : !this$orderBy.equals(other$orderBy)) {
            return false;
        }
        JDBCConnectionInfo this$connectionInfo = this.getConnectionInfo();
        JDBCConnectionInfo other$connectionInfo = other.getConnectionInfo();
        if (this$connectionInfo == null ? other$connectionInfo != null : !this$connectionInfo.equals(other$connectionInfo)) {
            return false;
        }
        String this$$getSQLWhere = this.getSQLWhere();
        String other$$getSQLWhere = other.getSQLWhere();
        return !(this$$getSQLWhere == null ? other$$getSQLWhere != null : !this$$getSQLWhere.equals(other$$getSQLWhere));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataTableQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAvoidPrepStatementHint() ? 79 : 97);
        result = result * 59 + (this.isUseCaseSensitiveTextSearchHint() ? 79 : 97);
        result = result * 59 + this.getLimit();
        result = result * 59 + this.getOffset();
        List<Object> $filterCriteria = this.filterCriteria;
        result = result * 59 + ($filterCriteria == null ? 43 : ((Object)$filterCriteria).hashCode());
        String $tableAliasHint = this.getTableAliasHint();
        result = result * 59 + ($tableAliasHint == null ? 43 : $tableAliasHint.hashCode());
        String $orderBy = this.getOrderBy();
        result = result * 59 + ($orderBy == null ? 43 : $orderBy.hashCode());
        JDBCConnectionInfo $connectionInfo = this.getConnectionInfo();
        result = result * 59 + ($connectionInfo == null ? 43 : $connectionInfo.hashCode());
        String $$getSQLWhere = this.getSQLWhere();
        result = result * 59 + ($$getSQLWhere == null ? 43 : $$getSQLWhere.hashCode());
        return result;
    }

    public void setTableAliasHint(String tableAliasHint) {
        this.tableAliasHint = tableAliasHint;
    }

    public String getTableAliasHint() {
        return this.tableAliasHint;
    }

    public void setAvoidPrepStatementHint(boolean avoidPrepStatementHint) {
        this.avoidPrepStatementHint = avoidPrepStatementHint;
    }

    public boolean isAvoidPrepStatementHint() {
        return this.avoidPrepStatementHint;
    }

    public void setUseCaseSensitiveTextSearchHint(boolean useCaseSensitiveTextSearchHint) {
        this.useCaseSensitiveTextSearchHint = useCaseSensitiveTextSearchHint;
    }

    public boolean isUseCaseSensitiveTextSearchHint() {
        return this.useCaseSensitiveTextSearchHint;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setConnectionInfo(JDBCConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
    }

    public JDBCConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }
}

