/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.filter;

import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.columns.provider.ColumnProvider;
import de.riwagis.riwadatatable.filter.DataTableQuery;
import de.riwagis.riwadatatable.filter.QueryLinkType;
import de.riwagis.riwadatatable.filter.geotools.DataTableGeotoolsFilterVisitor;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionInfo;
import de.riwagis.riwadatatable.table.DbTable;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.jdbc.JDBCSupport;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.geotools.data.Query;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;

public class DataTableFilterUtil {
    private static final int MAX_IN_FILTER_SIZE = 950;

    public static Map<String, Collection<String>> groupWhereValuesByFields(String[][] arrWhere, boolean ignoreEmptyStrings) {
        LinkedHashMap<String, Collection<String>> fieldGroups = new LinkedHashMap<String, Collection<String>>();
        for (int i = 0; i < arrWhere[0].length; ++i) {
            String fieldValue = arrWhere[1][i];
            String fieldNameLC = arrWhere[0][i].toLowerCase();
            if (!fieldGroups.containsKey(fieldNameLC)) {
                fieldGroups.put(fieldNameLC, new ArrayList());
            }
            if (!StringUtils.isNotBlank((String)fieldValue) && ignoreEmptyStrings) continue;
            ((Collection)fieldGroups.get(fieldNameLC)).add(fieldValue);
        }
        return fieldGroups;
    }

    public static String[][] reorderWhereArray(String[][] arrWhere) {
        Map<String, Collection<String>> fieldGroups = DataTableFilterUtil.groupWhereValuesByFields(arrWhere, true);
        String[][] arrWhereNeu = new String[2][fieldGroups.size()];
        int fieldIdx = 0;
        for (Map.Entry<String, Collection<String>> currFieldEntry : fieldGroups.entrySet()) {
            arrWhereNeu[0][fieldIdx] = currFieldEntry.getKey();
            arrWhereNeu[1][fieldIdx] = StringUtils.join(currFieldEntry.getValue(), (String)"|");
            ++fieldIdx;
        }
        return arrWhereNeu;
    }

    public static final int countUniqueFields(String[][] arrWhere) {
        return DataTableFilterUtil.determineUniqueFields(arrWhere).size();
    }

    public static Collection<String> determineUniqueFields(String[][] arrWhere) {
        LinkedHashSet<String> uniqueFields = new LinkedHashSet<String>();
        for (String fieldName : arrWhere[0]) {
            uniqueFields.add(fieldName.toLowerCase());
        }
        return uniqueFields;
    }

    public static final DataTableQuery getQuery4WhereArray(String[][] arrWhere, JDBCConnectionInfo connInfo, ColumnProvider columnProv, boolean bolIgnoreEmptyTerm, boolean avoidPrepStatement, boolean useCaseSensitiveTextSearch) throws SystemException {
        DataTableQuery query = new DataTableQuery(connInfo);
        query.setAvoidPrepStatementHint(avoidPrepStatement);
        query.setUseCaseSensitiveTextSearchHint(useCaseSensitiveTextSearch);
        if (arrWhere.length > 0) {
            String[][] arrWhereNeu = DataTableFilterUtil.reorderWhereArray(arrWhere);
            for (int i = 0; i < arrWhereNeu[0].length; ++i) {
                DataTableFilterUtil.fillQueryByColumnname(columnProv, query, arrWhereNeu[0][i], arrWhereNeu[1][i], bolIgnoreEmptyTerm);
            }
        }
        return query;
    }

    private static void fillQueryByColumnname(ColumnProvider columnProv, DataTableQuery query, String columnName, String filterTerm, boolean bolIgnoreEmptyTerm) throws NullPointerException, SystemException {
        TableColumn column = columnProv.getColumn(columnName);
        column.addFilter2Query(query, QueryLinkType.LINK_AND, filterTerm, bolIgnoreEmptyTerm);
    }

    public static DataTableQuery toQuery(String cql, String tableName, String primaryKey, JDBCConnectionInfo connInfo) throws SystemException {
        try {
            Filter filt = CQL.toFilter((String)cql);
            DataTableGeotoolsFilterVisitor visi = new DataTableGeotoolsFilterVisitor(tableName, primaryKey);
            DataTableQuery query = new DataTableQuery(connInfo);
            filt.accept((FilterVisitor)visi, (Object)query);
            return query;
        }
        catch (CQLException ce) {
            throw new SystemException((Throwable)ce);
        }
    }

    public static DataTableQuery toQuery(String cql, String tableName, ColumnProvider columnProvider, JDBCConnectionInfo connInfo) throws SystemException {
        try {
            Filter filt = CQL.toFilter((String)cql);
            DataTableGeotoolsFilterVisitor visi = new DataTableGeotoolsFilterVisitor(tableName, columnProvider);
            DataTableQuery query = new DataTableQuery(connInfo);
            filt.accept((FilterVisitor)visi, (Object)query);
            return query;
        }
        catch (CQLException ce) {
            throw new SystemException((Throwable)ce);
        }
    }

    public static DataTableQuery convertQuery(DbTable dbt, Query query) {
        DataTableQuery dtQuery = new DataTableQuery(dbt.getConnectionInfo());
        dtQuery.setLimit(query.getMaxFeatures());
        Filter filter = query.getFilter();
        if (filter != null) {
            DataTableGeotoolsFilterVisitor visitor = new DataTableGeotoolsFilterVisitor("tbl", dbt);
            filter.accept((FilterVisitor)visitor, (Object)dtQuery);
        }
        return dtQuery;
    }

    public static final Date asSQLDate(java.util.Date dateValue, boolean truncate) {
        if (dateValue == null) {
            return null;
        }
        java.util.Date finalDate = truncate ? DateUtils.truncate((java.util.Date)dateValue, (int)5) : dateValue;
        return new Date(finalDate.getTime());
    }

    public static final Date asSQLDate(java.util.Date dateValue) {
        return DataTableFilterUtil.asSQLDate(dateValue, false);
    }

    public static final Timestamp asSQLTimestamp(java.util.Date dateValue) {
        return dateValue == null ? null : new Timestamp(dateValue.getTime());
    }

    public static DataTableQuery createInDataTableQuery(String columnName, Object ... columnValues) throws SystemException {
        if (StringUtils.isNotBlank((String)columnName)) {
            if (columnValues.length <= 0) {
                throw new SystemException("column values must not be empty");
            }
        } else {
            throw new SystemException("column must not be empty");
        }
        DataTableQuery query = new DataTableQuery();
        query.appendToQuery(JDBCSupport.buildInList((String)columnName, Collections.nCopies(columnValues.length, "?"), (int)950));
        query.addFilterCriterias(columnValues);
        return query;
    }
}

