/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.filter;

import de.riwagis.riwadatatable.filter.DataTableQuery;
import de.riwagis.riwadatatable.filter.DataTableQueryFilterCriteriaCreator;
import de.riwagis.riwadatatable.oracle.sdo.GeometryConverter;
import java.sql.Connection;
import java.sql.SQLException;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.WKBWriter;
import org.opengis.filter.spatial.BBOX;

public class BBoxDataTableQueryFilterCriteriaCreator
implements DataTableQueryFilterCriteriaCreator {
    private final Polygon bboxPolygon;

    public BBoxDataTableQueryFilterCriteriaCreator(BBOX bbox) {
        GeometryFactory gfac = new GeometryFactory();
        Coordinate[] arrCoord = new Coordinate[]{new Coordinate(bbox.getBounds().getMinX(), bbox.getBounds().getMinY()), new Coordinate(bbox.getBounds().getMinX(), bbox.getBounds().getMaxY()), new Coordinate(bbox.getBounds().getMaxX(), bbox.getBounds().getMaxY()), new Coordinate(bbox.getBounds().getMaxX(), bbox.getBounds().getMinY()), new Coordinate(bbox.getBounds().getMinX(), bbox.getBounds().getMinY())};
        LinearRing lring = gfac.createLinearRing(arrCoord);
        this.bboxPolygon = gfac.createPolygon(lring, null);
    }

    public BBoxDataTableQueryFilterCriteriaCreator(Envelope env) {
        GeometryFactory gfac = new GeometryFactory();
        Coordinate[] arrCoord = new Coordinate[]{new Coordinate(env.getMinX(), env.getMinY()), new Coordinate(env.getMinX(), env.getMaxY()), new Coordinate(env.getMaxX(), env.getMaxY()), new Coordinate(env.getMaxX(), env.getMinY()), new Coordinate(env.getMinX(), env.getMinY())};
        LinearRing lring = gfac.createLinearRing(arrCoord);
        this.bboxPolygon = gfac.createPolygon(lring, null);
    }

    public Envelope getBBoxAsEnvelope() {
        return new Envelope(this.bboxPolygon.getEnvelopeInternal());
    }

    @Override
    public Object createFilterCriteria(DataTableQuery query, Connection conn) throws SQLException {
        if (query.getConnectionInfo() == null) {
            throw new IllegalStateException("BBOX filters need JDBCConnectionInfo in the DataTableQuery object.");
        }
        switch (query.getConnectionInfo().getDBType()) {
            case MySQL: 
            case MariaDB: 
            case Postgres: 
            case MSSQLServer: {
                return new WKBWriter().write((Geometry)this.bboxPolygon);
            }
            case Oracle: {
                GeometryConverter gconv = new GeometryConverter(conn);
                return gconv.toSDO((Geometry)this.bboxPolygon, query.getConnectionInfo().getSRID());
            }
        }
        throw new UnsupportedOperationException(String.format("Spatial queries are not supported for DBType %s.", query.getConnectionInfo().getDBType().getTypeIdentifier()));
    }
}

