/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.data;

import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.columns.provider.ColumnProvider;
import de.riwagis.riwadatatable.data.DataRow;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionManager;
import de.riwagis.riwadatatable.table.DbTable;
import de.riwagis.util.exception.SystemException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DataRowUtils {
    private DataRowUtils() {
    }

    public static DataRow fillRowByResultSet(Collection<TableColumn> columns, ResultSet rs, boolean useColumnArrayIndex) throws SystemException {
        return DataRowUtils.fillRowByResultSet(columns.toArray(new TableColumn[columns.size()]), rs, useColumnArrayIndex);
    }

    public static DataRow fillRowByResultSet(TableColumn[] columns, ResultSet rs, boolean useColumnArrayIndex) throws SystemException {
        try {
            Object[] dataset = new Object[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                int index = useColumnArrayIndex ? i + 1 : rs.findColumn(columns[i].getColumnName());
                dataset[i] = columns[i].getObject(index, rs);
            }
            return new DataRow(columns, dataset);
        }
        catch (SystemException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new SystemException((Throwable)e);
        }
    }

    public static DataRow fillRowByMapOfStrings(ColumnProvider columnProvider, Map<String, String> map, boolean ignoreMissingColumns) throws SystemException {
        ArrayList<String> missingColumns = new ArrayList<String>();
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        ArrayList<Object> dataset = new ArrayList<Object>();
        for (String columnName : map.keySet()) {
            if (!columnProvider.hasColumn(columnName)) {
                missingColumns.add(columnName);
                continue;
            }
            TableColumn column = columnProvider.getColumn(columnName);
            Object data = column.parseObject(map.get(columnName));
            columns.add(column);
            dataset.add(data);
        }
        if (!missingColumns.isEmpty() && !ignoreMissingColumns) {
            throw new SystemException(String.format("Column(s) '%s' where not found in given column provider.", StringUtils.join(missingColumns, (String)", ")));
        }
        return new DataRow(columns.toArray(new TableColumn[columns.size()]), dataset.toArray(new Object[dataset.size()]));
    }

    public static void fillPreparedStatementWithDataRow(PreparedStatement pstmt, DataRow row) throws SystemException {
        int indexPStmt = 1;
        int indexRow = 0;
        for (TableColumn col : row.getColumnsCollection()) {
            col.setObject(indexPStmt, row.getData(indexRow), pstmt);
            ++indexPStmt;
            ++indexRow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final DataRow createEmptyRow(DbTable tbl) throws SystemException, SQLException {
        DataRow row = new DataRow(tbl.getColumnsCollection().toArray(new TableColumn[tbl.getColumnCount()]), new Object[tbl.getColumnCount()]);
        JDBCConnectionManager connMngr = tbl.getConnectionManagerInternal();
        Connection conn = connMngr.createConnection();
        try {
            tbl.addDefaultTableValuesToDataRow(conn, row, true);
        }
        finally {
            connMngr.closeConnection(conn);
        }
        return row;
    }
}

