/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.data;

import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.data.DataRow;
import de.riwagis.riwadatatable.data.DataRowReaderResultSet;
import de.riwagis.riwadatatable.data.DataRowUtils;
import de.riwagis.util.exception.SystemException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataRowReaderResultSetSkippable
extends DataRowReaderResultSet {
    private static final Logger LOG = LoggerFactory.getLogger(DataRowReaderResultSetSkippable.class);
    private DataRow currentRow;

    public DataRowReaderResultSetSkippable(Collection<TableColumn> columns, ResultSet rs, boolean useColumnArrayIndex) throws SQLException {
        super(columns, rs, useColumnArrayIndex);
    }

    @Override
    public boolean hasNext() {
        this.checkClosed();
        try {
            if (!this.nextCalled) {
                this.currentRow = null;
                boolean next = this.rs.next();
                if (next) {
                    try {
                        this.currentRow = this.adjustRow(DataRowUtils.fillRowByResultSet(this.columns, this.rs, this.useColumnArrayIndex));
                        while (this.currentRow == null && next) {
                            next = this.rs.next();
                            if (next) {
                                this.currentRow = this.adjustRow(DataRowUtils.fillRowByResultSet(this.columns, this.rs, this.useColumnArrayIndex));
                                continue;
                            }
                            this.currentRow = null;
                        }
                    }
                    catch (SystemException e) {
                        throw new RuntimeException("Error at calling rs.next() in DataRowReader: " + e.getMessage(), e);
                    }
                }
                this.nextCalled = true;
            }
            return this.currentRow != null;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error at calling rs.next() in DataRowReader. Should never reach here.", e);
        }
    }

    @Override
    public DataRow next() {
        this.checkClosed();
        try {
            if (!this.nextCalled) {
                this.hasNext();
            }
            if (this.currentRow != null) {
                DataRow dataRow = this.currentRow;
                return dataRow;
            }
            throw new RuntimeException("No next DataRow exits in given ResultSet.");
        }
        finally {
            this.nextCalled = false;
        }
    }
}

