/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.data;

import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.columns.provider.ArrayBasedColumnProvider;
import de.riwagis.riwadatatable.data.DataRow;
import de.riwagis.riwadatatable.data.DataRowReader;
import de.riwagis.riwadatatable.data.DataRowReaderListener;
import de.riwagis.riwadatatable.data.DataRowUtils;
import de.riwagis.util.exception.SystemException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataRowReaderResultSet
extends ArrayBasedColumnProvider
implements DataRowReader {
    private static final Logger LOG = LoggerFactory.getLogger(DataRowReaderResultSet.class);
    private boolean closed = false;
    private final Collection<DataRowReaderListener> doWithCloseListeners = new ArrayList<DataRowReaderListener>();
    protected boolean next = false;
    protected boolean nextCalled = false;
    protected final ResultSet rs;
    protected final boolean useColumnArrayIndex;

    public DataRowReaderResultSet(Collection<TableColumn> columns, ResultSet rs, boolean useColumnArrayIndex) throws SQLException {
        super(columns.toArray(new TableColumn[columns.size()]));
        this.rs = rs;
        this.useColumnArrayIndex = useColumnArrayIndex;
    }

    private void closeResultSet() throws SQLException {
        this.rs.close();
    }

    @Override
    public void close() throws SystemException {
        this.checkClosed();
        SQLException throwEx = null;
        try {
            this.closeResultSet();
        }
        catch (SQLException e) {
            throwEx = e;
        }
        SQLException ex = this.fireReaderClosedListeners();
        if (throwEx == null && ex != null) {
            throwEx = ex;
        }
        this.closed = true;
        if (throwEx != null) {
            throw new SystemException(String.format("failed to close DataRowReader: %s", throwEx.getMessage()), (Throwable)throwEx);
        }
    }

    @Override
    public void closeQuietly() {
        try {
            this.closeResultSet();
        }
        catch (SQLException eatit) {
            LOG.debug(String.format("ignoring error on closing resultset: %s", eatit.getMessage()));
        }
        try {
            this.fireReaderClosedListeners();
        }
        catch (Throwable eatit) {
            LOG.debug(String.format("ignoring error on closing resultset: %s", eatit.getMessage()));
        }
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected void checkClosed() {
        if (this.closed) {
            throw new RuntimeException("DataRowReader is already closed. Operation is not allowed any more.");
        }
    }

    @Override
    public boolean hasNext() {
        this.checkClosed();
        try {
            if (this.nextCalled) {
                return this.next;
            }
            this.next = this.rs.next();
            this.nextCalled = true;
            return this.next;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error at calling rs.next() in DataRowReader. Should never reach here.", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DataRow next() {
        this.checkClosed();
        if (!this.nextCalled) {
            this.hasNext();
        }
        if (!this.next) throw new RuntimeException("No next DataRow exits in given ResultSet.");
        try {
            DataRow dataRow = this.adjustRow(DataRowUtils.fillRowByResultSet(this.columns, this.rs, this.useColumnArrayIndex));
            this.nextCalled = false;
            return dataRow;
        }
        catch (Throwable throwable) {
            try {
                this.nextCalled = false;
                throw throwable;
            }
            catch (SystemException e) {
                throw new RuntimeException("Error at calling rs.next() in DataRowReader: " + e.getMessage(), e);
            }
        }
    }

    protected DataRow adjustRow(DataRow row) {
        return row;
    }

    public void addReaderClosedListener(DataRowReaderListener listener) {
        this.checkClosed();
        this.doWithCloseListeners.add(listener);
    }

    public boolean removeReaderClosedListener(DataRowReaderListener listener) {
        return this.doWithCloseListeners.remove(listener);
    }

    private SQLException fireReaderClosedListeners() {
        SQLException ex2return = null;
        for (DataRowReaderListener listener : this.doWithCloseListeners) {
            try {
                listener.readerClosed();
            }
            catch (SQLException sqlex) {
                if (ex2return != null) continue;
                ex2return = sqlex;
            }
            catch (Throwable t) {
                LOG.error(String.format("Unexpected error calling DataRowClosedListener '%s'. Should never reach here.", listener.getClass().getCanonicalName()), t);
            }
        }
        return ex2return;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

