/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.data;

import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.columns.provider.ArrayBasedColumnProvider;
import de.riwagis.util.exception.SystemException;
import java.util.Collection;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class DataRow
extends ArrayBasedColumnProvider {
    private Object[] dataset;

    public DataRow(TableColumn[] _columns, Object ... _dataset) {
        super(_columns);
        this.dataset = _dataset;
        if (this.columns.length != this.dataset.length) {
            if (this.dataset.length == 0) {
                this.dataset = new Object[this.columns.length];
            } else {
                throw new IllegalArgumentException("Error initializing DataRow. Dataset length and columns length which describe the dataset should be equal.");
            }
        }
    }

    public DataRow(Collection<TableColumn> _columns, Collection<Object> _dataset) {
        this(_columns.toArray(new TableColumn[_columns.size()]), _dataset.toArray(new Object[_dataset.size()]));
    }

    public DataRow(Collection<TableColumn> _columns, Object ... _dataset) {
        this(_columns.toArray(new TableColumn[_columns.size()]), _dataset);
    }

    public DataRow(DataRow copyFrom) {
        this(copyFrom.columns, copyFrom.getDataset());
    }

    public synchronized void addColumn(int index, TableColumn column, Object data) {
        super.addColumn(index, column);
        Object[] newdataset = new Object[this.dataset.length + 1];
        int newindex = 0;
        for (int i = 0; i < this.dataset.length; ++i) {
            if (i == index) {
                ++newindex;
            }
            newdataset[newindex] = this.dataset[i];
            ++newindex;
        }
        newdataset[index] = data;
        this.dataset = newdataset;
    }

    @Override
    public void removeColumn(Collection<String> columnNames) {
        super.removeColumn(columnNames);
    }

    @Override
    public void removeColumn(String columnName) {
        super.removeColumn(columnName);
    }

    @Override
    public synchronized void removeColumn(int index) {
        if (index > this.dataset.length - 1 || index < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("Error removing column with index %s from DataRow.", index));
        }
        Object[] newdataset = new Object[this.dataset.length - 1];
        int newindex = 0;
        for (int i = 0; i < this.columns.length; ++i) {
            if (i == index) continue;
            newdataset[newindex] = this.dataset[i];
            ++newindex;
        }
        this.dataset = newdataset;
        super.removeColumn(index);
    }

    public Object getData(int index) {
        return this.dataset[index];
    }

    public Object getData(String columnName) {
        TableColumn col = this.getColumn(columnName);
        return this.getData(ArrayUtils.indexOf((Object[])this.columns, (Object)col));
    }

    public String getDataAsString(String columnName) {
        TableColumn col = this.getColumn(columnName);
        return col.format(this.dataset[ArrayUtils.indexOf((Object[])this.columns, (Object)col)]);
    }

    public Object[] getDataAsArray() {
        return this.dataset;
    }

    public void setData(int index, Object data) {
        this.dataset[index] = data;
    }

    public void setData(String columnName, Object data) {
        TableColumn col = this.getColumn(columnName);
        this.setData(ArrayUtils.indexOf((Object[])this.columns, (Object)col), data);
    }

    public void setDataAsString(String columnName, String data) throws SystemException {
        TableColumn col = this.getColumn(columnName);
        this.setData(ArrayUtils.indexOf((Object[])this.columns, (Object)col), col.parseObject(data));
    }

    private Object[] getDataset() {
        return this.dataset;
    }

    public String toString() {
        return String.format("DataRow: [%s]", StringUtils.join((Object[])this.getDataset(), (String)","));
    }

    public Object getDatasetSize() {
        return this.dataset.length;
    }
}

