/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.columns.util;

import de.riwagis.riwadatatable.jdbc.JDBCConnectionInfo;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SqlKeyWordsUtils {
    private static List<String> mssqlKeyWords = null;
    private static List<String> mysqlKeyWords = null;
    private static List<String> oracleKeyWords = null;
    private static List<String> postgresKeyWords = null;

    public static synchronized boolean isReservedWord(JDBCConnectionInfo connInfo, String wordToCheck) {
        switch (connInfo.getDBType()) {
            case MSSQLServer: {
                if (mssqlKeyWords == null) {
                    mssqlKeyWords = SqlKeyWordsUtils.getSqlKeyWords(connInfo);
                }
                return mssqlKeyWords.contains(wordToCheck.toLowerCase());
            }
            case MariaDB: 
            case MySQL: {
                if (mysqlKeyWords == null) {
                    mysqlKeyWords = SqlKeyWordsUtils.getSqlKeyWords(connInfo);
                }
                return mysqlKeyWords.contains(wordToCheck.toLowerCase());
            }
            case Oracle: {
                if (oracleKeyWords == null) {
                    oracleKeyWords = SqlKeyWordsUtils.getSqlKeyWords(connInfo);
                }
                return oracleKeyWords.contains(wordToCheck.toLowerCase());
            }
            case Postgres: {
                if (postgresKeyWords == null) {
                    postgresKeyWords = SqlKeyWordsUtils.getSqlKeyWords(connInfo);
                }
                return postgresKeyWords.contains(wordToCheck.toLowerCase());
            }
        }
        return false;
    }

    private static List<String> getSqlKeyWords(JDBCConnectionInfo connInfo) {
        List<String> list;
        block8: {
            Connection conn = connInfo.createConnection();
            try {
                list = Arrays.asList(conn.getMetaData().getSQLKeywords().toLowerCase().split(",\\s*"));
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    Logger.getLogger(SqlKeyWordsUtils.class.getName()).log(Level.SEVERE, null, ex);
                    return Collections.EMPTY_LIST;
                }
            }
            conn.close();
        }
        return list;
    }
}

