/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.columns.provider;

import de.riwagis.riwadatatable.columns.GeoColumn;
import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.columns.provider.ColumnProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class MapBasedColumnProvider
implements ColumnProvider {
    protected final Map<String, TableColumn> columnsMap = new LinkedHashMap<String, TableColumn>();

    public MapBasedColumnProvider(Collection<TableColumn> _columns) {
        for (TableColumn column : _columns) {
            this.columnsMap.put(column.getColumnName().toLowerCase(), column);
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnsMap.size();
    }

    @Override
    public boolean hasColumn(String columnName) {
        if (StringUtils.isBlank((String)columnName)) {
            return false;
        }
        return this.columnsMap.containsKey(columnName.toLowerCase());
    }

    @Override
    public boolean hasColumn(String columnName, int[] types) {
        if (!this.hasColumn(columnName)) {
            return false;
        }
        TableColumn col = this.getColumn(columnName);
        for (int j = 0; j < types.length; ++j) {
            if (col.getType().getId() != types[j]) continue;
            return true;
        }
        return false;
    }

    @Override
    public TableColumn getColumn(String columnName) throws IllegalArgumentException {
        TableColumn col = this.columnsMap.get(columnName.toLowerCase());
        if (col == null) {
            throw new IllegalArgumentException(String.format("Column with name '%s' not found.", columnName));
        }
        return col;
    }

    @Override
    public Collection<TableColumn> getColumnsCollection() {
        return new ArrayList<TableColumn>(this.columnsMap.values());
    }

    @Override
    public Collection<TableColumn> getColumnsCollection(Collection<String> columnNames) {
        ArrayList<TableColumn> columnsCollection = new ArrayList<TableColumn>();
        for (String columnName : columnNames) {
            if (StringUtils.isBlank((String)columnName)) continue;
            columnsCollection.add(this.getColumn(columnName));
        }
        return columnsCollection;
    }

    @Override
    public Collection<TableColumn> getColumnsCollection(String ... columnNames) {
        return this.getColumnsCollection(Arrays.asList(columnNames));
    }

    @Override
    public Collection<String> getColumnNames() {
        return new ArrayList<String>(this.columnsMap.keySet());
    }

    @Override
    public Collection<String> getColumnNames(Collection<TableColumn> columns) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (TableColumn column : columns) {
            if (!this.hasColumn(column.getColumnName())) continue;
            columns.add(this.getColumn(column.getColumnName()));
        }
        return columnNames;
    }

    @Override
    public Collection<String> getColumnNames(TableColumn ... columns) {
        return this.getColumnNames(Arrays.asList(columns));
    }

    @Override
    public boolean hasIDColumn() {
        int counter = 0;
        for (TableColumn column : this.columnsMap.values()) {
            if (column.getPrimaryKeyIndex() <= 0) continue;
            ++counter;
        }
        return counter == 1;
    }

    @Override
    public TableColumn getIDColumn() throws IndexOutOfBoundsException {
        TableColumn idColumn = null;
        for (TableColumn column : this.columnsMap.values()) {
            if (column.getPrimaryKeyIndex() <= 0) continue;
            if (idColumn == null) {
                idColumn = column;
                continue;
            }
            throw new IndexOutOfBoundsException("More than one id column was found.");
        }
        if (idColumn == null) {
            throw new IndexOutOfBoundsException("No id column was found.");
        }
        return idColumn;
    }

    @Override
    public GeoColumn getDefaultGeoColumn() throws IndexOutOfBoundsException {
        GeoColumn geoColumn = null;
        for (TableColumn column : this.columnsMap.values()) {
            if (!(column instanceof GeoColumn)) continue;
            if (geoColumn == null) {
                geoColumn = (GeoColumn)column;
                continue;
            }
            if (!column.getColumnName().equalsIgnoreCase("geom")) continue;
            geoColumn = (GeoColumn)column;
            break;
        }
        if (geoColumn == null) {
            throw new IndexOutOfBoundsException("No geometry column was found.");
        }
        return geoColumn;
    }

    @Override
    public boolean hasGeoColumn() {
        for (TableColumn column : this.columnsMap.values()) {
            if (!(column instanceof GeoColumn)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getSqlType(String columnName) {
        return this.getColumn(columnName).getType().getId();
    }
}

