/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.columns.provider;

import de.riwagis.riwadatatable.columns.GeoColumn;
import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.columns.provider.ColumnProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class ArrayBasedColumnProvider
implements ColumnProvider {
    protected TableColumn[] columns;

    public ArrayBasedColumnProvider(TableColumn[] columns) {
        this.columns = columns;
    }

    protected void removeColumn(Collection<String> columnNames) {
        for (String columnName : columnNames) {
            int index = ArrayUtils.indexOf((Object[])this.columns, (Object)this.getColumn(columnName));
            this.removeColumn(index);
        }
    }

    protected void removeColumn(String columnName) {
        int index = ArrayUtils.indexOf((Object[])this.columns, (Object)this.getColumn(columnName));
        this.removeColumn(index);
    }

    protected synchronized void removeColumn(int index) {
        if (index > this.columns.length - 1 || index < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("Error removing column with index %s from DataRow.", index));
        }
        TableColumn[] newcolumns = new TableColumn[this.columns.length - 1];
        int newindex = 0;
        for (int i = 0; i < this.columns.length; ++i) {
            if (i == index) continue;
            newcolumns[newindex] = this.columns[i];
            ++newindex;
        }
        this.columns = newcolumns;
    }

    protected synchronized void addColumn(int index, TableColumn column) {
        if (this.hasColumn(column.getColumnName())) {
            throw new IllegalArgumentException(String.format("Column with name '%s' does already exist.", column.getColumnName()));
        }
        if (index > this.columns.length || index < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("Error adding column with new index %s to DataRow.", index));
        }
        TableColumn[] newcolumns = new TableColumn[this.columns.length + 1];
        int newindex = 0;
        for (int i = 0; i < this.columns.length; ++i) {
            if (i == index) {
                ++newindex;
            }
            newcolumns[newindex] = this.columns[i];
            ++newindex;
        }
        newcolumns[index] = column;
        this.columns = newcolumns;
    }

    public TableColumn getColumn(int index) {
        return this.columns[index];
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public boolean hasColumn(String columnName) {
        if (StringUtils.isBlank((String)columnName)) {
            return false;
        }
        for (TableColumn column : this.columns) {
            if (!column.getColumnName().equalsIgnoreCase(columnName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasColumn(String columnName, int[] types) {
        if (!this.hasColumn(columnName)) {
            return false;
        }
        TableColumn col = this.getColumn(columnName);
        for (int j = 0; j < types.length; ++j) {
            if (col.getType().getId() != types[j]) continue;
            return true;
        }
        return false;
    }

    @Override
    public TableColumn getColumn(String columnName) throws IllegalArgumentException {
        for (TableColumn column : this.columns) {
            if (!column.getColumnName().equalsIgnoreCase(columnName)) continue;
            return column;
        }
        throw new IllegalArgumentException(String.format("Column with name '%s' not found.", columnName));
    }

    @Override
    public Collection<TableColumn> getColumnsCollection() {
        ArrayList<TableColumn> columnsCollection = new ArrayList<TableColumn>();
        for (TableColumn column : this.columns) {
            columnsCollection.add(column);
        }
        return columnsCollection;
    }

    @Override
    public Collection<TableColumn> getColumnsCollection(Collection<String> columnNames) {
        ArrayList<TableColumn> columnsCollection = new ArrayList<TableColumn>();
        for (String columnName : columnNames) {
            if (StringUtils.isBlank((String)columnName)) continue;
            columnsCollection.add(this.getColumn(columnName));
        }
        return columnsCollection;
    }

    @Override
    public Collection<TableColumn> getColumnsCollection(String ... columnNames) {
        return this.getColumnsCollection(Arrays.asList(columnNames));
    }

    @Override
    public Collection<String> getColumnNames() {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (TableColumn column : this.columns) {
            columnNames.add(column.getColumnName());
        }
        return columnNames;
    }

    @Override
    public Collection<String> getColumnNames(Collection<TableColumn> columns) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (TableColumn column : columns) {
            if (!this.hasColumn(column.getColumnName())) continue;
            columnNames.add(this.getColumn(column.getColumnName()).getColumnName());
        }
        return columnNames;
    }

    @Override
    public Collection<String> getColumnNames(TableColumn ... columns) {
        return this.getColumnNames(Arrays.asList(columns));
    }

    @Override
    public boolean hasIDColumn() {
        int counter = 0;
        for (TableColumn column : this.columns) {
            if (column.getPrimaryKeyIndex() <= 0) continue;
            ++counter;
        }
        return counter == 1;
    }

    @Override
    public TableColumn getIDColumn() throws IndexOutOfBoundsException {
        TableColumn idColumn = null;
        for (TableColumn column : this.columns) {
            if (column.getPrimaryKeyIndex() <= 0) continue;
            if (idColumn == null) {
                idColumn = column;
                continue;
            }
            throw new IndexOutOfBoundsException("More than one id column was found.");
        }
        if (idColumn == null) {
            throw new IndexOutOfBoundsException("No id column was found.");
        }
        return idColumn;
    }

    @Override
    public GeoColumn getDefaultGeoColumn() throws IndexOutOfBoundsException {
        GeoColumn geoColumn = null;
        for (TableColumn column : this.columns) {
            if (!(column instanceof GeoColumn)) continue;
            if (geoColumn == null) {
                geoColumn = (GeoColumn)column;
                continue;
            }
            if (!column.getColumnName().equalsIgnoreCase("geom")) continue;
            geoColumn = (GeoColumn)column;
            break;
        }
        if (geoColumn == null) {
            throw new IndexOutOfBoundsException("No geometry column was found.");
        }
        return geoColumn;
    }

    @Override
    public boolean hasGeoColumn() {
        for (TableColumn column : this.columns) {
            if (!(column instanceof GeoColumn)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getSqlType(String columnName) {
        return this.getColumn(columnName).getType().getId();
    }
}

