/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.columns.curved;

import de.riwagis.riwadatatable.columns.curved.RiwaCircularString;
import org.geotools.geometry.jts.CircularRing;
import org.geotools.geometry.jts.CurvedGeometryFactory;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;

public class RiwaCurvedGeometryFactory
extends CurvedGeometryFactory {
    public RiwaCurvedGeometryFactory(double tolerance) {
        super(tolerance);
    }

    public RiwaCurvedGeometryFactory(GeometryFactory delegate, double tolerance) {
        super(delegate, tolerance);
    }

    public LineString createCircularString(int dimension, double ... controlPoints) {
        if (dimension != 2) {
            throw new IllegalArgumentException("Invalid dimension value, right now only 2 dimensional curves are supported");
        }
        return new RiwaCircularString(controlPoints, (GeometryFactory)this, this.getTolerance());
    }

    public LineString createCurvedGeometry(int dimension, double ... controlPoints) {
        if (dimension != 2) {
            throw new IllegalArgumentException("Invalid dimension value, right now only 2 dimensional curves are supported");
        }
        if (controlPoints[0] == controlPoints[controlPoints.length - 2] && controlPoints[1] == controlPoints[controlPoints.length - 1]) {
            return new CircularRing(controlPoints, (GeometryFactory)this, this.getTolerance());
        }
        return new RiwaCircularString(controlPoints, (GeometryFactory)this, this.getTolerance());
    }

    public LineString createCircularString(CoordinateSequence cs) {
        return new RiwaCircularString(cs, (GeometryFactory)this, this.getTolerance());
    }

    public LineString createCurvedGeometry(CoordinateSequence cs) {
        int lastCoordinate = cs.size() - 1;
        if (cs.size() > 0 && cs.getOrdinate(0, 0) == cs.getOrdinate(lastCoordinate, 0) && cs.getOrdinate(0, 1) == cs.getOrdinate(lastCoordinate, 1)) {
            return new CircularRing(cs, (GeometryFactory)this, this.getTolerance());
        }
        return new RiwaCircularString(cs, (GeometryFactory)this, this.getTolerance());
    }
}

