/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.columns.curved;

import de.riwagis.util.construction.Arc;
import java.util.Arrays;
import java.util.Collection;
import org.geotools.geometry.jts.CircularString;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;

public class RiwaCircularString
extends CircularString {
    static final double EPS = 1.0E-12;
    private LineString linearized = null;

    public RiwaCircularString(double[] controlPoints, GeometryFactory factory, double tolerance) {
        super(controlPoints, factory, tolerance / 100.0);
    }

    public RiwaCircularString(CoordinateSequence points, GeometryFactory factory, double tolerance) {
        super(points, factory, tolerance / 100.0);
    }

    public LineString linearize(double tolerance) {
        boolean isDefaultTolerance = RiwaCircularString.equals(tolerance / 100.0, this.getTolerance());
        if (this.linearized != null && isDefaultTolerance) {
            return this.linearized;
        }
        CoordinateSequence cs = this.getLinearizedCoordinateSequence(tolerance);
        LineString result = new LineString(cs, this.factory);
        if (isDefaultTolerance) {
            this.linearized = result;
        }
        return result;
    }

    public CoordinateSequence getLinearizedCoordinateSequence(double tolerance) {
        boolean isDefaultTolerance = RiwaCircularString.equals(tolerance / 100.0, this.getTolerance());
        if (this.linearized != null && isDefaultTolerance) {
            return this.linearized.getCoordinateSequence();
        }
        CoordinateList resultCoords = new CoordinateList();
        double[] arcControlPoints = new double[6];
        Arc currArc = null;
        for (int i = 0; i <= this.getControlPoints().length - 6; i += 4) {
            System.arraycopy(this.getControlPoints(), i, arcControlPoints, 0, 6);
            Coordinate start = new Coordinate(arcControlPoints[0], arcControlPoints[1]);
            Coordinate middle = new Coordinate(arcControlPoints[2], arcControlPoints[3]);
            Coordinate end = new Coordinate(arcControlPoints[4], arcControlPoints[5]);
            currArc = new Arc(start, middle, end);
            if (currArc.getRadius() == Double.MAX_VALUE) {
                resultCoords.addAll(Arrays.asList(start, middle, end), false);
                continue;
            }
            currArc.setTolerance(tolerance / 100.0);
            resultCoords.addAll((Collection)currArc.getCoordinates(), false);
        }
        return this.getFactory().getCoordinateSequenceFactory().create(resultCoords.toCoordinateArray());
    }

    static boolean equals(double a, double b) {
        return Math.abs(a - b) < 1.0E-12;
    }
}

