/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.columns;

import de.riwagis.riwadatatable.columns.AbstractColumn;
import de.riwagis.riwadatatable.columns.ColumnFactory;
import de.riwagis.riwadatatable.columns.ColumnTypes;
import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.columns.defaultvalues.DefaultValue;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionInfo;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionManager;
import de.riwagis.riwadatatable.validation.ValidationError;
import de.riwagis.riwadatatable.validation.ValidationErrorType;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.jdbc.JDBCSupport;
import de.riwagis.util.lang.StringComparator;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.Normalizer;
import java.util.Comparator;
import org.apache.commons.lang.StringUtils;
import org.geotools.feature.AttributeTypeBuilder;
import org.opengis.feature.type.AttributeDescriptor;

public class TextColumn
extends AbstractColumn {
    private Object objectValue = "";

    private TextColumn(String _strTableName, String _strColumnName, int _intColumnSize, int _intNullable, DefaultValue _defaultValue, JDBCConnectionInfo _connInfo) {
        super(_strTableName, _strColumnName, _intColumnSize, _intNullable, _defaultValue, _connInfo);
        this.setColumnNameExternal(_strColumnName);
    }

    @Override
    public TableColumn cloneColumn(JDBCConnectionManager connMngr) {
        return this.overtakeNotFinalColumnAttributes(new TextColumn(this.getTableName(), this.getColumnName(), this.getColumnSize(), this.getNullable(), this.cloneDefaultValue(connMngr), connMngr.getConnectionInfo()));
    }

    @Override
    public String toString() {
        return this.getColumnName();
    }

    @Override
    public String getInsertString() {
        return "?";
    }

    @Override
    public String getUpdateString() {
        return "?";
    }

    @Override
    public Object getObject(int index, ResultSet rs) throws SystemException {
        try {
            return rs.getString(index);
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    @Override
    public void setString(int index, String str, PreparedStatement stmt) throws SystemException {
        try {
            Object obj = this.parseObject(str);
            stmt.setObject(index, obj, 12);
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    @Override
    public void setObject(int index, Object obj, PreparedStatement stmt) throws SystemException {
        try {
            String strObj = obj != null ? obj.toString() : null;
            stmt.setString(index, strObj);
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    @Override
    public Object parseObject(String source) throws SystemException {
        try {
            if (source == null) {
                return null;
            }
            if (!Normalizer.isNormalized(source, Normalizer.Form.NFC)) {
                return Normalizer.normalize(source, Normalizer.Form.NFC);
            }
            return source;
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    @Override
    public String format(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    @Override
    public ColumnTypes getType() {
        return ColumnTypes.CT_TEXT_COLUMN;
    }

    @Override
    public String getColumnTypeString() {
        return "text";
    }

    @Override
    public char getColumnQuote() {
        return '\'';
    }

    @Override
    public void setStringValue(String strValue) {
        this.objectValue = StringUtils.defaultString((String)strValue);
    }

    @Override
    public String getStringValue() {
        if (this.objectValue == null) {
            return "";
        }
        if (this.objectValue instanceof String) {
            return (String)this.objectValue;
        }
        return this.format(this.objectValue);
    }

    @Override
    public void setObjectValue(Object objValue) {
        this.objectValue = objValue;
    }

    @Override
    public Object getObjectValue() {
        return this.objectValue;
    }

    @Override
    protected ValidationError validateDataString(String data) {
        ValidationError superError = super.validateDataString(data);
        if (superError != null) {
            return superError;
        }
        if (data != null && data.length() > this.getColumnSize() && this.getColumnSize() > 0) {
            return this.validationError4Message(String.format("Datenfeld '%s'. Text \u00fcberschreitet die zul\u00e4ssige L\u00e4nge von %s Zeichen.", this.getColumnNameExternal(), this.getColumnSize()), ValidationErrorType.INVALID_DATA_FORMAT, null);
        }
        return null;
    }

    @Override
    public Comparator<Object> getColumnValueComparator() {
        return new Comparator<Object>(){
            private final Comparator<Object> strComp = new StringComparator();

            @Override
            public int compare(Object o1, Object o2) {
                String str1 = TextColumn.this.format(o1);
                String str2 = TextColumn.this.format(o2);
                return this.strComp.compare(str1, str2);
            }
        };
    }

    @Override
    public AttributeDescriptor buildDescriptor(AttributeTypeBuilder attBuilder) {
        this.adjustTypeBuilder(attBuilder);
        attBuilder.setBinding(String.class);
        return attBuilder.buildDescriptor(this.getColumnName(), attBuilder.buildType());
    }

    static {
        ColumnFactory.addFactory(ColumnTypes.CT_TEXT_COLUMN, new ColumnFactory(){

            @Override
            protected TableColumn create(String strTableName, String strColumnName, int intSQLType, String strSqlTypename, int intColumnSize, int intNullable, DefaultValue defaultValue, JDBCConnectionInfo connInfo) throws SystemException {
                try {
                    return new TextColumn(strTableName, strColumnName, intColumnSize, intNullable, defaultValue, connInfo);
                }
                catch (Exception e) {
                    throw new SystemException("error creating TextColumn: " + e.getMessage(), (Throwable)e);
                }
            }

            @Override
            protected boolean isFactoryFor(int intSqlType, String strSqlTypename, JDBCConnectionInfo connInfo) {
                if (intSqlType == -3 && (connInfo.isMySQL() || connInfo.isMariaDB())) {
                    return true;
                }
                return JDBCSupport.isTextColumn((int)intSqlType);
            }
        });
    }
}

