/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.columns;

import de.riwagis.riwadatatable.columns.ColumnFactory;
import de.riwagis.riwadatatable.columns.ColumnTypes;
import de.riwagis.riwadatatable.columns.DateColumn;
import de.riwagis.riwadatatable.columns.GeometryColumn;
import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.columns.curved.RiwaCurvedGeometryFactory;
import de.riwagis.riwadatatable.columns.defaultvalues.DefaultValue;
import de.riwagis.riwadatatable.columns.util.WKBReader2;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionInfo;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionManager;
import de.riwagis.riwadatatable.validation.ValidationError;
import de.riwagis.riwadatatable.validation.ValidationErrorType;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.jts.JTSSupport;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.geotools.geometry.jts.CurvedGeometries;
import org.geotools.geometry.jts.CurvedGeometry;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.jts.io.WKTWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresGeometryColumn
extends GeometryColumn {
    private static final double DEFAULT_TOLERANCE = 0.01;
    private Integer columnDimension = null;
    private static final Logger LOG = LoggerFactory.getLogger(PostgresGeometryColumn.class);

    private PostgresGeometryColumn(String _strTableName, String _strColumnName, int _intNullable, DefaultValue _defaultValue, JDBCConnectionInfo _connInfo) {
        super(_strTableName, _strColumnName, _intNullable, _defaultValue, _connInfo);
        this.setSelectColName("st_asBinary(" + this.getColumnName() + ") as " + this.getColumnName());
    }

    @Override
    public TableColumn cloneColumn(JDBCConnectionManager connMngr) {
        return this.overtakeNotFinalColumnAttributes(new PostgresGeometryColumn(this.getTableName(), this.getColumnName(), this.getNullable(), this.cloneDefaultValue(connMngr), connMngr.getConnectionInfo()));
    }

    public static int getSRIDbyDatabaseMetadata(Connection conn, String schemaName) throws SQLException, SystemException {
        int intSRID = -1;
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT srid FROM GEOMETRY_COLUMNS where lower(F_TABLE_SCHEMA)='" + schemaName.toLowerCase() + "' and srid is not null ORDER BY SRID");){
            if (rs.next()) {
                intSRID = rs.getInt(1);
            }
        }
        return intSRID;
    }

    private Integer getGeometryColumnDimension(Connection conn2Use) {
        if (this.columnDimension == null) {
            try (Statement stmt = conn2Use.createStatement();
                 ResultSet rs = stmt.executeQuery(String.format("SELECT COORD_DIMENSION FROM GEOMETRY_COLUMNS WHERE lower(F_TABLE_SCHEMA) = '%s' AND lower(F_TABLE_NAME) = '%s' AND lower(F_GEOMETRY_COLUMN) = '%s'", this.getConnectionInfo().getScheme().toLowerCase(), this.getTableName().toLowerCase(), this.getColumnName().toLowerCase()));){
                if (rs.next()) {
                    this.columnDimension = rs.getInt(1);
                }
            }
            catch (Exception ex) {
                LOG.warn(String.format("Failed to retrieve dimension information for %s.%s.%s from the geometry_columns, checking the first geometry instead", this.getConnectionInfo().getScheme().toLowerCase(), this.getTableName().toLowerCase(), this.getColumnName().toLowerCase()));
                this.columnDimension = this.getGeometryDimensionFromFirstGeo(conn2Use);
            }
            if (this.columnDimension == null) {
                this.columnDimension = 2;
            }
        }
        return this.columnDimension;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Integer getGeometryDimensionFromFirstGeo(Connection conn) {
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(String.format("SELECT ST_CoordDim(%s::geometry) FROM %s.%s WHERE %s IS NOT NULL LIMIT 1", this.getColumnName(), this.getConnectionInfo().getScheme(), this.getTableName(), this.getColumnName()));){
            if (!rs.next()) return null;
            Integer n = rs.getInt(1);
            return n;
        }
        catch (Exception e) {
            LOG.warn(String.format("Failed to retrieve dimension information for %s.%s.%s by examining the first sample geometry", this.getConnectionInfo().getScheme().toLowerCase(), this.getTableName().toLowerCase(), this.getColumnName().toLowerCase()));
        }
        return null;
    }

    @Override
    public String getInsertString() {
        return "st_geomFromWKB(?," + this.getConnectionInfo().getSRID() + ")";
    }

    @Override
    public String getUpdateString() {
        return "st_geomFromWKB(?," + this.getConnectionInfo().getSRID() + ")";
    }

    @Override
    public Object getObject(int index, ResultSet rs) throws SystemException {
        try {
            byte[] obj = rs.getBytes(index);
            if (obj != null) {
                return this.getGeometry(obj);
            }
            return obj;
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    @Override
    public void setString(int index, String str, PreparedStatement stmt) throws SystemException {
        try {
            Object obj = this.getDBGeometry(stmt, (Geometry)this.parseObject(str));
            stmt.setObject(index, obj, 1111);
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    @Override
    public void setObject(int index, Object obj, PreparedStatement stmt) throws SystemException {
        try {
            if (obj == null) {
                stmt.setNull(index, 1111);
            }
            if (obj instanceof Geometry) {
                obj = this.getDBGeometry(stmt, (Geometry)obj);
            }
            stmt.setBytes(index, (byte[])obj);
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    @Override
    protected ValidationError validateDataObject(Object data) {
        ValidationError error = super.validateDataObject(data);
        if (error != null) {
            return error;
        }
        if (data != null && !(data instanceof Geometry) && !(data instanceof byte[])) {
            return this.validationError4Message(String.format("Datenfeld '%s'. Ung\u00fcltige Objektart '%s' f\u00fcr Zahl  \u00fcbergeben.", this.getColumnNameExternal(), data.getClass().getCanonicalName()), ValidationErrorType.INVALID_DATA_TYPE, null);
        }
        return null;
    }

    @Override
    public String format(Object obj) {
        if (obj == null) {
            return "";
        }
        try {
            if (obj instanceof Geometry) {
                WKTWriter writer = new WKTWriter();
                return writer.write((Geometry)obj);
            }
            if (obj instanceof byte[]) {
                Geometry geom = this.getGeometry(obj);
                return this.format(geom);
            }
            throw new Exception("format(): invalid object.");
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public Geometry getGeometry(Object obj) throws SystemException {
        try {
            if (obj instanceof Geometry) {
                return (Geometry)obj;
            }
            WKBReader2 reader = new WKBReader2((GeometryFactory)new RiwaCurvedGeometryFactory(0.01));
            Geometry geom = reader.read((byte[])obj);
            if (CurvedGeometries.isCurved((Geometry)geom)) {
                return ((CurvedGeometry)geom).linearize(0.01);
            }
            return geom;
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    @Override
    public Object getDBGeometry(PreparedStatement stmt, Geometry geom) throws SystemException {
        try {
            Integer geomColDimension = this.getGeometryColumnDimension(stmt.getConnection());
            WKBWriter writer = new WKBWriter(geomColDimension.intValue());
            if (geomColDimension >= 3) {
                JTSSupport.to3D((Geometry)geom);
            }
            byte[] arrbyte = writer.write(geom);
            return arrbyte;
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    @Override
    public ColumnTypes getType() {
        return ColumnTypes.CT_POSTGRESGEOMETRY_COLUMN;
    }

    @Override
    public String getEnvelopeString() {
        return "st_asBinary(st_envelope(" + this.getColumnName() + ")) as " + this.getColumnName();
    }

    @Override
    public String getIntersectsString(String geom1, String geom2) {
        return String.format("ST_Intersects(%s, %s)", geom1, geom2);
    }

    @Override
    public String getContainsString(String geom1, String geom2) {
        return String.format("ST_Contains(%s, %s)", geom1, geom2);
    }

    @Override
    public String getOverlapsString(String geom1, String geom2) {
        return String.format("ST_Overlaps(%s, %s)", geom1, geom2);
    }

    @Override
    public String getTouchesString(String geom1, String geom2) {
        return String.format("ST_Touches(%s, %s)", geom1, geom2);
    }

    static {
        ColumnFactory.addFactory(ColumnTypes.CT_POSTGRESGEOMETRY_COLUMN, new ColumnFactory(){

            @Override
            protected TableColumn create(String strTableName, String strColumnName, int intSQLType, String strSqlTypename, int intColumnSize, int intNullable, DefaultValue defaultValue, JDBCConnectionInfo connInfo) throws SystemException {
                try {
                    PostgresGeometryColumn colGeom = new PostgresGeometryColumn(strTableName, strColumnName, intNullable, defaultValue, connInfo);
                    return colGeom;
                }
                catch (Exception e) {
                    throw new SystemException(DateColumn.class, "create():", (Throwable)e);
                }
            }

            @Override
            protected boolean isFactoryFor(int intSqlType, String strSqlTypename, JDBCConnectionInfo connInfo) {
                return connInfo.isPostgres() && strSqlTypename.equalsIgnoreCase("geometry");
            }
        });
    }
}

