/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.columns;

import de.riwagis.riwadatatable.columns.ColumnFactory;
import de.riwagis.riwadatatable.columns.ColumnTypes;
import de.riwagis.riwadatatable.columns.DateColumn;
import de.riwagis.riwadatatable.columns.GeometryColumn;
import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.columns.defaultvalues.DefaultValue;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionInfo;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionManager;
import de.riwagis.riwadatatable.oracle.sdo.GeometryConverter;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.jts.JTSSupport;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Struct;
import oracle.sql.ARRAY;
import oracle.sql.Datum;
import oracle.sql.STRUCT;
import org.apache.commons.lang.StringUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.WKTWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleGeometryColumn
extends GeometryColumn {
    private static final Logger LOG = LoggerFactory.getLogger(OracleGeometryColumn.class);
    public static final double DEFAULT_TOLERANCE = 5.0E-4;
    public static final int DEFAULT_DIMENSION = 2;
    private static GeometryFactory gfac = new GeometryFactory();
    private OracleDatabaseMetadata metaData = null;
    private boolean useOracleStructObjects = false;

    private OracleGeometryColumn(String _strTableName, String _strColumnName, int _intNullable, DefaultValue _defaultValue, JDBCConnectionInfo _connInfo) {
        super(_strTableName, _strColumnName, _intNullable, _defaultValue, _connInfo);
    }

    @Override
    public TableColumn cloneColumn(JDBCConnectionManager connMngr) {
        return this.overtakeNotFinalColumnAttributes(new OracleGeometryColumn(this.getTableName(), this.getColumnName(), this.getNullable(), this.cloneDefaultValue(connMngr), connMngr.getConnectionInfo()));
    }

    @Override
    protected TableColumn overtakeNotFinalColumnAttributes(TableColumn clonedColumn) {
        super.overtakeNotFinalColumnAttributes(clonedColumn);
        ((OracleGeometryColumn)clonedColumn).setUseOracleStructObjects(this.isUseOracleStructObjects());
        return clonedColumn;
    }

    public boolean isUseOracleStructObjects() {
        return this.useOracleStructObjects;
    }

    public void setUseOracleStructObjects(boolean useOracleStructObjects) {
        this.useOracleStructObjects = useOracleStructObjects;
    }

    public static int getSRIDbyDatabaseMetadata(Connection conn) throws SQLException, SystemException {
        int intSRID = -1;
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT SRID FROM USER_SDO_GEOM_METADATA where srid is not null ORDER BY SRID");){
            if (rs.next()) {
                intSRID = rs.getInt(1);
            }
        }
        return intSRID;
    }

    private synchronized OracleDatabaseMetadata getOracleDatabaseMetadata(Connection conn) throws SQLException, SystemException {
        block15: {
            if (this.metaData == null) {
                String sqlStatement = "SELECT SRID,DIMINFO,TABLE_NAME,COLUMN_NAME FROM USER_SDO_GEOM_METADATA where lower(TABLE_NAME)='" + this.getTableName().toLowerCase() + "' and lower(COLUMN_NAME)='" + this.getColumnName().toLowerCase() + "'";
                try (PreparedStatement stmt = conn.prepareStatement(sqlStatement);
                     ResultSet result = stmt.executeQuery(sqlStatement);){
                    if (result.next()) {
                        int retSrid = result.getInt(1);
                        Object obj = result.getObject(2);
                        ARRAY dimarr = (ARRAY)obj;
                        Datum[] arrDatum = dimarr.getOracleArray();
                        Object[] arrDimInfoX = ((Struct)arrDatum[0]).getAttributes();
                        double dblTolerance = 5.0E-4;
                        if (arrDimInfoX.length == 4 && arrDimInfoX[3] instanceof Number) {
                            dblTolerance = ((Number)arrDimInfoX[3]).doubleValue();
                        }
                        this.metaData = new OracleDatabaseMetadata(retSrid, arrDatum.length, dblTolerance);
                        break block15;
                    }
                    throw new SystemException(String.format("No metadata information found in USER_SDO_GEOM_METADATA for %s.%s.", this.getTableName(), this.getColumnName()));
                }
            }
        }
        return this.metaData;
    }

    @Override
    public Object getObject(int index, ResultSet rs) throws SystemException {
        try {
            Object obj = rs.getObject(index);
            if (obj != null && !this.useOracleStructObjects) {
                return this.getGeometry(obj);
            }
            return obj;
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    @Override
    public void setString(int index, String str, PreparedStatement stmt) throws SystemException {
        try {
            Object obj = this.getDBGeometry(stmt, (Geometry)this.parseObject(str));
            stmt.setObject(index, obj, 1111);
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    @Override
    public void setObject(int index, Object obj, PreparedStatement stmt) throws SystemException {
        try {
            if (obj == null) {
                stmt.setNull(index, 2002, "MDSYS.SDO_GEOMETRY");
                return;
            }
            if (obj instanceof Geometry) {
                Geometry geom = (Geometry)obj;
                stmt.setObject(index, this.getDBGeometry(stmt, geom));
            } else {
                stmt.setObject(index, obj);
            }
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    @Override
    public String format(Object obj) {
        if (obj == null) {
            return "";
        }
        try {
            if (obj instanceof Geometry) {
                WKTWriter writer = new WKTWriter(3);
                return writer.write((Geometry)obj);
            }
            if (obj instanceof STRUCT) {
                Geometry geom = this.getGeometry(obj);
                return this.format(geom);
            }
            throw new Exception("format(): invalid object.");
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public Geometry getGeometry(Object obj) throws SystemException {
        try {
            if (obj instanceof Geometry) {
                return (Geometry)obj;
            }
            if (obj instanceof STRUCT) {
                return GeometryConverter.asGeometry((STRUCT)obj, gfac, 5.0E-4);
            }
            throw new Exception("invalid geometry object.");
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    @Override
    public Object getDBGeometry(PreparedStatement pstmt, Geometry geom) throws SystemException {
        try {
            OracleDatabaseMetadata sdoMetaData = this.getOracleDatabaseMetadata(pstmt.getConnection());
            if (sdoMetaData.getDimension() == 2) {
                JTSSupport.to2D((Geometry)geom);
            } else {
                JTSSupport.to3D((Geometry)geom);
            }
            GeometryConverter gconv = new GeometryConverter(pstmt.getConnection());
            return gconv.toSDO(geom, this.getConnectionInfo().getSRID());
        }
        catch (SQLException e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    @Override
    public ColumnTypes getType() {
        return ColumnTypes.CT_ORACLEGEOMETRY_COLUMN;
    }

    @Override
    public String getEnvelopeString() {
        return "SDO_GEOM.SDO_MBR(" + this.getColumnName() + ") as " + this.getColumnName();
    }

    @Override
    public String getIntersectsString(String geom1, String geom2) {
        return String.format("SDO_RELATE(%s, %s, 'mask=ANYINTERACT') = 'TRUE'", geom1, geom2);
    }

    @Override
    public String getContainsString(String geom1, String geom2) {
        return String.format("SDO_RELATE(%s, %s, 'mask=CONTAINS') = 'TRUE'", geom1, geom2);
    }

    @Override
    public String getOverlapsString(String geom1, String geom2) {
        return String.format("SDO_RELATE(%s, %s, 'mask=OVERLAPBDYDISJOINT+OVERLAPBDYINTERSECT') = 'TRUE'", geom1, geom2);
    }

    @Override
    public String getTouchesString(String geom1, String geom2) {
        return String.format("SDO_RELATE(%s, %s, 'mask=TOUCH') = 'TRUE'", geom1, geom2);
    }

    static {
        ColumnFactory.addFactory(ColumnTypes.CT_ORACLEGEOMETRY_COLUMN, new ColumnFactory(){

            @Override
            protected TableColumn create(String strTableName, String strColumnName, int intSQLType, String strSqlTypename, int intColumnSize, int intNullable, DefaultValue defaultValue, JDBCConnectionInfo connInfo) throws SystemException {
                try {
                    OracleGeometryColumn colGeom = new OracleGeometryColumn(strTableName, strColumnName, intNullable, defaultValue, connInfo);
                    return colGeom;
                }
                catch (Exception e) {
                    throw new SystemException(DateColumn.class, "create():", (Throwable)e);
                }
            }

            @Override
            protected boolean isFactoryFor(int intSqlType, String strSqlTypename, JDBCConnectionInfo connInfo) {
                return connInfo.isOracle() && StringUtils.endsWithIgnoreCase((String)strSqlTypename, (String)"SDO_GEOMETRY");
            }
        });
    }

    public static class OracleDatabaseMetadata {
        private int srid = -1;
        private int dimension = 2;
        private double tolerance = 5.0E-4;

        private OracleDatabaseMetadata(int srid, int dimension, double tolerance) {
            this.srid = srid;
            this.dimension = dimension;
            this.tolerance = tolerance;
        }

        public int getSrid() {
            return this.srid;
        }

        public int getDimension() {
            return this.dimension;
        }

        public double getTolerance() {
            return this.tolerance;
        }
    }
}

