/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.columns;

import de.riwagis.riwadatatable.columns.AbstractColumn;
import de.riwagis.riwadatatable.columns.ColumnFactory;
import de.riwagis.riwadatatable.columns.ColumnTypes;
import de.riwagis.riwadatatable.columns.Formatable;
import de.riwagis.riwadatatable.columns.NumberColType;
import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.columns.defaultvalues.DefaultValue;
import de.riwagis.riwadatatable.columns.util.StringPreparator;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionInfo;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionManager;
import de.riwagis.riwadatatable.validation.ValidationError;
import de.riwagis.riwadatatable.validation.ValidationErrorType;
import de.riwagis.util.Config;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.jdbc.JDBCSupport;
import de.riwagis.util.lang.NumberComparator;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Comparator;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.geotools.feature.AttributeTypeBuilder;
import org.opengis.feature.type.AttributeDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberColumn
extends AbstractColumn
implements Formatable {
    private static final Logger LOG = LoggerFactory.getLogger(NumberColumn.class);
    private static final long serialVersionUID = -3171118736403579942L;
    private Object objectValue = "";
    private StringPreparator prepString = null;
    private Format fmtColumnFormatter = null;
    private static final NumberFormat DEFAULT_FORMAT = NumberFormat.getNumberInstance(Config.LOCALE);
    private boolean autoIncrement = false;
    private NumberColType numType = null;
    private final int intSQLType;

    private NumberColumn(String _strTableName, String _strColumnName, int _intSQLType, int _intColumnSize, int _intNullable, DefaultValue _defaultValue, JDBCConnectionInfo _connInfo) {
        super(_strTableName, _strColumnName, _intColumnSize, _intNullable, _defaultValue, _connInfo);
        this.intSQLType = _intSQLType;
        this.setColumnNameExternal(_strColumnName);
        this.fmtColumnFormatter = DEFAULT_FORMAT;
        this.prepString = StringPreparator.buildPreparator(this.fmtColumnFormatter, Config.LOCALE);
        this.numType = NumberColType.numberTypeForSqlType(this.intSQLType);
    }

    @Override
    protected TableColumn overtakeNotFinalColumnAttributes(TableColumn clonedColumn) {
        super.overtakeNotFinalColumnAttributes(clonedColumn);
        ((NumberColumn)clonedColumn).setNumberType(this.getNumberType());
        ((NumberColumn)clonedColumn).prepString = this.prepString;
        if (this.fmtColumnFormatter != DEFAULT_FORMAT) {
            ((NumberColumn)clonedColumn).fmtColumnFormatter = (Format)this.fmtColumnFormatter.clone();
        }
        ((NumberColumn)clonedColumn).setAutoIncrement(this.autoIncrement);
        return clonedColumn;
    }

    @Override
    public TableColumn cloneColumn(JDBCConnectionManager connMngr) {
        return this.overtakeNotFinalColumnAttributes(new NumberColumn(this.getTableName(), this.getColumnName(), this.intSQLType, this.getColumnSize(), this.getNullable(), this.cloneDefaultValue(connMngr), connMngr.getConnectionInfo()));
    }

    public Object adjustNumberType(Object obj) {
        if (obj == null || this.numType == null || !(obj instanceof Number)) {
            return obj;
        }
        return this.numType.numberOfType((Number)obj, this.isUnsigned());
    }

    private Object booleanToNumber(Object obj) {
        if (obj instanceof Boolean) {
            obj = BooleanUtils.toIntegerObject((Boolean)((Boolean)obj));
        }
        return obj;
    }

    public void setNumberType(NumberColType _numType) {
        this.numType = _numType;
    }

    public NumberColType getNumberType() {
        return this.numType;
    }

    public NumberColumn copyOf() {
        try {
            NumberColumn colClone = new NumberColumn(this.getTableName(), this.getColumnName(), this.intSQLType, this.getColumnSize(), this.getNullable(), this.defaultValue, this.getConnectionInfo());
            colClone.setColumnNameExternal(this.getColumnNameExternal());
            colClone.setFormat(this.fmtColumnFormatter);
            return colClone;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String toString() {
        return this.getColumnName();
    }

    @Override
    public String getInsertString() {
        return "?";
    }

    @Override
    public String getUpdateString() {
        return "?";
    }

    @Override
    public Object getObject(int index, ResultSet rs) throws SystemException {
        try {
            return this.adjustNumberType(this.booleanToNumber(rs.getObject(index)));
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), String.format("Column: %s.%s (Typ: %s): %s", new Object[]{this.getTableName(), this.getColumnName(), this.getNumberType(), e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public void setString(int index, String str, PreparedStatement stmt) throws SystemException {
        try {
            this.setObject(index, this.parseObject(str), stmt);
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), String.format("Column: %s.%s (Typ: %s) Value [%s]: %s", new Object[]{this.getTableName(), this.getColumnName(), this.getNumberType(), str, e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public void setObject(int index, Object obj, PreparedStatement stmt) throws SystemException {
        try {
            if (this.getNumberType() == NumberColType.TYPE_LONG && obj != null && obj instanceof Long) {
                stmt.setLong(index, (Long)obj);
            } else {
                stmt.setObject(index, obj, 2);
            }
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), String.format("Column: %s.%s (Typ: %s) Value [%s]: %s", new Object[]{this.getTableName(), this.getColumnName(), this.getNumberType(), obj, e.getMessage()}), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object parseObject(String source) throws SystemException {
        try {
            if (StringUtils.isBlank((String)source)) {
                return null;
            }
            String preparedSource = this.prepString.prepareString(source.trim());
            Format format = this.fmtColumnFormatter;
            synchronized (format) {
                return this.adjustNumberType(this.fmtColumnFormatter.parseObject(preparedSource));
            }
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), String.format("Column: %s.%s (Typ: %s) Value [%s]: %s", new Object[]{this.getTableName(), this.getColumnName(), this.getNumberType(), source, e.getMessage()}), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String format(Object obj) {
        try {
            if (obj instanceof String) {
                return (String)obj;
            }
            if (obj == null || obj.toString().isEmpty()) {
                return "";
            }
            if (obj instanceof Boolean) {
                if (((Boolean)obj).booleanValue()) {
                    return "1";
                }
                return "0";
            }
            if (this.fmtColumnFormatter == null) {
                return obj.toString();
            }
            Format format = this.fmtColumnFormatter;
            synchronized (format) {
                return this.fmtColumnFormatter.format(obj);
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Column: %s.%s (Typ: %s) Value [%s]: %s", new Object[]{this.getTableName(), this.getColumnName(), this.getNumberType(), obj, e.getMessage()}), e);
        }
    }

    private void setFormat(Format _ColumnFormatter) throws SystemException {
        if (!(_ColumnFormatter instanceof NumberFormat)) {
            throw new SystemException(this.getClass(), "invalid format for column type");
        }
        this.fmtColumnFormatter = _ColumnFormatter;
        this.prepString = StringPreparator.buildPreparator(this.fmtColumnFormatter, Config.LOCALE);
    }

    @Override
    public void setFormat(String strFormatString) throws SystemException {
        this.setFormat(new DecimalFormat(strFormatString));
    }

    @Override
    public ColumnTypes getType() {
        return ColumnTypes.CT_NUMBER_COLUMN;
    }

    @Override
    public String getColumnTypeString() {
        return "number";
    }

    @Override
    public char getColumnQuote() {
        return ' ';
    }

    @Override
    public void setStringValue(String strValue) {
        this.objectValue = StringUtils.defaultString((String)strValue);
    }

    @Override
    public String getStringValue() {
        if (this.objectValue == null) {
            return "";
        }
        if (this.objectValue instanceof String) {
            return (String)this.objectValue;
        }
        return this.format(this.objectValue);
    }

    @Override
    public void setObjectValue(Object objValue) {
        this.objectValue = this.adjustNumberType(this.booleanToNumber(objValue));
    }

    @Override
    public Object getObjectValue() {
        return this.objectValue;
    }

    @Override
    protected ValidationError validateDataString(String data) {
        ValidationError superError = super.validateDataString(data);
        if (superError != null) {
            if (superError.getType() == ValidationErrorType.NULL_NOT_ALLOWED) {
                return superError;
            }
            if (superError.getLinkedException() != null && superError.getLinkedException() instanceof ArithmeticException) {
                return this.validationError4Message(String.format("Datenfeld '%s'. Zahl au\u00dferhalb des g\u00fcltigen Bereichs. (Ihre Eingabe: [%s], Fehlermeldung: '%s')", this.getColumnNameExternal(), data, superError.getErrorMessage()), ValidationErrorType.INVALID_DATA_FORMAT, superError.getLinkedException());
            }
            return this.validationError4Message(String.format("Datenfeld '%s'. Bitte geben sie eine g\u00fcltige Zahl ein. (Ihre Eingabe: [%s], Fehlermeldung: '%s')", this.getColumnNameExternal(), data, superError.getErrorMessage()), ValidationErrorType.INVALID_DATA_FORMAT, null);
        }
        return null;
    }

    @Override
    protected ValidationError validateDataObject(Object data) {
        ValidationError error = super.validateDataObject(data);
        if (error != null) {
            return error;
        }
        if (data != null) {
            if (!(data instanceof Number) && !(data instanceof Boolean)) {
                return this.validationError4Message(String.format("Datenfeld '%s'. Ung\u00fcltige Objektart '%s' f\u00fcr Zahl  \u00fcbergeben.", this.getColumnNameExternal(), data.getClass().getCanonicalName()), ValidationErrorType.INVALID_DATA_TYPE, null);
            }
            try {
                this.adjustNumberType(this.booleanToNumber(data));
            }
            catch (Throwable t) {
                return this.validationError4Message(String.format("Datenfeld '%s'. Zahl au\u00dferhalb des g\u00fcltigen Bereichs. (Ihre Eingabe: [%s], Fehlermeldung: '%s')", this.getColumnNameExternal(), data, t.getMessage()), ValidationErrorType.INVALID_DATA_FORMAT, t);
            }
        }
        return null;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    @Override
    public Comparator<Object> getColumnValueComparator() {
        Comparator<Object> x = new Comparator<Object>(){
            private final Comparator<Object> nComp = new NumberComparator();

            @Override
            public int compare(Object o1, Object o2) {
                return this.nComp.compare(o1, o2);
            }
        };
        return x;
    }

    @Override
    public AttributeDescriptor buildDescriptor(AttributeTypeBuilder attBuilder) {
        this.adjustTypeBuilder(attBuilder);
        attBuilder.setBinding(this.numType.getTypeClass(this.isUnsigned()));
        return attBuilder.buildDescriptor(this.getColumnName(), attBuilder.buildType());
    }

    static {
        DEFAULT_FORMAT.setGroupingUsed(false);
        DEFAULT_FORMAT.setMinimumFractionDigits(0);
        DEFAULT_FORMAT.setMaximumFractionDigits(9);
        ColumnFactory.addFactory(ColumnTypes.CT_NUMBER_COLUMN, new ColumnFactory(){

            @Override
            protected TableColumn create(String strTableName, String strColumnName, int intSQLType, String strSqlTypename, int intColumnSize, int intNullable, DefaultValue defaultValue, JDBCConnectionInfo connInfo) throws SystemException {
                try {
                    return new NumberColumn(strTableName, strColumnName, intSQLType, -1, intNullable, defaultValue, connInfo);
                }
                catch (Exception e) {
                    throw new SystemException("error creating NumberColumn: " + e.getMessage(), (Throwable)e);
                }
            }

            @Override
            protected boolean isFactoryFor(int intSqlType, String strSqlTypename, JDBCConnectionInfo connInfo) {
                return JDBCSupport.isNumericColumn((int)intSqlType) || JDBCSupport.isBooleanColumn((int)intSqlType);
            }
        });
    }
}

