/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.columns;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.EnumSet;
import java.util.Set;

public enum NumberColType {
    TYPE_BOOLEAN(Boolean.class, -7, 16),
    TYPE_BYTE(Byte.class, -6),
    TYPE_SHORT(Short.class, 5),
    TYPE_INTEGER(Integer.class, 4),
    TYPE_LONG(Long.class, -5),
    TYPE_FLOAT(Float.class, 7),
    TYPE_DOUBLE(Double.class, 8, 6),
    TYPE_BIG_INTEGER(BigInteger.class, new int[0]),
    TYPE_BIG_DECIMAL(BigDecimal.class, 2, 3),
    TYPE_UNKNOWN(Object.class, new int[0]);

    public static final Set<NumberColType> DECIMAL_COLUMNS;
    private static final String TXT_VALUE_TO_LARGE = "value '%s' to large for %s %s";
    private static final String TXT_UNSIGNED = "unsigned";
    private static final String TXT_SIGNED = "signed";
    private final Class<?> typeClass;
    private final int[] sqlTypes;

    private NumberColType(Class<?> _typeClass, int ... _sqlTypes) {
        this.typeClass = _typeClass;
        this.sqlTypes = _sqlTypes;
    }

    public static NumberColType numberTypeForSqlType(int sqlType) {
        for (NumberColType currT : NumberColType.values()) {
            for (int currSQLType : currT.getSqlTypes()) {
                if (sqlType != currSQLType) continue;
                return currT;
            }
        }
        return TYPE_UNKNOWN;
    }

    public Class<?> getTypeClass() {
        return this.typeClass;
    }

    public Class<?> getTypeClass(boolean unsigned) {
        if (unsigned) {
            if (this.typeClass.equals(Integer.class)) {
                return Long.class;
            }
            if (this.typeClass.equals(Byte.class)) {
                return Short.class;
            }
            if (this.typeClass.equals(Short.class)) {
                return Integer.class;
            }
            return this.typeClass;
        }
        return this.typeClass;
    }

    public int getSqlType() {
        return this.getSqlTypes().length > 0 ? this.getSqlTypes()[0] : 1111;
    }

    public int[] getSqlTypes() {
        return this.sqlTypes;
    }

    public boolean isOfType(Class<?> clazz) {
        return clazz.equals(this.typeClass);
    }

    public Number numberOfType(Number number2check, boolean isUnsigned) {
        if ((this.typeClass.equals(Object.class) || this.isOfType(number2check.getClass())) && !isUnsigned) {
            return number2check;
        }
        if (number2check != null) {
            long numberLongValue = number2check.longValue();
            double numberDoubleValue = number2check.doubleValue();
            if (this.typeClass.equals(Integer.class)) {
                if (isUnsigned) {
                    if (numberLongValue > 0xFFFFFFFFL || numberLongValue < 0L) {
                        throw new ArithmeticException(String.format(TXT_VALUE_TO_LARGE, number2check, TXT_UNSIGNED, Integer.class));
                    }
                    return number2check.longValue();
                }
                if (numberLongValue > Integer.MAX_VALUE || numberLongValue < Integer.MIN_VALUE) {
                    throw new ArithmeticException(String.format(TXT_VALUE_TO_LARGE, number2check, TXT_SIGNED, Integer.class));
                }
                return number2check.intValue();
            }
            if (this.typeClass.equals(Byte.class)) {
                if (isUnsigned) {
                    if (numberLongValue > 255L || numberLongValue < 0L) {
                        throw new ArithmeticException(String.format(TXT_VALUE_TO_LARGE, number2check, TXT_UNSIGNED, Byte.class));
                    }
                    return number2check.shortValue();
                }
                if (numberLongValue > 127L || numberLongValue < -128L) {
                    throw new ArithmeticException(String.format(TXT_VALUE_TO_LARGE, number2check, TXT_SIGNED, Byte.class));
                }
                return number2check.byteValue();
            }
            if (this.typeClass.equals(Short.class)) {
                if (isUnsigned) {
                    if (numberLongValue > 65535L || numberLongValue < 0L) {
                        throw new ArithmeticException(String.format(TXT_VALUE_TO_LARGE, number2check, TXT_UNSIGNED, Short.class));
                    }
                    return number2check.intValue();
                }
                if (numberLongValue > 32767L || numberLongValue < -32768L) {
                    throw new ArithmeticException(String.format(TXT_VALUE_TO_LARGE, number2check, TXT_SIGNED, Short.class));
                }
                return number2check.shortValue();
            }
            if (this.typeClass.equals(Long.class)) {
                return numberLongValue;
            }
            if (this.typeClass.equals(Float.class)) {
                if (numberDoubleValue > 3.4028234663852886E38 || numberDoubleValue < -3.4028234663852886E38) {
                    throw new ArithmeticException(String.format("value '%s' to large for %s", number2check, Float.class));
                }
                return Float.valueOf(number2check.floatValue());
            }
            if (this.typeClass.equals(Double.class)) {
                return number2check.doubleValue();
            }
            if (this.typeClass.equals(BigInteger.class)) {
                return BigInteger.valueOf(numberLongValue);
            }
            if (this.typeClass.equals(BigDecimal.class)) {
                if (number2check instanceof Long) {
                    return BigDecimal.valueOf(numberLongValue);
                }
                return BigDecimal.valueOf(numberDoubleValue);
            }
            if (this.typeClass.equals(Boolean.class)) {
                return numberLongValue == 0L ? 0 : 1;
            }
        }
        return number2check;
    }

    static {
        DECIMAL_COLUMNS = EnumSet.of(TYPE_DOUBLE, TYPE_FLOAT, TYPE_BIG_DECIMAL);
    }
}

