/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.columns;

import de.riwagis.riwadatatable.columns.ColumnFactory;
import de.riwagis.riwadatatable.columns.ColumnTypes;
import de.riwagis.riwadatatable.columns.DateColumn;
import de.riwagis.riwadatatable.columns.GeometryColumn;
import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.columns.defaultvalues.DefaultValue;
import de.riwagis.riwadatatable.columns.util.MySQLWktWriter;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionInfo;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionManager;
import de.riwagis.riwadatatable.validation.ValidationError;
import de.riwagis.riwadatatable.validation.ValidationErrorType;
import de.riwagis.util.exception.SystemException;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.geotools.feature.AttributeTypeBuilder;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.InStream;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKTWriter;

public class MySqlGeometryColumn
extends GeometryColumn {
    public static final String OPENGIS_EMPTY_COLLECTION_WKT = "GEOMETRYCOLLECTION EMPTY";
    public static final String MSQ_EMPY_COLLECTION_WKT = "GEOMETRYCOLLECTION()";
    private static final Collection<String> GEOMETRY_TYPE_NAMES = new LinkedHashSet<String>();

    private MySqlGeometryColumn(String _strTableName, String _strColumnName, int _intNullable, DefaultValue _defaultValue, JDBCConnectionInfo _connInfo) {
        super(_strTableName, _strColumnName, _intNullable, _defaultValue, _connInfo);
        this.setSelectColName("ST_AsBinary(" + this.getColumnName() + ") as " + this.getColumnName());
    }

    @Override
    public TableColumn cloneColumn(JDBCConnectionManager connMngr) {
        return this.overtakeNotFinalColumnAttributes(new MySqlGeometryColumn(this.getTableName(), this.getColumnName(), this.getNullable(), this.cloneDefaultValue(connMngr), connMngr.getConnectionInfo()));
    }

    private int getSrid4MySQL() {
        int srid = this.getConnectionInfo().getSRID();
        if (srid == -1) {
            srid = 0;
        }
        return srid;
    }

    @Override
    public String getInsertString() {
        return "ST_GeomFromText(?," + this.getSrid4MySQL() + ")";
    }

    @Override
    public String getUpdateString() {
        return "ST_GeomFromText(?," + this.getSrid4MySQL() + ")";
    }

    @Override
    public Object getObject(int index, ResultSet rs) throws SystemException {
        try {
            byte[] obj = rs.getBytes(index);
            if (obj != null) {
                return this.getGeometry(obj);
            }
            return obj;
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    @Override
    public void setString(int index, String str, PreparedStatement stmt) throws SystemException {
        try {
            Object obj = this.getDBGeometry(stmt, (Geometry)this.parseObject(str));
            stmt.setObject(index, obj, 1111);
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    @Override
    public void setObject(int index, Object obj, PreparedStatement stmt) throws SystemException {
        try {
            if (obj == null) {
                stmt.setNull(index, 1111);
            }
            if (obj instanceof Geometry) {
                obj = this.getDBGeometry(stmt, (Geometry)obj);
            }
            if (!OPENGIS_EMPTY_COLLECTION_WKT.equalsIgnoreCase((String)obj)) {
                stmt.setString(index, (String)obj);
            } else {
                stmt.setString(index, MSQ_EMPY_COLLECTION_WKT);
            }
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    @Override
    public String format(Object obj) {
        if (obj == null) {
            return "";
        }
        try {
            if (obj instanceof Geometry) {
                WKTWriter writer = new WKTWriter();
                return writer.write((Geometry)obj);
            }
            if (obj instanceof byte[]) {
                Geometry geom = this.getGeometry(obj);
                return this.format(geom);
            }
            throw new Exception("format(): invalid object.");
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public Geometry getGeometry(Object obj) throws SystemException {
        try {
            if (obj instanceof Geometry) {
                return (Geometry)obj;
            }
            WKBReader reader = new WKBReader();
            ByteArrayInStream inStream = new ByteArrayInStream();
            inStream.setBytes((byte[])obj);
            return reader.read((InStream)inStream);
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    @Override
    protected ValidationError validateDataObject(Object data) {
        ValidationError error = super.validateDataObject(data);
        if (error != null) {
            return error;
        }
        if (data != null && !(data instanceof Geometry) && !(data instanceof byte[])) {
            return this.validationError4Message(String.format("Datenfeld '%s'. Ung\u00fcltige Objektart '%s' f\u00fcr Zahl  \u00fcbergeben.", this.getColumnNameExternal(), data.getClass().getCanonicalName()), ValidationErrorType.INVALID_DATA_TYPE, null);
        }
        return null;
    }

    @Override
    public Object getDBGeometry(PreparedStatement pstmt, Geometry geom) throws SystemException {
        try {
            MySQLWktWriter writer = new MySQLWktWriter();
            String wkt = writer.write(geom);
            return wkt;
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    @Override
    public ColumnTypes getType() {
        return ColumnTypes.CT_MYSQLGEOMETRY_COLUMN;
    }

    @Override
    public String getEnvelopeString() {
        return "ST_AsBinary(ST_Envelope(" + this.getColumnName() + ")) as " + this.getColumnName();
    }

    @Override
    public String getIntersectsString(String geom1, String geom2) {
        return String.format("ST_Intersects(%s, %s) = 1", geom1, geom2);
    }

    @Override
    public String getContainsString(String geom1, String geom2) {
        return String.format("ST_Contains(%s, %s) = 1", geom1, geom2);
    }

    @Override
    public String getOverlapsString(String geom1, String geom2) {
        return String.format("ST_Overlaps(%s, %s) = 1", geom1, geom2);
    }

    @Override
    public String getTouchesString(String geom1, String geom2) {
        return String.format("ST_Touches(%s, %s) = 1", geom1, geom2);
    }

    @Override
    protected void adjustTypeBuilder(AttributeTypeBuilder attBuilder) {
        super.adjustTypeBuilder(attBuilder);
        attBuilder.setNillable(true);
    }

    static {
        GEOMETRY_TYPE_NAMES.add("geometry");
        GEOMETRY_TYPE_NAMES.add("geometrycollection");
        GEOMETRY_TYPE_NAMES.add("point");
        GEOMETRY_TYPE_NAMES.add("multipoint");
        GEOMETRY_TYPE_NAMES.add("linestring");
        GEOMETRY_TYPE_NAMES.add("multilinestring");
        GEOMETRY_TYPE_NAMES.add("polygon");
        GEOMETRY_TYPE_NAMES.add("multipolygon");
        ColumnFactory.addFactory(ColumnTypes.CT_MYSQLGEOMETRY_COLUMN, new ColumnFactory(){

            @Override
            protected TableColumn create(String strTableName, String strColumnName, int intSQLType, String strSqlTypename, int intColumnSize, int intNullable, DefaultValue defaultValue, JDBCConnectionInfo connInfo) throws SystemException {
                try {
                    MySqlGeometryColumn colMySQL = new MySqlGeometryColumn(strTableName, strColumnName, intNullable, defaultValue, connInfo);
                    return colMySQL;
                }
                catch (Exception e) {
                    throw new SystemException(DateColumn.class, "create():", (Throwable)e);
                }
            }

            @Override
            protected boolean isFactoryFor(int intSqlType, String strSqlTypename, JDBCConnectionInfo connInfo) {
                if (connInfo.isMySQL() || connInfo.isMariaDB()) {
                    return GEOMETRY_TYPE_NAMES.contains(strSqlTypename.toLowerCase());
                }
                return false;
            }
        });
    }

    private static class ByteArrayInStream
    implements InStream {
        private byte[] buffer;
        private int position;

        private ByteArrayInStream() {
        }

        public void setBytes(byte[] buffer) {
            this.buffer = buffer;
            this.position = 0;
        }

        public int read(byte[] bytes) throws IOException {
            int size = bytes.length;
            System.arraycopy(this.buffer, this.position, bytes, 0, size);
            this.position += size;
            return size;
        }
    }
}

